/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.models;

import io.getstream.chat.android.models.AndFilterObject;
import io.getstream.chat.android.models.AutocompleteFilterObject;
import io.getstream.chat.android.models.ContainsFilterObject;
import io.getstream.chat.android.models.DistinctFilterObject;
import io.getstream.chat.android.models.EqualsFilterObject;
import io.getstream.chat.android.models.ExistsFilterObject;
import io.getstream.chat.android.models.FilterObject;
import io.getstream.chat.android.models.GreaterThanFilterObject;
import io.getstream.chat.android.models.GreaterThanOrEqualsFilterObject;
import io.getstream.chat.android.models.InFilterObject;
import io.getstream.chat.android.models.LessThanFilterObject;
import io.getstream.chat.android.models.LessThanOrEqualsFilterObject;
import io.getstream.chat.android.models.NeutralFilterObject;
import io.getstream.chat.android.models.NorFilterObject;
import io.getstream.chat.android.models.NotEqualsFilterObject;
import io.getstream.chat.android.models.NotExistsFilterObject;
import io.getstream.chat.android.models.NotInFilterObject;
import io.getstream.chat.android.models.OrFilterObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0016\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J)\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0006\"\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0006\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0007J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\b\u0010\u001c\u001a\u00020\u0004H\u0007J)\u0010\u001d\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0006\"\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J)\u0010\u001d\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0006\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0007J!\u0010\u001e\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J!\u0010 \u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006!"}, d2={"Lio/getstream/chat/android/models/Filters;", "", "()V", "and", "Lio/getstream/chat/android/models/FilterObject;", "filters", "", "([Lio/getstream/chat/android/models/FilterObject;)Lio/getstream/chat/android/models/FilterObject;", "autocomplete", "fieldName", "", "value", "contains", "distinct", "memberIds", "", "eq", "exists", "greaterThan", "greaterThanEquals", "in", "values", "", "(Ljava/lang/String;[Ljava/lang/Number;)Lio/getstream/chat/android/models/FilterObject;", "(Ljava/lang/String;[Ljava/lang/String;)Lio/getstream/chat/android/models/FilterObject;", "lessThan", "lessThanEquals", "ne", "neutral", "nin", "nor", "notExists", "or", "stream-chat-android-core"})
public final class Filters {
    @NotNull
    public static final Filters INSTANCE = new Filters();

    private Filters() {
    }

    @JvmStatic
    @NotNull
    public static final FilterObject neutral() {
        return NeutralFilterObject.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final FilterObject exists(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return new ExistsFilterObject(fieldName);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject notExists(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return new NotExistsFilterObject(fieldName);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject contains(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new ContainsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject and(FilterObject ... filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return new AndFilterObject(ArraysKt.toSet((Object[])filters));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject or(FilterObject ... filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return new OrFilterObject(ArraysKt.toSet((Object[])filters));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject nor(FilterObject ... filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return new NorFilterObject(ArraysKt.toSet((Object[])filters));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject eq(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new EqualsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject ne(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new NotEqualsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject greaterThan(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new GreaterThanFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject greaterThanEquals(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new GreaterThanOrEqualsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject lessThan(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new LessThanFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject lessThanEquals(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new LessThanOrEqualsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject in(@NotNull String fieldName, String ... values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new InFilterObject(fieldName, ArraysKt.toSet((Object[])values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject in(@NotNull String fieldName, @NotNull List<? extends Object> values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new InFilterObject(fieldName, CollectionsKt.toSet((Iterable)values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject in(@NotNull String fieldName, Number ... values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new InFilterObject(fieldName, ArraysKt.toSet((Object[])values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject nin(@NotNull String fieldName, String ... values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new NotInFilterObject(fieldName, ArraysKt.toSet((Object[])values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject nin(@NotNull String fieldName, @NotNull List<? extends Object> values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new NotInFilterObject(fieldName, CollectionsKt.toSet((Iterable)values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject nin(@NotNull String fieldName, Number ... values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new NotInFilterObject(fieldName, ArraysKt.toSet((Object[])values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject autocomplete(@NotNull String fieldName, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new AutocompleteFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject distinct(@NotNull List<String> memberIds) {
        Intrinsics.checkNotNullParameter(memberIds, (String)"memberIds");
        return new DistinctFilterObject(CollectionsKt.toSet((Iterable)memberIds));
    }
}

