/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.errors;

import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.result.Error;
import java.net.UnknownHostException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0005H\u0007\u001a*\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0007\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0005H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"HTTP_API_ERROR", "", "HTTP_TIMEOUT", "HTTP_TOO_MANY_REQUESTS", "copyWithMessage", "Lio/getstream/result/Error;", "message", "", "extractCause", "", "fromChatErrorCode", "Lio/getstream/result/Error$NetworkError;", "Lio/getstream/result/Error$NetworkError$Companion;", "chatErrorCode", "Lio/getstream/chat/android/client/errors/ChatErrorCode;", "statusCode", "cause", "isPermanent", "", "stream-chat-android-core"})
public final class ChatErrorKt {
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final int HTTP_TIMEOUT = 408;
    private static final int HTTP_API_ERROR = 500;

    @InternalStreamChatApi
    @NotNull
    public static final Error.NetworkError fromChatErrorCode(@NotNull Error.NetworkError.Companion $this$fromChatErrorCode, @NotNull ChatErrorCode chatErrorCode, int statusCode, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)$this$fromChatErrorCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)chatErrorCode), (String)"chatErrorCode");
        return new Error.NetworkError(chatErrorCode.getDescription(), chatErrorCode.getCode(), statusCode, cause);
    }

    public static /* synthetic */ Error.NetworkError fromChatErrorCode$default(Error.NetworkError.Companion companion, ChatErrorCode chatErrorCode, int n, Throwable throwable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        return ChatErrorKt.fromChatErrorCode(companion, chatErrorCode, n, throwable);
    }

    @InternalStreamChatApi
    public static final boolean isPermanent(@NotNull Error $this$isPermanent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPermanent, (String)"<this>");
        if ($this$isPermanent instanceof Error.NetworkError) {
            Object[] objectArray = new Integer[]{429, 408, 500};
            List temporaryErrors = CollectionsKt.listOf((Object[])objectArray);
            bl = temporaryErrors.contains(((Error.NetworkError)$this$isPermanent).getStatusCode()) ? false : !(((Error.NetworkError)$this$isPermanent).getCause() instanceof UnknownHostException);
        } else {
            bl = false;
        }
        return bl;
    }

    @InternalStreamChatApi
    @NotNull
    public static final Error copyWithMessage(@NotNull Error $this$copyWithMessage, @NotNull String message) {
        Error error;
        Intrinsics.checkNotNullParameter((Object)$this$copyWithMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Error error2 = $this$copyWithMessage;
        if (error2 instanceof Error.GenericError) {
            error = (Error)((Error.GenericError)$this$copyWithMessage).copy(message);
        } else if (error2 instanceof Error.NetworkError) {
            error = (Error)Error.NetworkError.copy$default((Error.NetworkError)((Error.NetworkError)$this$copyWithMessage), (String)message, (int)0, (int)0, null, (int)14, null);
        } else if (error2 instanceof Error.ThrowableError) {
            error = (Error)Error.ThrowableError.copy$default((Error.ThrowableError)((Error.ThrowableError)$this$copyWithMessage), (String)message, null, (int)2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return error;
    }

    @InternalStreamChatApi
    @Nullable
    public static final Throwable extractCause(@NotNull Error $this$extractCause) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)$this$extractCause, (String)"<this>");
        Error error = $this$extractCause;
        if (error instanceof Error.GenericError) {
            throwable = null;
        } else if (error instanceof Error.NetworkError) {
            throwable = ((Error.NetworkError)$this$extractCause).getCause();
        } else if (error instanceof Error.ThrowableError) {
            throwable = ((Error.ThrowableError)$this$extractCause).getCause();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }
}

