/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.models;

import io.getstream.chat.android.models.AndFilterObject;
import io.getstream.chat.android.models.AutocompleteFilterObject;
import io.getstream.chat.android.models.ContainsFilterObject;
import io.getstream.chat.android.models.DistinctFilterObject;
import io.getstream.chat.android.models.EqualsFilterObject;
import io.getstream.chat.android.models.ExistsFilterObject;
import io.getstream.chat.android.models.FilterObject;
import io.getstream.chat.android.models.GreaterThanFilterObject;
import io.getstream.chat.android.models.GreaterThanOrEqualsFilterObject;
import io.getstream.chat.android.models.InFilterObject;
import io.getstream.chat.android.models.LessThanFilterObject;
import io.getstream.chat.android.models.LessThanOrEqualsFilterObject;
import io.getstream.chat.android.models.NeutralFilterObject;
import io.getstream.chat.android.models.NorFilterObject;
import io.getstream.chat.android.models.NotEqualsFilterObject;
import io.getstream.chat.android.models.NotExistsFilterObject;
import io.getstream.chat.android.models.NotInFilterObject;
import io.getstream.chat.android.models.OrFilterObject;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0010\u0004\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J!\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000e\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0010\u001a\u00020\u00052\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000e\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0011\u001a\u00020\u00052\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000e\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J)\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000e\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0007J)\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u000e\"\u00020\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000e\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0007J)\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u000e\"\u00020\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0016\u0010 \u001a\u00020\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u001bH\u0007\u00a8\u0006\""}, d2={"Lio/getstream/chat/android/models/Filters;", "", "<init>", "()V", "neutral", "Lio/getstream/chat/android/models/FilterObject;", "exists", "fieldName", "", "notExists", "contains", "value", "and", "filters", "", "([Lio/getstream/chat/android/models/FilterObject;)Lio/getstream/chat/android/models/FilterObject;", "or", "nor", "eq", "ne", "greaterThan", "greaterThanEquals", "lessThan", "lessThanEquals", "in", "values", "(Ljava/lang/String;[Ljava/lang/String;)Lio/getstream/chat/android/models/FilterObject;", "", "", "(Ljava/lang/String;[Ljava/lang/Number;)Lio/getstream/chat/android/models/FilterObject;", "nin", "autocomplete", "distinct", "memberIds", "stream-chat-android-core"})
public final class Filters {
    @NotNull
    public static final Filters INSTANCE = new Filters();

    private Filters() {
    }

    @JvmStatic
    @NotNull
    public static final FilterObject neutral() {
        return NeutralFilterObject.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final FilterObject exists(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return new ExistsFilterObject(fieldName);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject notExists(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return new NotExistsFilterObject(fieldName);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject contains(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new ContainsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject and(FilterObject ... filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return new AndFilterObject(ArraysKt.toSet((Object[])filters));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject or(FilterObject ... filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return new OrFilterObject(ArraysKt.toSet((Object[])filters));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject nor(FilterObject ... filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return new NorFilterObject(ArraysKt.toSet((Object[])filters));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject eq(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new EqualsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject ne(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new NotEqualsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject greaterThan(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new GreaterThanFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject greaterThanEquals(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new GreaterThanOrEqualsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject lessThan(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new LessThanFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject lessThanEquals(@NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new LessThanOrEqualsFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject in(@NotNull String fieldName, String ... values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new InFilterObject(fieldName, ArraysKt.toSet((Object[])values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject in(@NotNull String fieldName, @NotNull List<? extends Object> values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new InFilterObject(fieldName, CollectionsKt.toSet((Iterable)values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject in(@NotNull String fieldName, Number ... values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new InFilterObject(fieldName, ArraysKt.toSet((Object[])values));
    }

    @JvmStatic
    @Deprecated(message="This filter will stop to be supported in the future.", level=DeprecationLevel.WARNING)
    @NotNull
    public static final FilterObject nin(@NotNull String fieldName, String ... values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new NotInFilterObject(fieldName, ArraysKt.toSet((Object[])values));
    }

    @JvmStatic
    @Deprecated(message="This filter will stop to be supported in the future.", level=DeprecationLevel.WARNING)
    @NotNull
    public static final FilterObject nin(@NotNull String fieldName, @NotNull List<? extends Object> values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new NotInFilterObject(fieldName, CollectionsKt.toSet((Iterable)values));
    }

    @JvmStatic
    @Deprecated(message="This filter will stop to be supported in the future.", level=DeprecationLevel.WARNING)
    @NotNull
    public static final FilterObject nin(@NotNull String fieldName, Number ... values) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new NotInFilterObject(fieldName, ArraysKt.toSet((Object[])values));
    }

    @JvmStatic
    @NotNull
    public static final FilterObject autocomplete(@NotNull String fieldName, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new AutocompleteFilterObject(fieldName, value);
    }

    @JvmStatic
    @NotNull
    public static final FilterObject distinct(@NotNull List<String> memberIds) {
        Intrinsics.checkNotNullParameter(memberIds, (String)"memberIds");
        return new DistinctFilterObject(CollectionsKt.toSet((Iterable)memberIds));
    }
}

