/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.core.utils.date;

import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.core.utils.date.DateUtils;
import io.getstream.chat.android.models.TimeDuration;
import java.util.Date;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0087\u0004\u001a\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0007\u001a\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0007\u001a'\u0010\b\u001a\u0004\u0018\u00010\u00022\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\n\"\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0002\u0010\u000b\u001a'\u0010\f\u001a\u0004\u0018\u00010\u00022\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\n\"\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0002\u0010\u000b\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a*\u0010\u0011\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u000e2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0087\b\u00f8\u0001\u0000\u001a$\u0010\u0015\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u00022\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0087\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"after", "", "Ljava/util/Date;", "that", "max", "dateA", "dateB", "min", "maxOf", "dates", "", "([Ljava/util/Date;)Ljava/util/Date;", "minOf", "diff", "Lio/getstream/chat/android/models/TimeDuration;", "otherTime", "", "isWithinDurationFromNow", "duration", "now", "Lkotlin/Function0;", "truncateFuture", "stream-chat-android-core"})
@JvmName(name="DateUtils")
@SourceDebugExtension(value={"SMAP\nDateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateUtils.kt\nio/getstream/chat/android/core/utils/date/DateUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,108:1\n19697#2,7:109\n19697#2,7:116\n*S KotlinDebug\n*F\n+ 1 DateUtils.kt\nio/getstream/chat/android/core/utils/date/DateUtils\n*L\n60#1:109,7\n66#1:116,7\n*E\n"})
public final class DateUtils {
    @InternalStreamChatApi
    public static final boolean after(@Nullable Date $this$after, @Nullable Date that) {
        return $this$after == null ? false : (that == null ? true : $this$after.after(that));
    }

    @InternalStreamChatApi
    @Nullable
    public static final Date max(@Nullable Date dateA, @Nullable Date dateB) {
        return DateUtils.after(dateA, dateB) ? dateA : dateB;
    }

    @InternalStreamChatApi
    @Nullable
    public static final Date min(@Nullable Date dateA, @Nullable Date dateB) {
        return DateUtils.after(dateA, dateB) ? dateB : dateA;
    }

    /*
     * WARNING - void declaration
     */
    @InternalStreamChatApi
    @Nullable
    public static final Date maxOf(Date ... dates) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)dates, (String)"dates");
        Object[] $this$reduceOrNull$iv = dates;
        boolean $i$f$reduceOrNull = false;
        if ($this$reduceOrNull$iv.length == 0) {
            date = null;
        } else {
            void var3_3;
            Date accumulator$iv = $this$reduceOrNull$iv[0];
            int index$iv = 1;
            int n = ArraysKt.getLastIndex((Object[])$this$reduceOrNull$iv);
            if (index$iv <= n) {
                while (true) {
                    void date2;
                    Object object = $this$reduceOrNull$iv[index$iv];
                    Date acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = DateUtils.max(acc, (Date)date2);
                    if (index$iv == n) break;
                    ++index$iv;
                }
            }
            date = var3_3;
        }
        return date;
    }

    /*
     * WARNING - void declaration
     */
    @InternalStreamChatApi
    @Nullable
    public static final Date minOf(Date ... dates) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)dates, (String)"dates");
        Object[] $this$reduceOrNull$iv = dates;
        boolean $i$f$reduceOrNull = false;
        if ($this$reduceOrNull$iv.length == 0) {
            date = null;
        } else {
            void var3_3;
            Date accumulator$iv = $this$reduceOrNull$iv[0];
            int index$iv = 1;
            int n = ArraysKt.getLastIndex((Object[])$this$reduceOrNull$iv);
            if (index$iv <= n) {
                while (true) {
                    void date2;
                    Object object = $this$reduceOrNull$iv[index$iv];
                    Date acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = DateUtils.min(acc, (Date)date2);
                    if (index$iv == n) break;
                    ++index$iv;
                }
            }
            date = var3_3;
        }
        return date;
    }

    @InternalStreamChatApi
    @NotNull
    public static final TimeDuration diff(@NotNull Date $this$diff, long otherTime) {
        Intrinsics.checkNotNullParameter((Object)$this$diff, (String)"<this>");
        long diff = Math.abs($this$diff.getTime() - otherTime);
        return TimeDuration.Companion.millis(diff);
    }

    @InternalStreamChatApi
    @NotNull
    public static final TimeDuration diff(@NotNull Date $this$diff, @NotNull Date that) {
        Intrinsics.checkNotNullParameter((Object)$this$diff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        long diff = Math.abs($this$diff.getTime() - that.getTime());
        return TimeDuration.Companion.millis(diff);
    }

    @InternalStreamChatApi
    public static final boolean isWithinDurationFromNow(@Nullable Date $this$isWithinDurationFromNow, @NotNull TimeDuration duration, @NotNull Function0<Long> now) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(now, (String)"now");
        boolean $i$f$isWithinDurationFromNow = false;
        return $this$isWithinDurationFromNow != null && ((Number)now.invoke()).longValue() - $this$isWithinDurationFromNow.getTime() < duration.getMillis();
    }

    public static /* synthetic */ boolean isWithinDurationFromNow$default(Date $this$isWithinDurationFromNow_u24default, TimeDuration duration, Function0 now, int n, Object object) {
        if ((n & 2) != 0) {
            now = isWithinDurationFromNow.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        boolean $i$f$isWithinDurationFromNow = false;
        return $this$isWithinDurationFromNow_u24default != null && ((Number)now.invoke()).longValue() - $this$isWithinDurationFromNow_u24default.getTime() < duration.getMillis();
    }

    @InternalStreamChatApi
    @Nullable
    public static final Date truncateFuture(@Nullable Date $this$truncateFuture, @NotNull Function0<Long> now) {
        Date date;
        Intrinsics.checkNotNullParameter(now, (String)"now");
        boolean $i$f$truncateFuture = false;
        Date date2 = $this$truncateFuture;
        if (date2 != null) {
            Date date3;
            Date $this$truncateFuture_u24lambda_u242 = date3 = date2;
            boolean bl = false;
            if ($this$truncateFuture_u24lambda_u242.getTime() > ((Number)now.invoke()).longValue()) {
                $this$truncateFuture_u24lambda_u242.setTime(((Number)now.invoke()).longValue());
            }
            date = date3;
        } else {
            date = null;
        }
        return date;
    }

    public static /* synthetic */ Date truncateFuture$default(Date $this$truncateFuture_u24default, Function0 now, int n, Object object) {
        Object object2;
        if ((n & 1) != 0) {
            now = truncateFuture.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        boolean $i$f$truncateFuture = false;
        Date date = $this$truncateFuture_u24default;
        if (date != null) {
            Object $this$truncateFuture_u24lambda_u242 = object = date;
            boolean bl = false;
            if (((Date)$this$truncateFuture_u24lambda_u242).getTime() > ((Number)now.invoke()).longValue()) {
                ((Date)$this$truncateFuture_u24lambda_u242).setTime(((Number)now.invoke()).longValue());
            }
            object2 = object;
        } else {
            object2 = null;
        }
        return object2;
    }
}

