/*
 * Copyright (c) 2014-2022 Stream.io Inc. All rights reserved.
 *
 * Licensed under the Stream License;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://github.com/GetStream/stream-chat-android/blob/main/LICENSE
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.getstream.chat.android.models

import androidx.compose.runtime.Immutable
import java.util.Date

/**
 * Represents a channel mute.
 *
 * @param user The owner of the channel mute.
 * @param channel The muted channel.
 * @param createdAt Date/time of creation.
 * @param updatedAt Date/time of the last update.
 * @param expires Date/time of mute expiration.
 */
@Immutable
public data class ChannelMute(
    val user: User,
    val channel: Channel,
    val createdAt: Date,
    val updatedAt: Date,
    val expires: Date?,
)
