/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.errors;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\b\u0086\u0081\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006\u001d"}, d2={"Lio/getstream/chat/android/client/errors/ChatErrorCode;", "", "code", "", "description", "", "(Ljava/lang/String;IILjava/lang/String;)V", "getCode", "()I", "getDescription", "()Ljava/lang/String;", "NETWORK_FAILED", "PARSER_ERROR", "SOCKET_CLOSED", "SOCKET_FAILURE", "CANT_PARSE_CONNECTION_EVENT", "CANT_PARSE_EVENT", "INVALID_TOKEN", "UNDEFINED_TOKEN", "UNABLE_TO_PARSE_SOCKET_EVENT", "NO_ERROR_BODY", "VALIDATION_ERROR", "AUTHENTICATION_ERROR", "TOKEN_EXPIRED", "TOKEN_NOT_VALID", "TOKEN_DATE_INCORRECT", "TOKEN_SIGNATURE_INCORRECT", "API_KEY_NOT_FOUND", "Companion", "stream-chat-android-core"})
public final class ChatErrorCode
extends Enum<ChatErrorCode> {
    @NotNull
    public static final Companion Companion;
    private final int code;
    @NotNull
    private final String description;
    @NotNull
    private static final Set<Integer> authenticationErrors;
    public static final /* enum */ ChatErrorCode NETWORK_FAILED;
    public static final /* enum */ ChatErrorCode PARSER_ERROR;
    public static final /* enum */ ChatErrorCode SOCKET_CLOSED;
    public static final /* enum */ ChatErrorCode SOCKET_FAILURE;
    public static final /* enum */ ChatErrorCode CANT_PARSE_CONNECTION_EVENT;
    public static final /* enum */ ChatErrorCode CANT_PARSE_EVENT;
    public static final /* enum */ ChatErrorCode INVALID_TOKEN;
    public static final /* enum */ ChatErrorCode UNDEFINED_TOKEN;
    public static final /* enum */ ChatErrorCode UNABLE_TO_PARSE_SOCKET_EVENT;
    public static final /* enum */ ChatErrorCode NO_ERROR_BODY;
    public static final /* enum */ ChatErrorCode VALIDATION_ERROR;
    public static final /* enum */ ChatErrorCode AUTHENTICATION_ERROR;
    public static final /* enum */ ChatErrorCode TOKEN_EXPIRED;
    public static final /* enum */ ChatErrorCode TOKEN_NOT_VALID;
    public static final /* enum */ ChatErrorCode TOKEN_DATE_INCORRECT;
    public static final /* enum */ ChatErrorCode TOKEN_SIGNATURE_INCORRECT;
    public static final /* enum */ ChatErrorCode API_KEY_NOT_FOUND;
    private static final /* synthetic */ ChatErrorCode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ChatErrorCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public static ChatErrorCode[] values() {
        return (ChatErrorCode[])$VALUES.clone();
    }

    public static ChatErrorCode valueOf(String value) {
        return Enum.valueOf(ChatErrorCode.class, value);
    }

    @NotNull
    public static EnumEntries<ChatErrorCode> getEntries() {
        return $ENTRIES;
    }

    static {
        NETWORK_FAILED = new ChatErrorCode(1000, "Response is failed. See cause");
        PARSER_ERROR = new ChatErrorCode(1001, "Unable to parse error");
        SOCKET_CLOSED = new ChatErrorCode(1002, "Server closed connection");
        SOCKET_FAILURE = new ChatErrorCode(1003, "See stack trace in logs. Intercept error in error handler of setUser");
        CANT_PARSE_CONNECTION_EVENT = new ChatErrorCode(1004, "Unable to parse connection event");
        CANT_PARSE_EVENT = new ChatErrorCode(1005, "Unable to parse event");
        INVALID_TOKEN = new ChatErrorCode(1006, "Invalid token");
        UNDEFINED_TOKEN = new ChatErrorCode(1007, "No defined token. Check if client.setUser was called and finished");
        UNABLE_TO_PARSE_SOCKET_EVENT = new ChatErrorCode(1008, "Socket event payload either invalid or null");
        NO_ERROR_BODY = new ChatErrorCode(1009, "No error body. See http status code");
        VALIDATION_ERROR = new ChatErrorCode(4, "Validation error, check your credentials");
        AUTHENTICATION_ERROR = new ChatErrorCode(5, "Unauthenticated, problem with authentication");
        TOKEN_EXPIRED = new ChatErrorCode(40, "Token expired, new one must be requested.");
        TOKEN_NOT_VALID = new ChatErrorCode(41, "Unauthenticated, token not valid yet");
        TOKEN_DATE_INCORRECT = new ChatErrorCode(42, "Unauthenticated, token date incorrect");
        TOKEN_SIGNATURE_INCORRECT = new ChatErrorCode(43, "Unauthenticated, token signature invalid");
        API_KEY_NOT_FOUND = new ChatErrorCode(2, "Api key is not found, verify it if it's correct or was created.");
        $VALUES = chatErrorCodeArray = new ChatErrorCode[]{ChatErrorCode.NETWORK_FAILED, ChatErrorCode.PARSER_ERROR, ChatErrorCode.SOCKET_CLOSED, ChatErrorCode.SOCKET_FAILURE, ChatErrorCode.CANT_PARSE_CONNECTION_EVENT, ChatErrorCode.CANT_PARSE_EVENT, ChatErrorCode.INVALID_TOKEN, ChatErrorCode.UNDEFINED_TOKEN, ChatErrorCode.UNABLE_TO_PARSE_SOCKET_EVENT, ChatErrorCode.NO_ERROR_BODY, ChatErrorCode.VALIDATION_ERROR, ChatErrorCode.AUTHENTICATION_ERROR, ChatErrorCode.TOKEN_EXPIRED, ChatErrorCode.TOKEN_NOT_VALID, ChatErrorCode.TOKEN_DATE_INCORRECT, ChatErrorCode.TOKEN_SIGNATURE_INCORRECT, ChatErrorCode.API_KEY_NOT_FOUND};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        Object[] objectArray = new Integer[]{5, 40, 41, 42, 43};
        authenticationErrors = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/client/errors/ChatErrorCode$Companion;", "", "()V", "authenticationErrors", "", "", "isAuthenticationError", "", "code", "stream-chat-android-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAuthenticationError(int code) {
            return authenticationErrors.contains(code);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

