/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.core.utils.date;

import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.models.TimeDuration;
import java.util.Date;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0007\u001a'\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0006\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0007\u001a\u001e\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0007\u001a'\u0010\t\u001a\u0004\u0018\u00010\u00012\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0006\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0007\u001a\u0019\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0087\u0004\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u001c\u0010\u0011\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0010H\u0007\u00a8\u0006\u0014"}, d2={"max", "Ljava/util/Date;", "dateA", "dateB", "maxOf", "dates", "", "([Ljava/util/Date;)Ljava/util/Date;", "min", "minOf", "after", "", "that", "diff", "Lio/getstream/chat/android/models/TimeDuration;", "otherTime", "", "inOffsetWith", "other", "offset", "stream-chat-android-core"})
@JvmName(name="DateUtils")
@SourceDebugExtension(value={"SMAP\nDateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateUtils.kt\nio/getstream/chat/android/core/utils/date/DateUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,82:1\n19598#2,7:83\n19598#2,7:90\n*S KotlinDebug\n*F\n+ 1 DateUtils.kt\nio/getstream/chat/android/core/utils/date/DateUtils\n*L\n54#1:83,7\n57#1:90,7\n*E\n"})
public final class DateUtils {
    @InternalStreamChatApi
    public static final boolean after(@Nullable Date $this$after, @Nullable Date that) {
        return $this$after == null ? false : (that == null ? true : $this$after.after(that));
    }

    @InternalStreamChatApi
    @Nullable
    public static final Date max(@Nullable Date dateA, @Nullable Date dateB) {
        return DateUtils.after(dateA, dateB) ? dateA : dateB;
    }

    @InternalStreamChatApi
    @Nullable
    public static final Date min(@Nullable Date dateA, @Nullable Date dateB) {
        return DateUtils.after(dateA, dateB) ? dateB : dateA;
    }

    /*
     * WARNING - void declaration
     */
    @InternalStreamChatApi
    @Nullable
    public static final Date maxOf(Date ... dates) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)dates, (String)"dates");
        Object[] $this$reduceOrNull$iv = dates;
        boolean $i$f$reduceOrNull = false;
        if ($this$reduceOrNull$iv.length == 0) {
            date = null;
        } else {
            void var3_3;
            Date accumulator$iv = $this$reduceOrNull$iv[0];
            IntIterator intIterator = new IntRange(1, ArraysKt.getLastIndex((Object[])$this$reduceOrNull$iv)).iterator();
            while (intIterator.hasNext()) {
                void date2;
                int index$iv = intIterator.nextInt();
                Object object = $this$reduceOrNull$iv[index$iv];
                Date acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = DateUtils.max(acc, (Date)date2);
            }
            date = var3_3;
        }
        return date;
    }

    /*
     * WARNING - void declaration
     */
    @InternalStreamChatApi
    @Nullable
    public static final Date minOf(Date ... dates) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)dates, (String)"dates");
        Object[] $this$reduceOrNull$iv = dates;
        boolean $i$f$reduceOrNull = false;
        if ($this$reduceOrNull$iv.length == 0) {
            date = null;
        } else {
            void var3_3;
            Date accumulator$iv = $this$reduceOrNull$iv[0];
            IntIterator intIterator = new IntRange(1, ArraysKt.getLastIndex((Object[])$this$reduceOrNull$iv)).iterator();
            while (intIterator.hasNext()) {
                void date2;
                int index$iv = intIterator.nextInt();
                Object object = $this$reduceOrNull$iv[index$iv];
                Date acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = DateUtils.min(acc, (Date)date2);
            }
            date = var3_3;
        }
        return date;
    }

    @InternalStreamChatApi
    public static final boolean inOffsetWith(@NotNull Date $this$inOffsetWith, @NotNull Date other, long offset) {
        Intrinsics.checkNotNullParameter((Object)$this$inOffsetWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$inOffsetWith.getTime() + offset >= other.getTime();
    }

    @InternalStreamChatApi
    @NotNull
    public static final TimeDuration diff(@NotNull Date $this$diff, long otherTime) {
        Intrinsics.checkNotNullParameter((Object)$this$diff, (String)"<this>");
        long diff = Math.abs($this$diff.getTime() - otherTime);
        return TimeDuration.Companion.millis(diff);
    }

    @InternalStreamChatApi
    @NotNull
    public static final TimeDuration diff(@NotNull Date $this$diff, @NotNull Date that) {
        Intrinsics.checkNotNullParameter((Object)$this$diff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        long diff = Math.abs($this$diff.getTime() - that.getTime());
        return TimeDuration.Companion.millis(diff);
    }
}

