/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.errors;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import java.net.UnknownHostException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0005H\u0007\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0005H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"HTTP_API_ERROR", "", "HTTP_TIMEOUT", "HTTP_TOO_MANY_REQUESTS", "copyWithMessage", "Lio/getstream/chat/android/client/errors/ChatError;", "message", "", "extractCause", "", "isPermanent", "", "stream-chat-android-core"})
public final class ChatErrorKt {
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final int HTTP_TIMEOUT = 408;
    private static final int HTTP_API_ERROR = 500;

    @InternalStreamChatApi
    public static final boolean isPermanent(@NotNull ChatError $this$isPermanent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPermanent, (String)"<this>");
        if ($this$isPermanent instanceof ChatError.NetworkError) {
            Object[] objectArray = new Integer[]{429, 408, 500};
            List temporaryStreamErrors = CollectionsKt.listOf((Object[])objectArray);
            bl = temporaryStreamErrors.contains(((ChatError.NetworkError)$this$isPermanent).getStatusCode()) ? false : !(((ChatError.NetworkError)$this$isPermanent).getCause() instanceof UnknownHostException);
        } else {
            bl = false;
        }
        return bl;
    }

    @InternalStreamChatApi
    @NotNull
    public static final ChatError copyWithMessage(@NotNull ChatError $this$copyWithMessage, @NotNull String message) {
        ChatError chatError;
        Intrinsics.checkNotNullParameter((Object)$this$copyWithMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ChatError chatError2 = $this$copyWithMessage;
        if (chatError2 instanceof ChatError.GenericError) {
            chatError = ((ChatError.GenericError)$this$copyWithMessage).copy(message);
        } else if (chatError2 instanceof ChatError.NetworkError) {
            chatError = ChatError.NetworkError.copy$default((ChatError.NetworkError)$this$copyWithMessage, message, 0, 0, null, 14, null);
        } else if (chatError2 instanceof ChatError.ThrowableError) {
            chatError = ChatError.ThrowableError.copy$default((ChatError.ThrowableError)$this$copyWithMessage, message, null, 2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chatError;
    }

    @InternalStreamChatApi
    @Nullable
    public static final Throwable extractCause(@NotNull ChatError $this$extractCause) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)$this$extractCause, (String)"<this>");
        ChatError chatError = $this$extractCause;
        if (chatError instanceof ChatError.GenericError) {
            throwable = null;
        } else if (chatError instanceof ChatError.NetworkError) {
            throwable = ((ChatError.NetworkError)$this$extractCause).getCause();
        } else if (chatError instanceof ChatError.ThrowableError) {
            throwable = ((ChatError.ThrowableError)$this$extractCause).getCause();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }
}

