/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.utils;

import io.getstream.chat.android.client.errors.ChatError;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u0013*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/client/utils/Result;", "T", "", "data", "(Ljava/lang/Object;)V", "error", "Lio/getstream/chat/android/client/errors/ChatError;", "(Lio/getstream/chat/android/client/errors/ChatError;)V", "(Ljava/lang/Object;Lio/getstream/chat/android/client/errors/ChatError;)V", "Ljava/lang/Object;", "isError", "", "()Z", "isSuccess", "()Ljava/lang/Object;", "equals", "other", "hashCode", "", "Companion", "stream-chat-android-core"})
public final class Result<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final T data;
    @Nullable
    private final ChatError error;

    private Result(T data, ChatError error) {
        this.data = data;
        this.error = error;
    }

    public Result(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this(data, null);
    }

    public Result(@NotNull ChatError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this(null, error);
    }

    public final boolean isSuccess() {
        return this.data != null;
    }

    public final boolean isError() {
        return this.error != null;
    }

    @NotNull
    public final T data() {
        T t = this.data;
        boolean bl = false;
        boolean bl2 = false;
        if (t == null) {
            boolean bl3 = false;
            String string = "Result is not successful. Check result.isSuccess before reading the data.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return t;
    }

    @NotNull
    public final ChatError error() {
        ChatError chatError = this.error;
        boolean bl = false;
        boolean bl2 = false;
        if (chatError == null) {
            boolean bl3 = false;
            String string = "Result is successful, not an error. Check result.isSuccess before reading the error.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return chatError;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.getstream.chat.android.client.utils.Result<*>");
        }
        Result cfr_ignored_0 = (Result)other;
        if (!Intrinsics.areEqual(this.data, ((Result)other).data)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.error, (Object)((Result)other).error);
    }

    public int hashCode() {
        int n;
        Object object = this.data;
        int result = object == null ? 0 : (n = object.hashCode());
        object = this.error;
        result = 31 * result + (object == null ? 0 : (n = object.hashCode()));
        return result;
    }

    @JvmStatic
    @NotNull
    public static final <T> Result<T> success(@NotNull T data) {
        return Companion.success(data);
    }

    @JvmStatic
    @NotNull
    public static final <T> Result<T> error(@NotNull Throwable t) {
        return Companion.error(t);
    }

    @JvmStatic
    @NotNull
    public static final <T> Result<T> error(@NotNull ChatError error) {
        return Companion.error(error);
    }

    public /* synthetic */ Result(Object data, ChatError error, DefaultConstructorMarker $constructor_marker) {
        this(data, error);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0006H\u0007J \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007J%\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0006\u0010\n\u001a\u0002H\u0005H\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/getstream/chat/android/client/utils/Result$Companion;", "", "()V", "error", "Lio/getstream/chat/android/client/utils/Result;", "T", "Lio/getstream/chat/android/client/errors/ChatError;", "t", "", "success", "data", "(Ljava/lang/Object;)Lio/getstream/chat/android/client/utils/Result;", "stream-chat-android-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> Result<T> success(@NotNull T data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new Result<T>(data);
        }

        @JvmStatic
        @NotNull
        public final <T> Result<T> error(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return new Result(null, new ChatError(t.getMessage(), t), null);
        }

        @JvmStatic
        @NotNull
        public final <T> Result<T> error(@NotNull ChatError error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new Result(null, error, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

