/*
 * Copyright (c) 2014-2022 Stream.io Inc. All rights reserved.
 *
 * Licensed under the Stream License;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://github.com/GetStream/stream-chat-android/blob/main/LICENSE
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

@file:Suppress("DEPRECATION_ERROR")

package io.getstream.chat.android.client.socket

import io.getstream.chat.android.client.models.User
import io.getstream.chat.android.client.network.NetworkStateProvider
import io.getstream.chat.android.client.parser.ChatParser
import io.getstream.chat.android.client.token.TokenManager
import kotlinx.coroutines.CoroutineScope

internal class ChatSocketImpl(
    private val apiKey: String,
    private val wssUrl: String,
    tokenManager: TokenManager,
    parser: ChatParser,
    networkStateProvider: NetworkStateProvider,
    coroutineScope: CoroutineScope,
) : ChatSocket {

    private val service = ChatSocketServiceImpl(
        tokenManager,
        SocketFactory(parser, tokenManager),
        networkStateProvider,
        parser,
        coroutineScope,
    )

    override fun connectAnonymously() {
        service.anonymousConnect(wssUrl, apiKey)
    }

    override fun connect(user: User) {
        service.userConnect(wssUrl, apiKey, user)
    }

    override fun disconnect() {
        service.disconnect()
    }

    override fun releaseConnection() {
        service.releaseConnection()
    }

    override fun addListener(listener: SocketListener) {
        service.addListener(listener)
    }

    override fun removeListener(listener: SocketListener) {
        service.removeListener(listener)
    }
}
