package io.getstream.chat.android.client.models

/**
 * Device's information needed to register push notifications.
 *
 * @property token Device's token generated by push notification provider.
 * @property pushProvider Push notifications provider type.
 * @see [PushProvider]
 */
public data class Device(
    val token: String,
    var pushProvider: PushProvider,
)

/**
 * Push notifications provider type.
 */
public enum class PushProvider(internal val key: String) {
    /** Firebase push notification provider */
    FIREBASE("firebase"),
    /** Huawei push notification provider */
    HUAWEI("huawei"),
    /** Xiaomi push notification provider */
    XIAOMI("xiaomi"),
    /** Unknown push notification provider */
    UNKNOWN("unknown");

    internal companion object {
        internal fun fromKey(key: String): PushProvider =
            values().firstOrNull { it.key == key } ?: UNKNOWN
    }
}
