package io.getstream.chat.android.client.models

/**
 * Device's information needed to register push notifications
 */
public data class Device(
    /**
     * Device's token generated by push notification provider
     */
    val token: String,

    /**
     * Push notifications provider type
     *
     * @see [PushProvider]
     */
    var pushProvider: PushProvider,
)

/**
 * Push notifications provider type
 */
public enum class PushProvider(internal val key: String) {
    /** Firebase push notification provider */
    FIREBASE("firebase"),
    /** Huawei push notification provider */
    HUAWEI("huawei"),
    /** Unknown push notification provider */
    UNKNOWN("unknown");

    internal companion object {
        internal fun fromKey(key: String): PushProvider =
            values().firstOrNull { it.key == key } ?: UNKNOWN
    }
}
