/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kyo.Stats;
import kyo.scheduler.Coordinator$;
import kyo.scheduler.Scheduler$;
import kyo.scheduler.Task;
import kyo.scheduler.Task$;
import kyo.scheduler.Worker$;
import kyo.scheduler.Worker$stats$;
import kyo.scheduler.util.Queue;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public final class Worker
implements Runnable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Worker.class.getDeclaredField("stats$lzy1"));
    public final int kyo$scheduler$Worker$$id;
    public final Stats kyo$scheduler$Worker$$scope;
    private final Executor exec;
    private final AtomicBoolean running;
    private volatile Thread mount;
    private volatile long currentCycle;
    private volatile Task currentTask;
    private final Queue<Task> queue;
    private final Function1<Task, BoxedUnit> schedule;
    private volatile Object stats$lzy1;

    public static Worker current() {
        return Worker$.MODULE$.current();
    }

    public Worker(int id, Stats scope, Executor exec) {
        this.kyo$scheduler$Worker$$id = id;
        this.kyo$scheduler$Worker$$scope = scope;
        this.exec = exec;
        this.running = new AtomicBoolean();
        this.mount = null;
        this.currentCycle = 0L;
        this.currentTask = null;
        this.queue = new Queue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.schedule = (JProcedure1 & Serializable)_$1 -> Scheduler$.MODULE$.schedule((Task)_$1, this);
    }

    private Queue<Task> queue() {
        return this.queue;
    }

    public boolean enqueue(Task t) {
        boolean blocked = this.handleBlocking();
        if (!blocked) {
            this.stats().submissions().increment();
            this.queue().add(t);
            this.wakeup();
        }
        return !blocked;
    }

    public void wakeup() {
        if (!this.running.get() && this.running.compareAndSet(false, true)) {
            this.stats().mounts().increment();
            this.exec.execute(this);
            return;
        }
    }

    public int load() {
        int l = this.queue().size();
        if (this.currentTask != null) {
            ++l;
        }
        return l;
    }

    public Task steal(Worker thief) {
        return this.queue().steal(thief.queue());
    }

    public void drain() {
        this.queue().drain(this.schedule);
    }

    public void cycle(long curr) {
        Task c = this.currentTask;
        if (c != null && this.currentCycle < curr - 1L) {
            c.preempt();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleBlocking() {
        Thread m = this.mount;
        if (m == null) return false;
        Thread.State state = m.getState();
        Thread.State state2 = Thread.State.BLOCKED;
        if (state == null) {
            if (state2 != null) {
                return false;
            }
        } else if (!((Object)((Object)state)).equals((Object)state2)) return false;
        boolean bl = true;
        boolean r = bl;
        if (!r) return r;
        this.drain();
        return r;
    }

    @Override
    public void run() {
        this.mount = Thread.currentThread();
        Worker$.kyo$scheduler$Worker$$$local.set(this);
        Task task = null;
        while (true) {
            this.currentCycle = Coordinator$.MODULE$.currentCycle();
            if (task == null) {
                task = this.queue().poll();
            }
            if (task == null) {
                task = this.steal(this);
            }
            if (task != null) {
                this.currentTask = task;
                Worker$stats$ worker$stats$ = this.stats();
                worker$stats$.executions_$eq(worker$stats$.executions() + 1L);
                boolean r = task.run();
                this.currentTask = null;
                if (r == Task$.MODULE$.Preempted()) {
                    Worker$stats$ worker$stats$2 = this.stats();
                    worker$stats$2.preemptions_$eq(worker$stats$2.preemptions() + 1L);
                    task = this.queue().addAndPoll(task);
                    continue;
                }
                Worker$stats$ worker$stats$3 = this.stats();
                worker$stats$3.completions_$eq(worker$stats$3.completions() + 1L);
                task = null;
                continue;
            }
            this.running.set(false);
            if (!this.queue().isEmpty() && this.running.compareAndSet(false, true)) continue;
            Worker$.kyo$scheduler$Worker$$$local.set(null);
            this.mount = null;
            return;
        }
    }

    private final Worker$stats$ stats() {
        Object object = this.stats$lzy1;
        if (object instanceof Worker$stats$) {
            return (Worker$stats$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Worker$stats$)this.stats$lzyINIT1();
    }

    private Object stats$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.stats$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Worker$stats$ worker$stats$ = null;
                    try {
                        worker$stats$ = new Worker$stats$(this);
                        object2 = worker$stats$ == null ? LazyVals.NullValue$.MODULE$ : worker$stats$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.stats$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return worker$stats$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public static final double kyo$scheduler$Worker$stats$$$_$$lessinit$greater$$anonfun$5(Worker $outer$1) {
        return Int$.MODULE$.int2double($outer$1.queue().size());
    }

    public static final double kyo$scheduler$Worker$stats$$$_$$lessinit$greater$$anonfun$6(Worker $outer$2) {
        return $outer$2.currentCycle;
    }
}

