/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kyo.scheduler.Coordinator$;
import kyo.scheduler.Scheduler$stats$;
import kyo.scheduler.Task;
import kyo.scheduler.Worker;
import kyo.scheduler.Worker$;
import kyo.scheduler.util.Flag$;
import kyo.scheduler.util.Flag$Reader$;
import kyo.scheduler.util.LoomSupport$;
import kyo.scheduler.util.Threads$;
import kyo.scheduler.util.XSRandom$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Scheduler$
implements Serializable {
    private static final int minWorkers;
    private static final int maxWorkers;
    private static final int scheduleTries;
    public static volatile int kyo$scheduler$Scheduler$$$maxConcurrency;
    public static volatile int kyo$scheduler$Scheduler$$$allocatedWorkers;
    private static final Worker[] workers;
    private static final Executor exec;
    public static final Scheduler$stats$ stats;
    public static final Scheduler$ MODULE$;

    private Scheduler$() {
    }

    static {
        MODULE$ = new Scheduler$();
        int cores = Runtime.getRuntime().availableProcessors();
        int coreWorkers = Math.max(1, BoxesRunTime.unboxToInt((Object)Flag$.MODULE$.apply("coreWorkers", BoxesRunTime.boxToInteger((int)cores), Flag$Reader$.MODULE$.given_Reader_Int())));
        minWorkers = Math.max(1, Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)Flag$.MODULE$.apply("minWorkers", BoxesRunTime.boxToDouble((double)((double)coreWorkers / (double)2)), Flag$Reader$.MODULE$.given_Reader_Double()))).intValue());
        maxWorkers = Math.max(minWorkers, BoxesRunTime.unboxToInt((Object)Flag$.MODULE$.apply("maxWorkers", BoxesRunTime.boxToInteger((int)(coreWorkers * 100)), Flag$Reader$.MODULE$.given_Reader_Int())));
        scheduleTries = Math.max(1, BoxesRunTime.unboxToInt((Object)Flag$.MODULE$.apply("scheduleTries", BoxesRunTime.boxToInteger((int)8), Flag$Reader$.MODULE$.given_Reader_Int())));
        boolean virtualizeWorkers = BoxesRunTime.unboxToBoolean((Object)Flag$.MODULE$.apply("virtualizeWorkers", BoxesRunTime.boxToBoolean((boolean)false), Flag$Reader$.MODULE$.given_Reader_Boolean()));
        kyo$scheduler$Scheduler$$$allocatedWorkers = kyo$scheduler$Scheduler$$$maxConcurrency = coreWorkers;
        workers = new Worker[maxWorkers];
        exec = virtualizeWorkers ? LoomSupport$.MODULE$.tryVirtualize(MODULE$.pool$1()) : MODULE$.pool$1();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), kyo$scheduler$Scheduler$$$maxConcurrency).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Scheduler$.workers[i] = new Worker(i, Scheduler$stats$.MODULE$.scope(), exec);
        });
        Coordinator$.MODULE$.load();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Scheduler$.class);
    }

    public void addWorker() {
        int m = kyo$scheduler$Scheduler$$$maxConcurrency;
        if (m < maxWorkers) {
            if (m > kyo$scheduler$Scheduler$$$allocatedWorkers) {
                Scheduler$.workers[m] = new Worker(m, Scheduler$stats$.MODULE$.scope(), exec);
                ++kyo$scheduler$Scheduler$$$allocatedWorkers;
            }
            kyo$scheduler$Scheduler$$$maxConcurrency = m + 1;
            return;
        }
    }

    public void removeWorker() {
        kyo$scheduler$Scheduler$$$maxConcurrency = Math.max(kyo$scheduler$Scheduler$$$maxConcurrency - 1, minWorkers);
    }

    public void schedule(Task t) {
        this.schedule(t, null);
    }

    public void schedule(Task t, Worker submitter) {
        Worker worker;
        do {
            worker = null;
            if (submitter == null) {
                worker = Worker$.MODULE$.current();
            }
            if (worker == null) {
                int m = kyo$scheduler$Scheduler$$$maxConcurrency;
                int i = XSRandom$.MODULE$.nextInt(m);
                int minLoad = Integer.MAX_VALUE;
                for (int tries = Math.min(m, scheduleTries); tries > 0 && minLoad != 0; --tries) {
                    int l;
                    Worker w = workers[i];
                    if (w != null && !w.handleBlocking() && (l = w.load()) < minLoad) {
                        Worker worker2 = w;
                        Worker worker3 = submitter;
                        if (worker2 == null ? worker3 != null : !worker2.equals(worker3)) {
                            minLoad = l;
                            worker = w;
                        }
                    }
                    if (++i != m) continue;
                    i = 0;
                }
            }
            while (worker == null) {
                worker = workers[XSRandom$.MODULE$.nextInt(kyo$scheduler$Scheduler$$$maxConcurrency)];
            }
        } while (!worker.enqueue(t));
    }

    public Task steal(Worker thief) {
        Worker worker = null;
        int maxLoad = Integer.MAX_VALUE;
        for (int i = 0; i < kyo$scheduler$Scheduler$$$maxConcurrency; ++i) {
            int l;
            Worker w = workers[i];
            if (w == null || w.handleBlocking() || (l = w.load()) <= maxLoad) continue;
            Worker worker2 = w;
            Worker worker3 = thief;
            if (!(worker2 == null ? worker3 != null : !worker2.equals(worker3))) continue;
            maxLoad = l;
            worker = w;
        }
        if (worker != null) {
            return worker.steal(thief);
        }
        return null;
    }

    public void flush() {
        Scheduler$stats$.MODULE$.flushes().increment();
        Worker w = Worker$.MODULE$.current();
        if (w != null) {
            w.drain();
            return;
        }
    }

    public double loadAvg() {
        int m = kyo$scheduler$Scheduler$$$maxConcurrency;
        int r = 0;
        for (int i = 0; i < m; ++i) {
            Worker w = workers[i];
            if (w == null) continue;
            r += w.load();
        }
        return (double)r / (double)m;
    }

    public void cycle(long curr) {
        for (int i = 0; i < kyo$scheduler$Scheduler$$$maxConcurrency; ++i) {
            Worker w = workers[i];
            if (w == null) continue;
            w.cycle(curr);
        }
        Worker w = workers[XSRandom$.MODULE$.nextInt(kyo$scheduler$Scheduler$$$maxConcurrency)];
        if (w != null) {
            w.wakeup();
            return;
        }
    }

    private final ExecutorService pool$1() {
        return Executors.newCachedThreadPool(Threads$.MODULE$.apply("kyo-scheduler"));
    }
}

