/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.Executors;
import kyo.Logs$;
import kyo.scheduler.Coordinator$stats$;
import kyo.scheduler.Scheduler$;
import kyo.scheduler.util.Flag$;
import kyo.scheduler.util.Flag$Reader$;
import kyo.scheduler.util.MovingStdDev;
import kyo.scheduler.util.Threads$;
import scala.Int$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class Coordinator$
implements Serializable {
    private static final double loadAvgTarget;
    public static final double kyo$scheduler$Coordinator$$$jitterMaxMs;
    public static final double kyo$scheduler$Coordinator$$$jitterSoftMaxMs;
    private static final int delayCycles;
    private static final int cycleMask;
    private static final int adaptMask;
    private static final long a1;
    private static final long a2;
    private static final long a3;
    private static final long a4;
    private static final long a5;
    private static final long a6;
    private static final long a7;
    private static volatile long ticks;
    private static final long b1;
    private static final long b2;
    private static final long b3;
    private static final long b4;
    private static final long b5;
    private static final long b6;
    private static final long b7;
    private static volatile long cycles;
    private static final long c1;
    private static final long c2;
    private static final long c3;
    private static final long c4;
    private static final long c5;
    private static final long c6;
    private static final long c7;
    public static final MovingStdDev kyo$scheduler$Coordinator$$$delayNs;
    private static final Coordinator$stats$ stats;
    public static final Coordinator$ MODULE$;

    private Coordinator$() {
    }

    static {
        MODULE$ = new Coordinator$();
        boolean enable = BoxesRunTime.unboxToBoolean((Object)Flag$.MODULE$.apply("coordinator.enable", BoxesRunTime.boxToBoolean((boolean)true), Flag$Reader$.MODULE$.given_Reader_Boolean()));
        int cycleExp = BoxesRunTime.unboxToInt((Object)Flag$.MODULE$.apply("coordinator.cycleExp", BoxesRunTime.boxToInteger((int)2), Flag$Reader$.MODULE$.given_Reader_Int()));
        int adaptExp = BoxesRunTime.unboxToInt((Object)Flag$.MODULE$.apply("coordinator.adaptExp", BoxesRunTime.boxToInteger((int)8), Flag$Reader$.MODULE$.given_Reader_Int()));
        loadAvgTarget = BoxesRunTime.unboxToDouble((Object)Flag$.MODULE$.apply("coordinator.loadAvgTarget", BoxesRunTime.boxToDouble((double)0.8), Flag$Reader$.MODULE$.given_Reader_Double()));
        kyo$scheduler$Coordinator$$$jitterMaxMs = BoxesRunTime.unboxToDouble((Object)Flag$.MODULE$.apply("coordinator.jitterMax", BoxesRunTime.boxToDouble((double)0.1), Flag$Reader$.MODULE$.given_Reader_Double()));
        kyo$scheduler$Coordinator$$$jitterSoftMaxMs = BoxesRunTime.unboxToDouble((Object)Flag$.MODULE$.apply("coordinator.jitterSoftMax", BoxesRunTime.boxToDouble((double)0.8), Flag$Reader$.MODULE$.given_Reader_Double()));
        delayCycles = BoxesRunTime.unboxToInt((Object)Flag$.MODULE$.apply("coordinator.delayCycles", BoxesRunTime.boxToInteger((int)2), Flag$Reader$.MODULE$.given_Reader_Int()));
        int cycleTicks = Predef$.MODULE$.double2Double(Math.pow(2.0, Int$.MODULE$.int2double(cycleExp))).intValue();
        cycleMask = cycleTicks - 1;
        int adaptTicks = Predef$.MODULE$.double2Double(Math.pow(2.0, Int$.MODULE$.int2double(adaptExp))).intValue();
        adaptMask = adaptTicks - 1;
        a1 = 0L;
        a2 = 0L;
        a3 = 0L;
        a4 = 0L;
        a5 = 0L;
        a6 = 0L;
        a7 = 0L;
        ticks = 0L;
        b1 = 0L;
        b2 = 0L;
        b3 = 0L;
        b4 = 0L;
        b5 = 0L;
        b6 = 0L;
        b7 = 0L;
        cycles = 0L;
        c1 = 0L;
        c2 = 0L;
        c3 = 0L;
        c4 = 0L;
        c5 = 0L;
        c6 = 0L;
        c7 = 0L;
        kyo$scheduler$Coordinator$$$delayNs = new MovingStdDev(cycleExp);
        if (enable) {
            Executors.newSingleThreadExecutor(Threads$.MODULE$.apply("kyo-coordinator")).execute(() -> {
                while (true) {
                    this.update();
                }
            });
        }
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Coordinator$.class);
    }

    public long a1() {
        return a1;
    }

    public long a2() {
        return a2;
    }

    public long a3() {
        return a3;
    }

    public long a4() {
        return a4;
    }

    public long a5() {
        return a5;
    }

    public long a6() {
        return a6;
    }

    public long a7() {
        return a7;
    }

    public long b1() {
        return b1;
    }

    public long b2() {
        return b2;
    }

    public long b3() {
        return b3;
    }

    public long b4() {
        return b4;
    }

    public long b5() {
        return b5;
    }

    public long b6() {
        return b6;
    }

    public long b7() {
        return b7;
    }

    public long c1() {
        return c1;
    }

    public long c2() {
        return c2;
    }

    public long c3() {
        return c3;
    }

    public long c4() {
        return c4;
    }

    public long c5() {
        return c5;
    }

    public long c6() {
        return c6;
    }

    public long c7() {
        return c7;
    }

    public void load() {
    }

    public long currentTick() {
        return ticks;
    }

    public long currentCycle() {
        return cycles;
    }

    public double kyo$scheduler$Coordinator$$$jitterMs() {
        return Predef$.MODULE$.long2Long(kyo$scheduler$Coordinator$$$delayNs.dev()).doubleValue() / (double)1000000;
    }

    private void update() {
        try {
            long startNs = System.nanoTime();
            Thread.sleep(1L);
            long endNs = System.nanoTime();
            kyo$scheduler$Coordinator$$$delayNs.observe(endNs - startNs - 1000000L);
            if ((++ticks & (long)cycleMask) == 0L) {
                Scheduler$.MODULE$.cycle(++cycles);
            }
            if ((ticks & (long)adaptMask) == 0L) {
                this.adapt();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                Logs$.MODULE$.logger().error("Kyo coordinator failure", ex);
            }
            throw throwable;
        }
    }

    private void adapt() {
        if (cycles > (long)delayCycles) {
            double j = this.kyo$scheduler$Coordinator$$$jitterMs();
            double l = Scheduler$.MODULE$.loadAvg();
            if (j >= kyo$scheduler$Coordinator$$$jitterMaxMs) {
                Coordinator$stats$ coordinator$stats$ = Coordinator$stats$.MODULE$;
                coordinator$stats$.removeWorker_$eq(coordinator$stats$.removeWorker() + 1L);
                Scheduler$.MODULE$.removeWorker();
                return;
            }
            if (j <= kyo$scheduler$Coordinator$$$jitterSoftMaxMs && l > loadAvgTarget) {
                Coordinator$stats$ coordinator$stats$ = Coordinator$stats$.MODULE$;
                coordinator$stats$.addWorker_$eq(coordinator$stats$.addWorker() + 1L);
                Scheduler$.MODULE$.addWorker();
                return;
            }
            return;
        }
    }

    public String toString() {
        return "Coordinator(ticks=" + ticks + ",cycles=" + cycles + ",delay.dev=" + kyo$scheduler$Coordinator$$$delayNs.dev() + ",delay.avg=" + kyo$scheduler$Coordinator$$$delayNs.avg() + ",jitter=" + this.kyo$scheduler$Coordinator$$$jitterMs() + ")";
    }
}

