/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jdk.internal.vm.annotation.Contended;
import kyo.scheduler.Flag$;
import kyo.scheduler.Flag$Reader$;
import kyo.scheduler.MovingStdDev;
import kyo.scheduler.Scheduler$;
import kyo.scheduler.Threads$;
import scala.Int$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class Coordinator$
implements Serializable {
    private static final double loadAvgTarget;
    private static final double jitterMax;
    private static final double jitterSoftMax;
    private static final int cycleMask;
    @Contended
    private static volatile long ticks;
    @Contended
    private static volatile long cycles;
    private static long startNs;
    private static final MovingStdDev delayNs;
    private static final ExecutorService exec;
    private static final Runnable adapt;
    public static final Coordinator$ MODULE$;

    private Coordinator$() {
    }

    static {
        MODULE$ = new Coordinator$();
        int cycleExp = BoxesRunTime.unboxToInt((Object)Flag$.MODULE$.apply("coordinator.cycleExp", BoxesRunTime.boxToInteger((int)8), Flag$Reader$.MODULE$.given_Reader_Int()));
        loadAvgTarget = BoxesRunTime.unboxToDouble((Object)Flag$.MODULE$.apply("coordinator.loadAvgTarget", BoxesRunTime.boxToDouble((double)0.8), Flag$Reader$.MODULE$.given_Reader_Double()));
        jitterMax = BoxesRunTime.unboxToDouble((Object)Flag$.MODULE$.apply("coordinator.jitterMax", BoxesRunTime.boxToDouble((double)0.1), Flag$Reader$.MODULE$.given_Reader_Double()));
        jitterSoftMax = BoxesRunTime.unboxToDouble((Object)Flag$.MODULE$.apply("coordinator.jitterSoftMax", BoxesRunTime.boxToDouble((double)0.8), Flag$Reader$.MODULE$.given_Reader_Double()));
        int cycleTicks = Predef$.MODULE$.double2Double(Math.pow(2.0, Int$.MODULE$.int2double(cycleExp))).intValue();
        cycleMask = cycleTicks - 1;
        ticks = 0L;
        cycles = 0L;
        startNs = 0L;
        delayNs = new MovingStdDev(cycleExp);
        exec = Executors.newCachedThreadPool(Threads$.MODULE$.apply("kyo-coordinator"));
        exec.execute(() -> {
            startNs = System.nanoTime();
            while (true) {
                this.update();
            }
        });
        adapt = () -> {
            Scheduler$.MODULE$.cycle();
            double j = this.jitter();
            double l = Scheduler$.MODULE$.loadAvg();
            if (j >= jitterMax) {
                Scheduler$.MODULE$.removeWorker();
                return;
            }
            if (j <= jitterSoftMax && l > loadAvgTarget) {
                Scheduler$.MODULE$.addWorker();
                return;
            }
            if (l < loadAvgTarget) {
                Scheduler$.MODULE$.removeWorker();
                return;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Coordinator$.class);
    }

    public void load() {
    }

    public long tick() {
        return ticks;
    }

    public long cycle() {
        return cycles;
    }

    private double jitter() {
        return Predef$.MODULE$.long2Long(delayNs.dev()).doubleValue() / (double)1000000;
    }

    private void update() {
        try {
            Thread.sleep(1L);
            long endNs = System.nanoTime();
            delayNs.observe(endNs - startNs - 1000000L);
            startNs = endNs;
            if ((++ticks & (long)cycleMask) == 0L) {
                ++cycles;
                exec.execute(adapt);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                ex.printStackTrace();
            }
            throw throwable;
        }
    }

    public String toString() {
        return new StringBuilder(57).append("Coordinator(ticks=").append(ticks).append(",cycles=").append(cycles).append(",delay.dev=").append(delayNs.dev()).append(",delay.avg=").append(delayNs.avg()).append(",jitter=").append(this.jitter()).append(")").toString();
    }
}

