package kyo

import org.slf4j.LoggerFactory

object Logs:

    private val logger = LoggerFactory.getLogger("kyo.logs")

    inline def trace(inline msg: => String)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        // Discard wrappers so their allocation
        // can be elided by the JIT. The values
        // are `String`s from the constant pool
        // since they're generated by a macro.
        // This could be avoided if sourcecode's
        // values were `AnyVal`s.
        val f = file.value
        val l = line.value
        // The suspended function will have two
        // pointers for `f` and `l`. It could be a
        // single pointer if sourcecode had an
        // implicit for `fileName:line`.
        IOs(if logger.isTraceEnabled then logger.trace(s"[$f:$l] $msg"))
    end trace

    inline def trace(inline msg: => String, inline t: => Throwable)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isTraceEnabled then logger.trace(s"[$f:$l] $msg", t))
    end trace

    inline def debug(inline msg: => String)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isDebugEnabled then logger.debug(s"[$f:$l] $msg"))
    end debug

    inline def debug(inline msg: => String, inline t: => Throwable)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isDebugEnabled then logger.debug(s"[$f:$l] $msg", t))
    end debug

    inline def info(inline msg: => String)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isInfoEnabled then logger.info(s"[$f:$l] $msg"))
    end info

    inline def info(inline msg: => String, inline t: => Throwable)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isInfoEnabled then logger.info(s"[$f:$l] $msg", t))
    end info

    inline def warn(inline msg: => String)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isWarnEnabled then logger.warn(s"[$f:$l] $msg"))
    end warn

    inline def warn(inline msg: => String, inline t: => Throwable)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isWarnEnabled then logger.warn(s"[$f:$l] $msg", t))
    end warn

    inline def error(inline msg: => String)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isErrorEnabled then logger.error(s"[$f:$l] $msg"))
    end error

    inline def error(inline msg: => String, inline t: => Throwable)(
        implicit
        file: sourcecode.FileName,
        line: sourcecode.Line
    ): Unit < IOs =
        val f = file.value
        val l = line.value
        IOs(if logger.isErrorEnabled then logger.error(s"[$f:$l] $msg", t))
    end error

    object unsafe:
        inline def trace(inline msg: => String)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit =
            val f = file.value
            val l = line.value
            if logger.isTraceEnabled then logger.trace(s"[$f:$l] $msg")
        end trace

        inline def trace(inline msg: => String, inline t: => Throwable)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit =
            val f = file.value
            val l = line.value
            if logger.isTraceEnabled then logger.trace(s"[$f:$l] $msg", t)
        end trace

        inline def debug(inline msg: => String)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit =
            val f = file.value
            val l = line.value
            if logger.isDebugEnabled then logger.debug(s"[$f:$l] $msg")
        end debug

        inline def debug(inline msg: => String, inline t: => Throwable)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit < IOs =
            val f = file.value
            val l = line.value
            if logger.isDebugEnabled then logger.debug(s"[$f:$l] $msg", t)
        end debug

        inline def info(inline msg: => String)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit =
            val f = file.value
            val l = line.value
            if logger.isInfoEnabled then logger.info(s"[$f:$l] $msg")
        end info

        inline def info(inline msg: => String, inline t: => Throwable)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit =
            val f = file.value
            val l = line.value
            if logger.isInfoEnabled then logger.info(s"[$f:$l] $msg", t)
        end info

        inline def warn(inline msg: => String)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit =
            val f = file.value
            val l = line.value
            if logger.isWarnEnabled then logger.warn(s"[$f:$l] $msg")
        end warn

        inline def warn(inline msg: => String, inline t: => Throwable)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit < IOs =
            val f = file.value
            val l = line.value
            if logger.isWarnEnabled then logger.warn(s"[$f:$l] $msg", t)
        end warn

        inline def error(inline msg: => String)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit =
            val f = file.value
            val l = line.value
            if logger.isErrorEnabled then logger.error(s"[$f:$l] $msg")
        end error

        inline def error(inline msg: => String, inline t: => Throwable)(
            implicit
            file: sourcecode.FileName,
            line: sourcecode.Line
        ): Unit =
            val f = file.value
            val l = line.value
            if logger.isErrorEnabled then logger.error(s"[$f:$l] $msg", t)
        end error
    end unsafe
end Logs
