/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class Queue<T>
extends AtomicBoolean {
    private final PriorityQueue queue;
    private volatile int items;

    public Queue(Ordering<T> ord) {
        this.queue = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), ord);
        this.items = 0;
    }

    private PriorityQueue<T> queue() {
        return this.queue;
    }

    private int items() {
        return this.items;
    }

    private void items_$eq(int x$0) {
        this.items = x$0;
    }

    public boolean isEmpty() {
        return this.items() == 0;
    }

    public int size() {
        return this.items();
    }

    public void add(T t) {
        this.modify(() -> this.add$$anonfun$1(t));
    }

    public boolean offer(T t) {
        return this.tryModify((Function0<Object>)((Function0 & Serializable)() -> this.offer$$anonfun$1(t)));
    }

    public T poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.modify(this::poll$$anonfun$1);
    }

    public T addAndPoll(T t) {
        if (this.isEmpty()) {
            return t;
        }
        return this.modify(() -> this.addAndPoll$$anonfun$1(t));
    }

    public T steal(Queue<T> to) {
        ObjectRef t = ObjectRef.create(null);
        boolean bl = !this.isEmpty() && this.tryModify((Function0<Object>)((Function0 & Serializable)() -> this.steal$$anonfun$1(to, t)));
        return (T)t.elem;
    }

    public void drain(Function1<T, BoxedUnit> f) {
        this.modify((Function0 & Serializable)() -> {
            this.drain$$anonfun$1(f);
            return BoxedUnit.UNIT;
        });
    }

    private <T> T modify(Function0<T> f) {
        Object object;
        while (!this.compareAndSet(false, true)) {
        }
        try {
            object = f.apply();
        }
        finally {
            this.set(false);
        }
        return (T)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> boolean tryModify(Function0<Object> f) {
        boolean bl;
        if (!this.compareAndSet(false, true)) return false;
        try {
            bl = f.apply$mcZ$sp();
        }
        finally {
            this.set(false);
        }
        if (!bl) return false;
        return true;
    }

    @Override
    public String toString() {
        return (String)this.modify(this::toString$$anonfun$1);
    }

    private final PriorityQueue add$$anonfun$1(Object t$1) {
        this.items_$eq(this.items() + 1);
        return this.queue().addOne(t$1);
    }

    private final boolean offer$$anonfun$1(Object t$2) {
        this.items_$eq(this.items() + 1);
        this.queue().addOne(t$2);
        return true;
    }

    private final Object poll$$anonfun$1() {
        if (this.isEmpty()) {
            return null;
        }
        this.items_$eq(this.items() - 1);
        return this.queue().dequeue();
    }

    private final Object addAndPoll$$anonfun$1(Object t$3) {
        if (this.isEmpty()) {
            return t$3;
        }
        Object r = this.queue().dequeue();
        this.queue().addOne(t$3);
        return r;
    }

    private final boolean steal$$anonfun$1$$anonfun$1(Queue to$2, ObjectRef t$5) {
        int i;
        Object object;
        t$5.elem = object = this.queue().dequeue();
        object = null;
        int s = this.size() - 1;
        this.items_$eq(this.items() - (i + 1));
        to$2.items_$eq(to$2.items() + i);
        for (i = s - s / 2; i > 0; --i) {
            to$2.queue().addOne(this.queue().dequeue());
        }
        return true;
    }

    private final boolean steal$$anonfun$1(Queue to$1, ObjectRef t$4) {
        return !this.isEmpty() && to$1.isEmpty() && to$1.tryModify((Function0<Object>)((Function0 & Serializable)() -> this.steal$$anonfun$1$$anonfun$1(to$1, t$4)));
    }

    private final void drain$$anonfun$1(Function1 f$1) {
        this.items_$eq(0);
        this.queue().foreach(f$1);
        this.queue().clear();
    }

    private final String toString$$anonfun$1() {
        return new StringBuilder(7).append("Queue(").append(this.queue().mkString(",")).append(")").toString();
    }
}

