/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import scala.Int$;

public final class MovingStdDev {
    private final int exp;
    private final int mask;
    private long[] values;
    private long[] devs;
    private int idx;
    private long sum;
    private long sumDev;
    private volatile long _avg;
    private volatile long _dev;

    public MovingStdDev(int exp) {
        this.exp = exp;
        int window = 1 << exp;
        this.mask = window - 1;
        this.values = new long[window];
        this.devs = new long[window];
        this.idx = 0;
        this.sum = 0L;
        this.sumDev = 0L;
        this._avg = 0L;
        this._dev = 0L;
    }

    public long dev() {
        return this._dev;
    }

    public long avg() {
        return this._avg;
    }

    public void observe(long v) {
        long prev = this.values[this.idx];
        this.values[this.idx] = v;
        this.sum = this.sum - prev + v;
        this._avg = this.sum >> this.exp;
        long currDev = (v - this._avg) * (v - this._avg);
        long prevDev = this.devs[this.idx];
        this.devs[this.idx] = currDev;
        this.sumDev = this.sumDev - prevDev + currDev;
        this._dev = Int$.MODULE$.int2long((int)Math.sqrt(this.sumDev >> this.exp));
        this.idx = this.idx + 1 & this.mask;
    }

    public String toString() {
        return new StringBuilder(23).append("MovingStdDev(avg=").append(this._avg).append(",dev=").append(this._dev).append(")").toString();
    }
}

