/*
 * Decompiled with CFR 0.152.
 */
package kyo.concurrent.scheduler;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import kyo.concurrent.scheduler.Coordinator$;
import kyo.concurrent.scheduler.Flag$;
import kyo.concurrent.scheduler.Flag$Reader$;
import kyo.concurrent.scheduler.IOTask;
import kyo.concurrent.scheduler.Threads$;
import kyo.concurrent.scheduler.Worker;
import kyo.concurrent.scheduler.Worker$;
import kyo.concurrent.scheduler.XSRandom$;
import org.jctools.queues.MpmcUnboundedXaddArrayQueue;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Scheduler$
implements Serializable {
    private static final int coreWorkers;
    private static volatile int concurrencyLimit;
    private static final AtomicInteger concurrency;
    private static final MpmcUnboundedXaddArrayQueue<Worker> idle;
    private static final ExecutorService pool;
    public static final Scheduler$ MODULE$;

    private Scheduler$() {
    }

    static {
        MODULE$ = new Scheduler$();
        concurrencyLimit = coreWorkers = BoxesRunTime.unboxToInt((Object)Flag$.MODULE$.apply("coreWorkers", BoxesRunTime.boxToInteger((int)Predef$.MODULE$.double2Double(Math.ceil((double)Runtime.getRuntime().availableProcessors() / (double)2)).intValue()), Flag$Reader$.MODULE$.intReader()));
        concurrency = new AtomicInteger(0);
        idle = new MpmcUnboundedXaddArrayQueue(8);
        pool = Executors.newCachedThreadPool(Threads$.MODULE$.apply("kyo-worker", (Function1<Runnable, Thread>)(Function1 & Serializable)_$1 -> new Worker((Runnable)_$1)));
        MODULE$.startWorkers();
        Coordinator$.MODULE$.load();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Scheduler$.class);
    }

    public void removeWorker() {
        if (concurrencyLimit > coreWorkers) {
            concurrencyLimit = Math.max(1, concurrency.get() - 1);
            return;
        }
    }

    public void addWorker() {
        concurrencyLimit = Math.max(concurrencyLimit, concurrency.get()) + 1;
        this.startWorkers();
    }

    private void startWorkers() {
        int c = concurrency.get();
        while (c < concurrencyLimit && concurrency.compareAndSet(c, c + 1)) {
            pool.execute(() -> Worker$.MODULE$.apply().runWorker(null));
            c = concurrency.get();
        }
    }

    public void flush() {
        Worker w = Worker$.MODULE$.apply();
        if (w != null) {
            w.flush();
            return;
        }
    }

    public void schedule(IOTask<?> t) {
        Worker local = Worker$.MODULE$.apply();
        if (local != null && local.enqueueLocal(t)) {
            return;
        }
        this.schedule(t, local);
    }

    public void schedule(IOTask<?> t, Worker submitter) {
        Worker w1;
        Worker w0;
        do {
            Worker w;
            if ((w = (Worker)idle.poll()) != null) {
                Worker worker = w;
                Worker worker2 = submitter;
                if ((worker == null ? worker2 != null : !worker.equals(worker2)) && w.enqueue(t)) {
                    return;
                }
            }
            w0 = this.randomWorker(submitter);
            w1 = this.randomWorker(submitter);
            if (w0.load() <= w1.load()) continue;
            Worker w2 = w0;
            w0 = w1;
            w1 = w2;
        } while (!w0.enqueue(t) && !w1.enqueue(t));
    }

    public IOTask<?> steal(Worker thief) {
        IOTask<?> r = null;
        Worker w0 = this.randomWorker(thief);
        Worker w1 = this.randomWorker(thief);
        if (w0.load() < w1.load()) {
            Worker w = w0;
            w0 = w1;
            w1 = w;
        }
        if ((r = w0.steal(thief)) == null) {
            r = w1.steal(thief);
        }
        return r;
    }

    public double loadAvg() {
        long sum = 0L;
        Iterator<Worker> it = Worker$.MODULE$.all().iterator();
        int c = 0;
        while (it.hasNext()) {
            sum += (long)it.next().load();
            ++c;
        }
        return Predef$.MODULE$.long2Long(sum).doubleValue() / (double)c;
    }

    public void cycle() {
        Worker$.MODULE$.all().forEach(_$2 -> _$2.cycle());
    }

    public void idle(Worker w) {
        if (w.load() == 0) {
            idle.add((Object)w);
            w.park();
            return;
        }
    }

    public boolean stopWorker() {
        int c = concurrency.get();
        return c > concurrencyLimit && concurrency.compareAndSet(c, c - 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Worker randomWorker(Worker besides) {
        Object w = null;
        while (true) {
            if (w != null) {
                Object object = w;
                Worker worker = besides;
                if (object != null ? !object.equals(worker) : worker != null) return w;
            }
            try {
                CopyOnWriteArrayList<Worker> a = Worker$.MODULE$.all();
                w = a.get(XSRandom$.MODULE$.nextInt(a.size()));
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof ArrayIndexOutOfBoundsException) && !(throwable2 instanceof IllegalArgumentException)) throw throwable;
                continue;
            }
            break;
        }
    }

    public String toString() {
        return new StringBuilder(39).append("Scheduler(loadAvg=").append(this.loadAvg()).append(",concurrency=").append(concurrency).append(",limit=").append(concurrencyLimit).append(")").toString();
    }
}

