/*
 * Decompiled with CFR 0.152.
 */
package kyo.concurrent.scheduler;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kyo.concurrent.scheduler.IOTask;
import kyo.concurrent.scheduler.ThreadFactory$;
import kyo.concurrent.scheduler.Worker;
import kyo.concurrent.scheduler.Worker$;
import kyo.concurrent.scheduler.XSRandom$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class Scheduler$
implements Serializable {
    private static volatile int concurrencyLimit;
    private static final AtomicInteger concurrency;
    private static final CopyOnWriteArrayList workers;
    private static final AtomicReference<List<Worker>> idle;
    private static final ExecutorService pool;
    public static final Scheduler$ MODULE$;

    private Scheduler$() {
    }

    static {
        int coreWorkers;
        MODULE$ = new Scheduler$();
        concurrencyLimit = coreWorkers = Runtime.getRuntime().availableProcessors();
        concurrency = new AtomicInteger(0);
        workers = new CopyOnWriteArrayList();
        idle = new AtomicReference<Nil$>(package$.MODULE$.Nil());
        pool = Executors.newCachedThreadPool(ThreadFactory$.MODULE$.apply("kyo-worker", (Function1<Runnable, Thread>)(Function1 & Serializable)_$1 -> new Worker((Runnable)_$1)));
        MODULE$.startWorkers();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Scheduler$.class);
    }

    public CopyOnWriteArrayList<Worker> workers() {
        return workers;
    }

    public void removeWorker() {
        concurrencyLimit = Math.max(1, concurrency.get() - 1);
    }

    public void addWorker() {
        concurrencyLimit = Math.max(concurrencyLimit, concurrency.get()) + 1;
        this.startWorkers();
    }

    private void startWorkers() {
        int c = concurrency.get();
        while (c < concurrencyLimit && concurrency.compareAndSet(c, c + 1)) {
            pool.execute(() -> Worker$.MODULE$.apply().runWorker(null));
            c = concurrency.get();
        }
    }

    public <T> void schedule(IOTask<?> t) {
        Worker w = Worker$.MODULE$.apply();
        if (w != null) {
            w.enqueueLocal(t);
            return;
        }
        this.submit(t);
    }

    public void submit(IOTask<?> t) {
        Worker w1;
        Worker w0;
        do {
            Worker w;
            boolean ok;
            List<Worker> iw;
            if ((iw = idle.get()) != package$.MODULE$.Nil() && idle.compareAndSet(iw, (List<Worker>)iw.tail()) && (ok = (w = (Worker)iw.head()).enqueue(t))) {
                return;
            }
            w0 = this.randomWorker();
            w1 = this.randomWorker();
            if (w0.load() <= w1.load()) continue;
            Worker w2 = w0;
            w0 = w1;
            w1 = w2;
        } while (!w0.enqueue(t) && !w1.enqueue(t));
    }

    public IOTask<?> steal(Worker w) {
        IOTask<?> r = null;
        Worker w0 = this.randomWorker();
        Worker w1 = this.randomWorker();
        if (w0.load() < w1.load()) {
            Worker w2 = w0;
            w0 = w1;
            w1 = w2;
        }
        if ((r = w0.steal(w)) == null) {
            r = w1.steal(w);
        }
        return r;
    }

    public double loadAvg() {
        long sum = 0L;
        Iterator<Worker> it = this.workers().iterator();
        int c = 0;
        while (it.hasNext()) {
            sum += (long)it.next().load();
            ++c;
        }
        return Predef$.MODULE$.long2Long(sum).doubleValue() / (double)c;
    }

    public void cycle() {
        this.workers().forEach(_$2 -> _$2.cycle());
    }

    public void idle(Worker w) {
        List<Worker> i = idle.get();
        List ni = i.$colon$colon((Object)w);
        if (w.load() == 0 && idle.compareAndSet(i, (List<Worker>)ni)) {
            w.park();
            idle.compareAndSet((List<Worker>)ni, i);
            return;
        }
    }

    public boolean stopWorker() {
        int c = concurrency.get();
        return c > concurrencyLimit && concurrency.compareAndSet(c, c - 1);
    }

    private Worker randomWorker() {
        Worker worker;
        while (true) {
            try {
                worker = this.workers().get(XSRandom$.MODULE$.nextInt(this.workers().size()));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if ((throwable2 = throwable) instanceof ArrayIndexOutOfBoundsException || throwable2 instanceof IllegalArgumentException) continue;
                throw throwable;
            }
            break;
        }
        return worker;
    }

    public String toString() {
        String w = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.workers()).asScala().map((Function1 & Serializable)_$3 -> _$3.toString())).mkString("\n");
        return new StringBuilder(40).append(w).append("\nScheduler(loadAvg=").append(this.loadAvg()).append(",concurrency=").append(concurrency).append(",limit=").append(concurrencyLimit).append(")").toString();
    }
}

