/*
 * Decompiled with CFR 0.152.
 */
package kyo.concurrent.scheduler;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kyo.concurrent.scheduler.MovingStdDev;
import kyo.concurrent.scheduler.Scheduler$;
import kyo.concurrent.scheduler.ThreadFactory$;
import scala.Int$;
import scala.Predef$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class Coordinator$
implements Serializable {
    private static final int cycleMask;
    private static volatile long ticks;
    private static volatile long cycles;
    private static long startNs;
    private static final MovingStdDev delayNs;
    private static final ExecutorService exec;
    public static final Coordinator$ MODULE$;

    private Coordinator$() {
    }

    static {
        MODULE$ = new Coordinator$();
        int cycleExp = 7;
        int cycleTicks = Predef$.MODULE$.double2Double(Math.pow(2.0, Int$.MODULE$.int2double(cycleExp))).intValue();
        cycleMask = cycleTicks - 1;
        ticks = 0L;
        long a1 = 0L;
        long a2 = 0L;
        long a3 = 0L;
        long a4 = 0L;
        long a5 = 0L;
        long a6 = 0L;
        long a7 = 0L;
        cycles = 0L;
        long b1 = 0L;
        long b2 = 0L;
        long b3 = 0L;
        long b4 = 0L;
        long b5 = 0L;
        long b6 = 0L;
        long b7 = 0L;
        startNs = 0L;
        delayNs = new MovingStdDev(cycleExp);
        exec = Executors.newCachedThreadPool(ThreadFactory$.MODULE$.apply("kyo-coordinator"));
        exec.execute(() -> {
            startNs = System.nanoTime();
            while (true) {
                this.update();
            }
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Coordinator$.class);
    }

    public long tick() {
        return ticks;
    }

    public long cycle() {
        return cycles;
    }

    private double jitter() {
        return Predef$.MODULE$.long2Long(delayNs.dev()).doubleValue() / (double)10000;
    }

    private void update() {
        try {
            Thread.sleep(1L);
            long endNs = System.nanoTime();
            delayNs.observe(endNs - startNs - 1000000L);
            startNs = endNs;
            if ((++ticks & (long)cycleMask) == 0L) {
                ++cycles;
                exec.execute(() -> this.adapt());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                ex.printStackTrace();
            }
            throw throwable;
        }
    }

    private void adapt() {
        Scheduler$.MODULE$.cycle();
        double j = this.jitter();
        double l = Scheduler$.MODULE$.loadAvg();
        if (j >= 0.08) {
            Scheduler$.MODULE$.removeWorker();
        } else if (j <= 0.04 && l > 0.8) {
            Scheduler$.MODULE$.addWorker();
        } else if (l < 0.8) {
            Scheduler$.MODULE$.removeWorker();
        }
    }

    public String toString() {
        return new StringBuilder(57).append("Coordinator(ticks=").append(ticks).append(",cycles=").append(cycles).append(",delay.dev=").append(delayNs.dev()).append(",delay.avg=").append(delayNs.avg()).append(",jitter=").append(this.jitter()).append(")").toString();
    }
}

