/*
 * Decompiled with CFR 0.152.
 */
package kyo.concurrent.scheduler;

import java.io.Serializable;
import java.util.concurrent.locks.LockSupport;
import kyo.concurrent.scheduler.IOTask;
import kyo.concurrent.scheduler.MovingStdDev;
import kyo.concurrent.scheduler.Queue;
import kyo.concurrent.scheduler.Scheduler$;
import kyo.concurrent.scheduler.Worker$;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public class Worker
extends Thread {
    private final Queue queue = new Queue();
    private volatile boolean running = false;
    private volatile IOTask currentTask = null;
    private volatile Thread parkedThread = null;
    private final MovingStdDev delay = new MovingStdDev(7);

    public static Worker apply() {
        return Worker$.MODULE$.apply();
    }

    public Worker(Runnable r) {
        super(r);
    }

    public Queue<IOTask<?>> queue() {
        return this.queue;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public IOTask<?> currentTask() {
        return this.currentTask;
    }

    public void currentTask_$eq(IOTask<?> x$1) {
        this.currentTask = x$1;
    }

    public Thread parkedThread() {
        return this.parkedThread;
    }

    public void parkedThread_$eq(Thread x$1) {
        this.parkedThread = x$1;
    }

    public MovingStdDev delay() {
        return this.delay;
    }

    public void park() {
        this.parkedThread_$eq(this);
        LockSupport.parkNanos(this, 100000000L);
        this.parkedThread_$eq(null);
    }

    public IOTask<?> steal(Worker w) {
        return this.queue().steal(w.queue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enqueue(IOTask<?> t) {
        if (!this.running()) return false;
        IOTask<?> curr = this.currentTask();
        if (curr != null) {
            if (curr.apply()) return false;
        }
        if (!this.queue().offer(t)) return false;
        boolean bl = true;
        boolean ok = bl;
        if (ok) {
            LockSupport.unpark(this.parkedThread());
        }
        if (!ok) return false;
        return true;
    }

    public void cycle() {
        IOTask<?> t = this.currentTask();
        if (t != null && !this.queue().isEmpty()) {
            t.preempt();
            return;
        }
    }

    public void enqueueLocal(IOTask<?> t) {
        this.queue().add(t);
    }

    public int load() {
        int s = this.queue().size();
        if (this.currentTask() != null) {
            ++s;
        }
        return s;
    }

    public void runWorker(IOTask<?> init) {
        IOTask<?> task = init;
        this.running_$eq(true);
        Scheduler$.MODULE$.workers().add(this);
        while (!this.stop$1()) {
            if (task == null) {
                task = this.queue().poll();
            }
            if (task != null) {
                this.currentTask_$eq(task);
                boolean done = task.run();
                this.currentTask_$eq(null);
                if (!done) {
                    task = this.queue().addAndPoll(task);
                    continue;
                }
                this.delay().observe(task.delay());
                task = null;
                continue;
            }
            task = Scheduler$.MODULE$.steal(this);
            if (task != null) continue;
            Scheduler$.MODULE$.idle(this);
        }
        Scheduler$.MODULE$.workers().remove(this);
        this.running_$eq(false);
        if (task != null) {
            Scheduler$.MODULE$.submit(task);
            task = null;
        }
        this.queue().drain((Function1<IOTask<?>, BoxedUnit>)(JProcedure1 & Serializable)t -> Scheduler$.MODULE$.submit((IOTask<?>)t));
    }

    @Override
    public String toString() {
        return new StringBuilder(53).append("Worker(thread=").append(this.getName()).append(",load=").append(this.load()).append(",delay=").append(this.delay().avg()).append(",task=").append(this.currentTask()).append(",queue.size=").append(this.queue().size()).append(",frame=").append(this.getStackTrace()[0]).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean stop$1() {
        if (!this.running()) return true;
        boolean stop = Scheduler$.MODULE$.stopWorker();
        if (stop) {
            this.running_$eq(false);
        }
        if (!stop) return false;
        return true;
    }
}

