/*
 * Decompiled with CFR 0.152.
 */
package kyo.concurrent.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class Queue<T extends Comparable<T>>
extends AtomicBoolean {
    private final PriorityQueue queue = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Comparable[0]), (Object)Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    private volatile int items = 0;

    private PriorityQueue<T> queue() {
        return this.queue;
    }

    public boolean isEmpty() {
        return this.items == 0;
    }

    public int size() {
        return this.items;
    }

    public void add(T t) {
        while (!this.compareAndSet(false, true)) {
        }
        try {
            this.queue().addOne(t);
        }
        finally {
            this.inline$items_$eq(this.inline$queue().size());
            this.set(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean offer(T t) {
        boolean bl;
        if (!this.compareAndSet(false, true)) return false;
        try {
            this.queue().addOne(t);
            bl = true;
        }
        finally {
            this.inline$items_$eq(this.inline$queue().size());
            this.set(false);
        }
        if (!bl) return false;
        return true;
    }

    public T poll() {
        Comparable comparable;
        if (this.isEmpty()) {
            return null;
        }
        while (!this.compareAndSet(false, true)) {
        }
        try {
            comparable = this.isEmpty() ? null : (Comparable)this.queue().dequeue();
        }
        finally {
            this.inline$items_$eq(this.inline$queue().size());
            this.set(false);
        }
        return (T)comparable;
    }

    public T addAndPoll(T t) {
        Comparable comparable;
        if (this.isEmpty()) {
            return t;
        }
        while (!this.compareAndSet(false, true)) {
        }
        try {
            this.queue().addOne(t);
            comparable = (Comparable)this.queue().dequeue();
        }
        finally {
            this.inline$items_$eq(this.inline$queue().size());
            this.set(false);
        }
        return (T)comparable;
    }

    /*
     * Unable to fully structure code
     */
    public T steal(Queue<T> to) {
        t = null;
        if (this.isEmpty()) ** GOTO lbl-1000
        if (!this.compareAndSet(false, true)) ** GOTO lbl-1000
        try {
            if (this.isEmpty() || !to.isEmpty()) ** GOTO lbl-1000
            Queue_this = to;
            if (!Queue_this.compareAndSet(false, true)) ** GOTO lbl-1000
            try {
                t = (Comparable)this.queue().dequeue();
                s = this.size() - 1;
                for (i = s - s / 2; i > 0; --i) {
                    super.queue().addOne(this.queue().dequeue());
                }
                v0 = true;
            }
            finally {
                Queue_this.inline$items_$eq(Queue_this.inline$queue().size());
                Queue_this.set(false);
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
        }
        finally {
            this.inline$items_$eq(this.inline$queue().size());
            this.set(false);
        }
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        if (v3) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        return (T)t;
    }

    public void drain(Function1<T, BoxedUnit> f) {
        while (!this.compareAndSet(false, true)) {
        }
        try {
            this.queue().foreach(f);
            this.queue().clear();
        }
        finally {
            this.inline$items_$eq(this.inline$queue().size());
            this.set(false);
        }
    }

    @Override
    public String toString() {
        String string;
        while (!this.compareAndSet(false, true)) {
        }
        try {
            string = new StringBuilder(7).append("Queue(").append(this.queue().mkString(",")).append(")").toString();
        }
        finally {
            this.inline$items_$eq(this.inline$queue().size());
            this.set(false);
        }
        return string;
    }

    public final int inline$items() {
        return this.items;
    }

    public final PriorityQueue<T> inline$queue() {
        return this.queue();
    }

    public final void inline$items_$eq(int x$0) {
        this.items = x$0;
    }
}

