/*
 * Decompiled with CFR 0.152.
 */
package kyo.concurrent.scheduler;

import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.LockSupport;
import kyo.concurrent.scheduler.IOTask;
import kyo.concurrent.scheduler.IOTask$;
import kyo.concurrent.scheduler.Queue;
import kyo.concurrent.scheduler.Scheduler$;
import kyo.concurrent.scheduler.Worker$;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public final class Worker
extends Thread {
    private final Queue queue = new Queue(IOTask$.MODULE$.ord());
    private volatile boolean running = false;
    private volatile IOTask<?> currentTask = null;
    private volatile Thread parkedThread = null;
    private final Function1<IOTask<?>, BoxedUnit> schedule = (JProcedure1 & Serializable)t -> Scheduler$.MODULE$.schedule((IOTask<?>)t, this);

    public static CopyOnWriteArrayList<Worker> all() {
        return Worker$.MODULE$.all();
    }

    public static Worker apply() {
        return Worker$.MODULE$.apply();
    }

    public Worker(Runnable r) {
        super(r);
    }

    private Queue<IOTask<?>> queue() {
        return this.queue;
    }

    public void park() {
        this.parkedThread = this;
        LockSupport.parkNanos(this, 1000000L);
        this.parkedThread = null;
    }

    public IOTask<?> steal(Worker thief) {
        return this.queue().steal(thief.queue());
    }

    public boolean enqueueLocal(IOTask<?> t) {
        return this.running && this.queue().offer(t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enqueue(IOTask<?> t) {
        if (!this.running) return false;
        if (!this.queue().offer(t)) return false;
        LockSupport.unpark(this.parkedThread);
        if (!true) return false;
        return true;
    }

    public void cycle() {
        IOTask<?> t = this.currentTask;
        if (t != null && !this.queue().isEmpty()) {
            t.preempt();
            return;
        }
    }

    public void flush() {
        this.queue().drain(this.schedule);
    }

    public int load() {
        int s = this.queue().size();
        if (this.currentTask != null) {
            ++s;
        }
        return s;
    }

    public void runWorker(IOTask<?> init) {
        IOTask<?> task = init;
        this.running = true;
        Worker$.MODULE$.all().add(this);
        while (!this.stop$1()) {
            if (task == null) {
                task = this.queue().poll();
            }
            if (task != null) {
                this.currentTask = task;
                task.run();
                this.currentTask = null;
                if (task.reenqueue()) {
                    task = this.queue().addAndPoll(task);
                    continue;
                }
                task = null;
                continue;
            }
            task = Scheduler$.MODULE$.steal(this);
            if (task != null) continue;
            Scheduler$.MODULE$.idle(this);
        }
        Worker$.MODULE$.all().remove(this);
        this.running = false;
        if (task != null) {
            this.queue().add(task);
        }
        this.flush();
    }

    @Override
    public String toString() {
        return new StringBuilder(46).append("Worker(thread=").append(this.getName()).append(",load=").append(this.load()).append(",task=").append(this.currentTask).append(",queue.size=").append(this.queue().size()).append(",frame=").append(this.getStackTrace()[0]).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean stop$1() {
        if (!this.running) return true;
        boolean stop = Scheduler$.MODULE$.stopWorker();
        if (stop) {
            this.running = false;
        }
        if (!stop) return false;
        return true;
    }
}

