/*
 * Decompiled with CFR 0.152.
 */
package kyo.concurrent.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class Queue<T>
extends AtomicBoolean {
    private final PriorityQueue queue;
    private volatile int items;

    public Queue(Ordering<T> ord) {
        this.queue = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), ord);
        this.items = 0;
    }

    private PriorityQueue<T> queue() {
        return this.queue;
    }

    private int items() {
        return this.items;
    }

    private void items_$eq(int x$0) {
        this.items = x$0;
    }

    public boolean isEmpty() {
        return this.items() == 0;
    }

    public int size() {
        return this.items();
    }

    public void add(T t) {
        while (!this.compareAndSet(false, true)) {
        }
        try {
            this.items_$eq(this.items() + 1);
            this.queue().addOne(t);
        }
        finally {
            this.set(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean offer(T t) {
        boolean bl;
        if (!this.compareAndSet(false, true)) return false;
        try {
            this.items_$eq(this.items() + 1);
            this.queue().addOne(t);
            bl = true;
        }
        finally {
            this.set(false);
        }
        if (!bl) return false;
        return true;
    }

    public T poll() {
        Object object;
        if (this.isEmpty()) {
            return null;
        }
        while (!this.compareAndSet(false, true)) {
        }
        try {
            if (this.isEmpty()) {
                object = null;
            } else {
                this.items_$eq(this.items() - 1);
                object = this.queue().dequeue();
            }
        }
        finally {
            this.set(false);
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public T addAndPoll(T t) {
        T t2;
        if (this.isEmpty()) {
            return t;
        }
        while (!this.compareAndSet(false, true)) {
        }
        try {
            if (this.isEmpty()) {
                t2 = t;
            } else {
                void var2_2;
                Object r = this.queue().dequeue();
                this.queue().addOne(t);
                t2 = var2_2;
            }
        }
        finally {
            this.set(false);
        }
        return t2;
    }

    /*
     * Unable to fully structure code
     */
    public T steal(Queue<T> to) {
        t = null;
        if (this.isEmpty()) ** GOTO lbl-1000
        if (!this.compareAndSet(false, true)) ** GOTO lbl-1000
        try {
            if (this.isEmpty() || !to.isEmpty()) ** GOTO lbl-1000
            Queue_this = to;
            if (!Queue_this.compareAndSet(false, true)) ** GOTO lbl-1000
            try {
                t = this.queue().dequeue();
                s = this.size() - 1;
                this.items_$eq(this.items() - (i + 1));
                super.items_$eq(super.items() + i);
                for (i = s - s / 2; i > 0; --i) {
                    super.queue().addOne(this.queue().dequeue());
                }
                v0 = true;
            }
            finally {
                Queue_this.set(false);
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
        }
        finally {
            this.set(false);
        }
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        if (v3) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        return (T)t;
    }

    public void drain(Function1<T, BoxedUnit> f) {
        while (!this.compareAndSet(false, true)) {
        }
        try {
            this.items_$eq(0);
            this.queue().foreach(f);
            this.queue().clear();
        }
        finally {
            this.set(false);
        }
    }

    @Override
    public String toString() {
        String string;
        while (!this.compareAndSet(false, true)) {
        }
        try {
            string = new StringBuilder(7).append("Queue(").append(this.queue().mkString(",")).append(")").toString();
        }
        finally {
            this.set(false);
        }
        return string;
    }
}

