/*
 * Decompiled with CFR 0.152.
 */
package io.getconnect.client;

import io.getconnect.client.DuplicateEventException;
import io.getconnect.client.Event;
import io.getconnect.client.EventPushResponse;
import io.getconnect.client.InvalidCollectionException;
import io.getconnect.client.InvalidEventException;
import io.getconnect.client.JsonSerializer;
import io.getconnect.client.ServerException;
import io.getconnect.client.http.HttpClient;
import io.getconnect.client.http.HttpRequest;
import io.getconnect.client.http.HttpResponse;
import io.getconnect.client.http.StreamWriter;
import io.getconnect.client.store.EventStore;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConnectClient {
    private final String projectId;
    private final String apiKey;
    private final String baseUrl;
    private final HttpClient httpClient;
    private final JsonSerializer serializer;
    private final EventStore eventStore;

    public ConnectClient(String projectId, String apiKey, String baseUrl, HttpClient httpClient, JsonSerializer serializer, EventStore eventStore) {
        this.projectId = projectId;
        this.apiKey = apiKey;
        this.baseUrl = baseUrl == null ? "https://api.getconnect.io" : baseUrl;
        this.httpClient = httpClient;
        this.serializer = serializer;
        this.eventStore = eventStore;
    }

    public void push(String collection, Map<String, Object> event) throws InvalidCollectionException, DuplicateEventException, IOException, InvalidEventException, ServerException {
        URL url;
        try {
            url = new URL(this.baseUrl + "/events/" + collection);
        }
        catch (MalformedURLException ex) {
            throw new InvalidCollectionException("The collection specified is not valid.", ex);
        }
        this.call(url, new Event(event).getEventData());
    }

    public Map<String, EventPushResponse[]> push(Map<String, Map<String, Object>[]> events) throws DuplicateEventException, IOException, InvalidEventException, ServerException {
        URL url = new URL(this.baseUrl + "/events");
        HashMap mappedEvents = new HashMap();
        for (String collection : events.keySet()) {
            ArrayList<Map<String, Object>> newEvents = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> event : events.get(collection)) {
                newEvents.add(new Event(event).getEventData());
            }
            mappedEvents.put(collection, newEvents);
        }
        HttpResponse response = this.call(url, mappedEvents);
        StringReader reader = new StringReader(response.getResponse());
        Map<String, Object> responseBody = this.serializer.deserialize(reader);
        reader.close();
        HashMap<String, EventPushResponse[]> pushResponse = new HashMap<String, EventPushResponse[]>();
        for (String collection : responseBody.keySet()) {
            Map[] eventResponses = (Map[])responseBody.get(collection);
            ArrayList<EventPushResponse> mappedResponses = new ArrayList<EventPushResponse>();
            int i = 0;
            for (Map eventResponse : eventResponses) {
                Map<String, Object> event = events.get(collection)[i++];
                mappedResponses.add(new EventPushResponse(eventResponse, event));
            }
            pushResponse.put(collection, mappedResponses.toArray(new EventPushResponse[mappedResponses.size()]));
        }
        return pushResponse;
    }

    protected HttpResponse call(URL url, final Map<String, ?> data) throws DuplicateEventException, IOException, InvalidEventException, ServerException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Project-Id", this.projectId);
        headers.put("X-Api-Key", this.apiKey);
        StreamWriter writer = new StreamWriter(){

            @Override
            public void write(OutputStream stream) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
                ConnectClient.this.serializer.serialize(writer, data);
            }
        };
        HttpResponse response = this.httpClient.send(new HttpRequest(url, "POST", headers, writer));
        if (response.getStatusCode() == 200) {
            return response;
        }
        StringReader reader = new StringReader(response.getResponse());
        Map<String, Object> responseBody = this.serializer.deserialize(reader);
        reader.close();
        switch (response.getStatusCode()) {
            case 409: {
                throw new DuplicateEventException((String)responseBody.get("errorMessage"));
            }
            case 422: {
                HashMap<String, String> errors = new HashMap<String, String>();
                for (Map fieldError : (Iterable)responseBody.get("errors")) {
                    errors.put((String)fieldError.get("field"), (String)fieldError.get("description"));
                }
                throw InvalidEventException.create(errors);
            }
        }
        throw new ServerException((String)responseBody.get("errorMessage"));
    }

    public synchronized void add(String collection, Map<String, Object> event) throws IOException {
        this.eventStore.add(collection, new Event(event));
    }

    public synchronized Map<String, EventPushResponse[]> pushPending() throws IOException {
        URL url = new URL(this.baseUrl + "/events");
        Map<String, Event[]> events = this.eventStore.readAll();
        HashMap mappedEvents = new HashMap();
        for (String collection : events.keySet()) {
            ArrayList<Map<String, Object>> newEvents = new ArrayList<Map<String, Object>>();
            for (Event event : events.get(collection)) {
                newEvents.add(event.getEventData());
            }
            mappedEvents.put(collection, newEvents);
        }
        HttpResponse response = this.call(url, mappedEvents);
        StringReader reader = new StringReader(response.getResponse());
        Map<String, Object> responseBody = this.serializer.deserialize(reader);
        reader.close();
        HashMap<String, EventPushResponse[]> pushResponse = new HashMap<String, EventPushResponse[]>();
        for (String collection : responseBody.keySet()) {
            Iterable eventResponses = (Iterable)responseBody.get(collection);
            ArrayList<EventPushResponse> mappedResponses = new ArrayList<EventPushResponse>();
            int i = 0;
            for (Map eventResponse : eventResponses) {
                Event event;
                EventPushResponse mappedResponse = new EventPushResponse(eventResponse, (event = events.get(collection)[i++]).getEventData());
                if (mappedResponse.isSuccessful().booleanValue() || mappedResponse.isDuplicate().booleanValue()) {
                    this.eventStore.acknowledge(collection, event);
                }
                mappedResponses.add(mappedResponse);
            }
            pushResponse.put(collection, mappedResponses.toArray(new EventPushResponse[mappedResponses.size()]));
        }
        return pushResponse;
    }
}

