/*
 * Decompiled with CFR 0.152.
 */
package io.getconnect.client;

import io.getconnect.client.ConnectAPI;
import io.getconnect.client.ConnectBatchCallback;
import io.getconnect.client.ConnectCallback;
import io.getconnect.client.Event;
import io.getconnect.client.EventPushResponse;
import io.getconnect.client.exceptions.ConnectException;
import io.getconnect.client.store.EventStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConnectClient {
    private final String projectId;
    private final String apiKey;
    private final EventStore eventStore;
    private final ConnectAPI connectAPI;

    public ConnectClient(String projectId, String apiKey, String baseUrl, EventStore eventStore) {
        this.projectId = projectId;
        this.apiKey = apiKey;
        this.eventStore = eventStore;
        this.connectAPI = new ConnectAPI(projectId, apiKey, baseUrl);
    }

    public void push(String collection, Map<String, Object> event) throws ConnectException {
        this.connectAPI.pushEvent(collection, new Event(event));
    }

    public void pushAsync(String collection, Map<String, Object> event, ConnectCallback callback) {
        Event mappedEvent = null;
        try {
            mappedEvent = new Event(event);
        }
        catch (ConnectException e) {
            if (callback != null) {
                callback.onFailure(e);
            }
            return;
        }
        this.connectAPI.pushEvent(collection, mappedEvent, callback);
    }

    public Map<String, Iterable<EventPushResponse>> pushBatch(Map<String, Map<String, Object>[]> batch) throws ConnectException {
        Map<String, Iterable<Event>> eventBatch = Event.buildEventBatch(batch);
        return this.connectAPI.pushEventBatch(eventBatch);
    }

    public void pushBatchAsync(Map<String, Map<String, Object>[]> batch, ConnectBatchCallback callback) {
        Map<String, Iterable<Event>> eventBatch = null;
        try {
            eventBatch = Event.buildEventBatch(batch);
        }
        catch (ConnectException e) {
            if (callback != null) {
                callback.onFailure(e);
            }
            return;
        }
        this.connectAPI.pushEventBatch(eventBatch, callback);
    }

    public synchronized void add(String collection, Map<String, Object> event) throws ConnectException {
        try {
            this.eventStore.add(collection, new Event(event));
        }
        catch (IOException e) {
            throw new ConnectException(e);
        }
    }

    public synchronized Map<String, Iterable<EventPushResponse>> pushPending() throws ConnectException {
        Map<String, Iterable<Event>> eventBatch = null;
        try {
            eventBatch = this.eventStore.readAll();
        }
        catch (IOException e) {
            throw new ConnectException(e);
        }
        if (eventBatch.size() < 1) {
            return new HashMap<String, Iterable<EventPushResponse>>();
        }
        Map<String, Iterable<EventPushResponse>> details = this.connectAPI.pushEventBatch(eventBatch);
        this.updateStoreWithResponse(details);
        return details;
    }

    public synchronized void pushPendingAsync(final ConnectBatchCallback callback) {
        Map<String, Iterable<Event>> eventBatch = null;
        try {
            eventBatch = this.eventStore.readAll();
        }
        catch (IOException e) {
            if (callback != null) {
                callback.onFailure(new ConnectException(e));
            }
            return;
        }
        if (eventBatch.size() < 1) {
            if (callback != null) {
                callback.onSuccess(new HashMap<String, Iterable<EventPushResponse>>());
            }
            return;
        }
        this.connectAPI.pushEventBatch(eventBatch, new ConnectBatchCallback(){

            @Override
            public void onSuccess(Map<String, Iterable<EventPushResponse>> details) {
                ConnectClient.this.updateStoreWithResponse(details);
                if (callback != null) {
                    callback.onSuccess(details);
                }
            }

            @Override
            public void onFailure(ConnectException e) {
                if (callback != null) {
                    callback.onFailure(e);
                }
            }
        });
    }

    protected synchronized void updateStoreWithResponse(Map<String, Iterable<EventPushResponse>> details) {
        for (String collection : details.keySet()) {
            for (EventPushResponse eventResponse : details.get(collection)) {
                if (!eventResponse.isSuccessful().booleanValue()) continue;
                try {
                    this.eventStore.acknowledge(collection, eventResponse.getEvent());
                }
                catch (IOException e) {}
            }
        }
    }
}

