/*
 * Decompiled with CFR 0.152.
 */
package io.getconnect.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.getconnect.client.GsonUTCDateAdapter;
import io.getconnect.client.exceptions.InvalidEventException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Event {
    private static final Gson gson = GsonUTCDateAdapter.createSerializer();
    protected final String reservedPrefix = "tp_";
    protected final Map<String, Object> eventData;
    protected String eventStoreId;

    public Event(Map<String, Object> eventData) throws InvalidEventException {
        this(eventData, UUID.randomUUID().toString());
    }

    private Event(Map<String, Object> eventData, String eventStoreId) throws InvalidEventException {
        this.eventData = eventData;
        this.eventStoreId = eventStoreId;
        this.validateProperties();
        this.setDefaultProperties();
    }

    public static Event fromEventStore(String eventJSON, String eventStoreId) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map eventData = (Map)gson.fromJson(eventJSON, type);
        return new Event(eventData, eventStoreId);
    }

    public Map<String, Object> getEventData() {
        return this.eventData;
    }

    public String getEventJSON() {
        return gson.toJson(this.eventData);
    }

    public String getId() {
        return this.eventData.get("id").toString();
    }

    public String getEventStoreId() {
        return this.eventStoreId;
    }

    protected void setDefaultProperties() {
        if (!this.eventData.containsKey("id")) {
            this.eventData.put("id", UUID.randomUUID().toString());
        }
        if (!this.eventData.containsKey("timestamp")) {
            this.eventData.put("timestamp", new Date());
        }
    }

    protected void validateProperties() throws InvalidEventException {
        if (this.eventData.isEmpty()) {
            throw new InvalidEventException("The event cannot be sent. It contains no properties");
        }
        HashMap<String, String> invalidProperties = new HashMap<String, String>();
        for (String key : this.eventData.keySet()) {
            if (key.startsWith(this.reservedPrefix)) {
                invalidProperties.put(key, "Property names cannot start with the reserved prefix '" + this.reservedPrefix + "'");
            }
            if (!key.contains(".")) continue;
            invalidProperties.put(key, "Property names cannot contain a period (.)");
        }
        if (!invalidProperties.isEmpty()) {
            throw InvalidEventException.create(invalidProperties);
        }
    }

    public static Map<String, Iterable<Event>> buildEventBatch(Map<String, Iterable<Map<String, Object>>> events) throws InvalidEventException {
        HashMap<String, Iterable<Event>> mappedEvents = new HashMap<String, Iterable<Event>>();
        for (String collection : events.keySet()) {
            ArrayList<Event> newEvents = new ArrayList<Event>();
            for (Map<String, Object> event : events.get(collection)) {
                newEvents.add(new Event(event));
            }
            mappedEvents.put(collection, newEvents);
        }
        return mappedEvents;
    }

    public static String getJSONForEventBatch(Map<String, Iterable<Event>> eventBatch) {
        HashMap batchEventData = new HashMap();
        for (String collection : eventBatch.keySet()) {
            ArrayList<Map<String, Object>> collectionEventData = new ArrayList<Map<String, Object>>();
            for (Event event : eventBatch.get(collection)) {
                collectionEventData.add(event.getEventData());
            }
            batchEventData.put(collection, collectionEventData);
        }
        return gson.toJson(batchEventData);
    }
}

