/*
 * Decompiled with CFR 0.152.
 */
package io.getconnect.client.store;

import io.getconnect.client.Event;
import io.getconnect.client.JsonSerializer;
import io.getconnect.client.store.EventStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FileEventStore
implements EventStore {
    private final File root;
    private final JsonSerializer serializer;

    public FileEventStore(String projectId, File root, JsonSerializer serializer) throws IOException {
        if (!root.exists() || !root.isDirectory()) {
            throw new IOException("The root directory '" + root + "' does not exist or is not a directory.");
        }
        this.root = new File(root, projectId);
        this.serializer = serializer;
    }

    protected File getCollectionDir(String collection) throws IOException {
        File collectionDir = new File(this.root, collection);
        if (collectionDir.exists()) {
            return collectionDir;
        }
        if (!collectionDir.mkdirs()) {
            throw new IOException("Could not create collection directory '" + collectionDir + "'");
        }
        return collectionDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String collection, Event event) throws IOException {
        File collectionDir = this.getCollectionDir(collection);
        File eventFile = new File(collectionDir, event.getEventStoreId() + ".json");
        Writer writer = null;
        try {
            FileOutputStream stream = new FileOutputStream(eventFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            this.serializer.serialize(writer, event.getEventData());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event[] read(String collection) throws IOException {
        File collectionDir = this.getCollectionDir(collection);
        File[] files = collectionDir.listFiles();
        ArrayList<Event> events = new ArrayList<Event>();
        for (File file : files) {
            Reader reader = null;
            try {
                FileInputStream stream = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)stream, "UTF-8");
                Map<String, Object> eventData = this.serializer.deserialize(reader);
                events.add(Event.fromEventStore(eventData, file.getName().replace(".json", "")));
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return events.toArray(new Event[events.size()]);
    }

    @Override
    public Map<String, Event[]> readAll() throws IOException {
        File[] collections;
        HashMap<String, Event[]> events = new HashMap<String, Event[]>();
        for (File collection : collections = this.root.listFiles()) {
            String collectionName = collection.getName();
            events.put(collectionName, this.read(collectionName));
        }
        return events;
    }

    @Override
    public void acknowledge(String collection, Event event) throws IOException {
        File collectionDir = this.getCollectionDir(collection);
        new File(collectionDir, event.getEventStoreId() + ".json").delete();
    }
}

