/*
 * Decompiled with CFR 0.152.
 */
package io.getconnect.client.android;

import io.getconnect.client.JsonSerializer;
import io.getconnect.client.android.JsonHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidJsonSerializer
implements JsonSerializer {
    @Override
    public Map<String, Object> deserialize(Reader reader) throws IOException {
        String json = this.toString(reader);
        try {
            JSONObject object = new JSONObject(json);
            return JsonHelper.toMap(object);
        }
        catch (JSONException ex) {
            throw new IOException("An error occurred parsing the JSON.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            char[] buffer = new char[4096];
            while (reader.read(buffer, 0, 4096) > 0) {
                writer.write(buffer);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void serialize(Writer writer, Map<String, ?> value) throws IOException {
        JSONObject json;
        try {
            json = (JSONObject)JsonHelper.toJSON(value);
        }
        catch (JSONException ex) {
            throw new IOException("An error occurred writing the JSON.", ex);
        }
        writer.write(json.toString());
    }
}

