/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.SubAccount;
import io.gate.gateapi.models.SubAccountKey;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class SubAccountApi {
    private ApiClient localVarApiClient;

    public SubAccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubAccountApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call listSubAccountsCall(String type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sub_accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountsValidateBeforeCall(String type, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSubAccountsCall(type, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SubAccount>> listSubAccountsWithHttpInfo(String type) throws ApiException {
        Call localVarCall = this.listSubAccountsValidateBeforeCall(type, null);
        Type localVarReturnType = new TypeToken<List<SubAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSubAccountsAsync(String type, ApiCallback<List<SubAccount>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountsValidateBeforeCall(type, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSubAccountsRequest listSubAccounts() {
        return new APIlistSubAccountsRequest();
    }

    public Call createSubAccountsCall(SubAccount subAccount, ApiCallback _callback) throws ApiException {
        SubAccount localVarPostBody = subAccount;
        String localVarPath = "/sub_accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSubAccountsValidateBeforeCall(SubAccount subAccount, ApiCallback _callback) throws ApiException {
        if (subAccount == null) {
            throw new ApiException("Missing the required parameter 'subAccount' when calling createSubAccounts(Async)");
        }
        Call localVarCall = this.createSubAccountsCall(subAccount, _callback);
        return localVarCall;
    }

    public SubAccount createSubAccounts(SubAccount subAccount) throws ApiException {
        ApiResponse<SubAccount> localVarResp = this.createSubAccountsWithHttpInfo(subAccount);
        return localVarResp.getData();
    }

    public ApiResponse<SubAccount> createSubAccountsWithHttpInfo(SubAccount subAccount) throws ApiException {
        Call localVarCall = this.createSubAccountsValidateBeforeCall(subAccount, null);
        Type localVarReturnType = new TypeToken<SubAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSubAccountsAsync(SubAccount subAccount, ApiCallback<SubAccount> _callback) throws ApiException {
        Call localVarCall = this.createSubAccountsValidateBeforeCall(subAccount, _callback);
        Type localVarReturnType = new TypeToken<SubAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSubAccountCall(Long userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sub_accounts/{user_id}".replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubAccountValidateBeforeCall(Long userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getSubAccount(Async)");
        }
        Call localVarCall = this.getSubAccountCall(userId, _callback);
        return localVarCall;
    }

    public SubAccount getSubAccount(Long userId) throws ApiException {
        ApiResponse<SubAccount> localVarResp = this.getSubAccountWithHttpInfo(userId);
        return localVarResp.getData();
    }

    public ApiResponse<SubAccount> getSubAccountWithHttpInfo(Long userId) throws ApiException {
        Call localVarCall = this.getSubAccountValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<SubAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSubAccountAsync(Long userId, ApiCallback<SubAccount> _callback) throws ApiException {
        Call localVarCall = this.getSubAccountValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<SubAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSubAccountKeysCall(Integer userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sub_accounts/{user_id}/keys".replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountKeysValidateBeforeCall(Integer userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listSubAccountKeys(Async)");
        }
        Call localVarCall = this.listSubAccountKeysCall(userId, _callback);
        return localVarCall;
    }

    public List<SubAccountKey> listSubAccountKeys(Integer userId) throws ApiException {
        ApiResponse<List<SubAccountKey>> localVarResp = this.listSubAccountKeysWithHttpInfo(userId);
        return localVarResp.getData();
    }

    public ApiResponse<List<SubAccountKey>> listSubAccountKeysWithHttpInfo(Integer userId) throws ApiException {
        Call localVarCall = this.listSubAccountKeysValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<List<SubAccountKey>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSubAccountKeysAsync(Integer userId, ApiCallback<List<SubAccountKey>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountKeysValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountKey>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSubAccountKeysCall(Long userId, SubAccountKey subAccountKey, ApiCallback _callback) throws ApiException {
        SubAccountKey localVarPostBody = subAccountKey;
        String localVarPath = "/sub_accounts/{user_id}/keys".replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSubAccountKeysValidateBeforeCall(Long userId, SubAccountKey subAccountKey, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createSubAccountKeys(Async)");
        }
        if (subAccountKey == null) {
            throw new ApiException("Missing the required parameter 'subAccountKey' when calling createSubAccountKeys(Async)");
        }
        Call localVarCall = this.createSubAccountKeysCall(userId, subAccountKey, _callback);
        return localVarCall;
    }

    public List<SubAccountKey> createSubAccountKeys(Long userId, SubAccountKey subAccountKey) throws ApiException {
        ApiResponse<List<SubAccountKey>> localVarResp = this.createSubAccountKeysWithHttpInfo(userId, subAccountKey);
        return localVarResp.getData();
    }

    public ApiResponse<List<SubAccountKey>> createSubAccountKeysWithHttpInfo(Long userId, SubAccountKey subAccountKey) throws ApiException {
        Call localVarCall = this.createSubAccountKeysValidateBeforeCall(userId, subAccountKey, null);
        Type localVarReturnType = new TypeToken<List<SubAccountKey>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSubAccountKeysAsync(Long userId, SubAccountKey subAccountKey, ApiCallback<List<SubAccountKey>> _callback) throws ApiException {
        Call localVarCall = this.createSubAccountKeysValidateBeforeCall(userId, subAccountKey, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountKey>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSubAccountKeyCall(Integer userId, String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sub_accounts/{user_id}/keys/{key}".replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubAccountKeyValidateBeforeCall(Integer userId, String key, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getSubAccountKey(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getSubAccountKey(Async)");
        }
        Call localVarCall = this.getSubAccountKeyCall(userId, key, _callback);
        return localVarCall;
    }

    public SubAccountKey getSubAccountKey(Integer userId, String key) throws ApiException {
        ApiResponse<SubAccountKey> localVarResp = this.getSubAccountKeyWithHttpInfo(userId, key);
        return localVarResp.getData();
    }

    public ApiResponse<SubAccountKey> getSubAccountKeyWithHttpInfo(Integer userId, String key) throws ApiException {
        Call localVarCall = this.getSubAccountKeyValidateBeforeCall(userId, key, null);
        Type localVarReturnType = new TypeToken<SubAccountKey>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSubAccountKeyAsync(Integer userId, String key, ApiCallback<SubAccountKey> _callback) throws ApiException {
        Call localVarCall = this.getSubAccountKeyValidateBeforeCall(userId, key, _callback);
        Type localVarReturnType = new TypeToken<SubAccountKey>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSubAccountKeysCall(Integer userId, String key, SubAccountKey subAccountKey, ApiCallback _callback) throws ApiException {
        SubAccountKey localVarPostBody = subAccountKey;
        String localVarPath = "/sub_accounts/{user_id}/keys/{key}".replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSubAccountKeysValidateBeforeCall(Integer userId, String key, SubAccountKey subAccountKey, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling updateSubAccountKeys(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateSubAccountKeys(Async)");
        }
        if (subAccountKey == null) {
            throw new ApiException("Missing the required parameter 'subAccountKey' when calling updateSubAccountKeys(Async)");
        }
        Call localVarCall = this.updateSubAccountKeysCall(userId, key, subAccountKey, _callback);
        return localVarCall;
    }

    public void updateSubAccountKeys(Integer userId, String key, SubAccountKey subAccountKey) throws ApiException {
        this.updateSubAccountKeysWithHttpInfo(userId, key, subAccountKey);
    }

    public ApiResponse<Void> updateSubAccountKeysWithHttpInfo(Integer userId, String key, SubAccountKey subAccountKey) throws ApiException {
        Call localVarCall = this.updateSubAccountKeysValidateBeforeCall(userId, key, subAccountKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateSubAccountKeysAsync(Integer userId, String key, SubAccountKey subAccountKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateSubAccountKeysValidateBeforeCall(userId, key, subAccountKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteSubAccountKeysCall(Integer userId, String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sub_accounts/{user_id}/keys/{key}".replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSubAccountKeysValidateBeforeCall(Integer userId, String key, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteSubAccountKeys(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling deleteSubAccountKeys(Async)");
        }
        Call localVarCall = this.deleteSubAccountKeysCall(userId, key, _callback);
        return localVarCall;
    }

    public void deleteSubAccountKeys(Integer userId, String key) throws ApiException {
        this.deleteSubAccountKeysWithHttpInfo(userId, key);
    }

    public ApiResponse<Void> deleteSubAccountKeysWithHttpInfo(Integer userId, String key) throws ApiException {
        Call localVarCall = this.deleteSubAccountKeysValidateBeforeCall(userId, key, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSubAccountKeysAsync(Integer userId, String key, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSubAccountKeysValidateBeforeCall(userId, key, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call lockSubAccountCall(Long userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sub_accounts/{user_id}/lock".replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call lockSubAccountValidateBeforeCall(Long userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling lockSubAccount(Async)");
        }
        Call localVarCall = this.lockSubAccountCall(userId, _callback);
        return localVarCall;
    }

    public void lockSubAccount(Long userId) throws ApiException {
        this.lockSubAccountWithHttpInfo(userId);
    }

    public ApiResponse<Void> lockSubAccountWithHttpInfo(Long userId) throws ApiException {
        Call localVarCall = this.lockSubAccountValidateBeforeCall(userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call lockSubAccountAsync(Long userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.lockSubAccountValidateBeforeCall(userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call unlockSubAccountCall(Long userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sub_accounts/{user_id}/unlock".replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unlockSubAccountValidateBeforeCall(Long userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling unlockSubAccount(Async)");
        }
        Call localVarCall = this.unlockSubAccountCall(userId, _callback);
        return localVarCall;
    }

    public void unlockSubAccount(Long userId) throws ApiException {
        this.unlockSubAccountWithHttpInfo(userId);
    }

    public ApiResponse<Void> unlockSubAccountWithHttpInfo(Long userId) throws ApiException {
        Call localVarCall = this.unlockSubAccountValidateBeforeCall(userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call unlockSubAccountAsync(Long userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.unlockSubAccountValidateBeforeCall(userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIlistSubAccountsRequest {
        private String type;

        private APIlistSubAccountsRequest() {
        }

        public APIlistSubAccountsRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubAccountApi.this.listSubAccountsCall(this.type, _callback);
        }

        public List<SubAccount> execute() throws ApiException {
            ApiResponse localVarResp = SubAccountApi.this.listSubAccountsWithHttpInfo(this.type);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SubAccount>> executeWithHttpInfo() throws ApiException {
            return SubAccountApi.this.listSubAccountsWithHttpInfo(this.type);
        }

        public Call executeAsync(ApiCallback<List<SubAccount>> _callback) throws ApiException {
            return SubAccountApi.this.listSubAccountsAsync(this.type, _callback);
        }
    }
}

