/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.AgencyCommissionHistory;
import io.gate.gateapi.models.AgencyTransactionHistory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class RebateApi {
    private ApiClient localVarApiClient;

    public RebateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RebateApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call agencyTransactionHistoryCall(String currencyPair, String userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/agency/transaction_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call agencyTransactionHistoryValidateBeforeCall(String currencyPair, String userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.agencyTransactionHistoryCall(currencyPair, userId, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<AgencyTransactionHistory>> agencyTransactionHistoryWithHttpInfo(String currencyPair, String userId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.agencyTransactionHistoryValidateBeforeCall(currencyPair, userId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<AgencyTransactionHistory>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call agencyTransactionHistoryAsync(String currencyPair, String userId, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<AgencyTransactionHistory>> _callback) throws ApiException {
        Call localVarCall = this.agencyTransactionHistoryValidateBeforeCall(currencyPair, userId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<AgencyTransactionHistory>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIagencyTransactionHistoryRequest agencyTransactionHistory() {
        return new APIagencyTransactionHistoryRequest();
    }

    private Call agencyCommissionsHistoryCall(String currency, String userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/agency/commission_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call agencyCommissionsHistoryValidateBeforeCall(String currency, String userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.agencyCommissionsHistoryCall(currency, userId, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<AgencyCommissionHistory>> agencyCommissionsHistoryWithHttpInfo(String currency, String userId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.agencyCommissionsHistoryValidateBeforeCall(currency, userId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<AgencyCommissionHistory>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call agencyCommissionsHistoryAsync(String currency, String userId, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<AgencyCommissionHistory>> _callback) throws ApiException {
        Call localVarCall = this.agencyCommissionsHistoryValidateBeforeCall(currency, userId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<AgencyCommissionHistory>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIagencyCommissionsHistoryRequest agencyCommissionsHistory() {
        return new APIagencyCommissionsHistoryRequest();
    }

    public class APIagencyCommissionsHistoryRequest {
        private String currency;
        private String userId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIagencyCommissionsHistoryRequest() {
        }

        public APIagencyCommissionsHistoryRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIagencyCommissionsHistoryRequest userId(String userId) {
            this.userId = userId;
            return this;
        }

        public APIagencyCommissionsHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIagencyCommissionsHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIagencyCommissionsHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIagencyCommissionsHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.agencyCommissionsHistoryCall(this.currency, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<AgencyCommissionHistory> execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.agencyCommissionsHistoryWithHttpInfo(this.currency, this.userId, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<AgencyCommissionHistory>> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.agencyCommissionsHistoryWithHttpInfo(this.currency, this.userId, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<AgencyCommissionHistory>> _callback) throws ApiException {
            return RebateApi.this.agencyCommissionsHistoryAsync(this.currency, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }
    }

    public class APIagencyTransactionHistoryRequest {
        private String currencyPair;
        private String userId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIagencyTransactionHistoryRequest() {
        }

        public APIagencyTransactionHistoryRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIagencyTransactionHistoryRequest userId(String userId) {
            this.userId = userId;
            return this;
        }

        public APIagencyTransactionHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIagencyTransactionHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIagencyTransactionHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIagencyTransactionHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.agencyTransactionHistoryCall(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<AgencyTransactionHistory> execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.agencyTransactionHistoryWithHttpInfo(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<AgencyTransactionHistory>> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.agencyTransactionHistoryWithHttpInfo(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<AgencyTransactionHistory>> _callback) throws ApiException {
            return RebateApi.this.agencyTransactionHistoryAsync(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }
    }
}

