/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.AutoRepaySetting;
import io.gate.gateapi.models.CrossMarginAccount;
import io.gate.gateapi.models.CrossMarginAccountBook;
import io.gate.gateapi.models.CrossMarginBorrowable;
import io.gate.gateapi.models.CrossMarginCurrency;
import io.gate.gateapi.models.CrossMarginLoan;
import io.gate.gateapi.models.CrossMarginRepayRequest;
import io.gate.gateapi.models.CrossMarginRepayment;
import io.gate.gateapi.models.CrossMarginTransferable;
import io.gate.gateapi.models.FundingAccount;
import io.gate.gateapi.models.FundingBookItem;
import io.gate.gateapi.models.Loan;
import io.gate.gateapi.models.LoanPatch;
import io.gate.gateapi.models.LoanRecord;
import io.gate.gateapi.models.MarginAccount;
import io.gate.gateapi.models.MarginAccountBook;
import io.gate.gateapi.models.MarginBorrowable;
import io.gate.gateapi.models.MarginCurrencyPair;
import io.gate.gateapi.models.MarginTransferable;
import io.gate.gateapi.models.RepayRequest;
import io.gate.gateapi.models.Repayment;
import io.gate.gateapi.models.UniLoanInterestRecord;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class MarginApi {
    private ApiClient localVarApiClient;

    public MarginApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MarginApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call listMarginAccountsCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMarginAccountsValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMarginAccountsCall(currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MarginAccount>> listMarginAccountsWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.listMarginAccountsValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<List<MarginAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMarginAccountsAsync(String currencyPair, ApiCallback<List<MarginAccount>> _callback) throws ApiException {
        Call localVarCall = this.listMarginAccountsValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<List<MarginAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMarginAccountsRequest listMarginAccounts() {
        return new APIlistMarginAccountsRequest();
    }

    private Call listMarginAccountBookCall(String currency, String currencyPair, Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/account_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMarginAccountBookValidateBeforeCall(String currency, String currencyPair, Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMarginAccountBookCall(currency, currencyPair, from, to, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MarginAccountBook>> listMarginAccountBookWithHttpInfo(String currency, String currencyPair, Long from, Long to, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listMarginAccountBookValidateBeforeCall(currency, currencyPair, from, to, page, limit, null);
        Type localVarReturnType = new TypeToken<List<MarginAccountBook>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMarginAccountBookAsync(String currency, String currencyPair, Long from, Long to, Integer page, Integer limit, ApiCallback<List<MarginAccountBook>> _callback) throws ApiException {
        Call localVarCall = this.listMarginAccountBookValidateBeforeCall(currency, currencyPair, from, to, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<MarginAccountBook>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMarginAccountBookRequest listMarginAccountBook() {
        return new APIlistMarginAccountBookRequest();
    }

    private Call listFundingAccountsCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/funding_accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFundingAccountsValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listFundingAccountsCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FundingAccount>> listFundingAccountsWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listFundingAccountsValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<FundingAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFundingAccountsAsync(String currency, ApiCallback<List<FundingAccount>> _callback) throws ApiException {
        Call localVarCall = this.listFundingAccountsValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<FundingAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFundingAccountsRequest listFundingAccounts() {
        return new APIlistFundingAccountsRequest();
    }

    public Call getAutoRepayStatusCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/auto_repay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAutoRepayStatusValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAutoRepayStatusCall(_callback);
        return localVarCall;
    }

    public AutoRepaySetting getAutoRepayStatus() throws ApiException {
        ApiResponse<AutoRepaySetting> localVarResp = this.getAutoRepayStatusWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<AutoRepaySetting> getAutoRepayStatusWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAutoRepayStatusValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAutoRepayStatusAsync(ApiCallback<AutoRepaySetting> _callback) throws ApiException {
        Call localVarCall = this.getAutoRepayStatusValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setAutoRepayCall(String status, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/auto_repay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setAutoRepayValidateBeforeCall(String status, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling setAutoRepay(Async)");
        }
        Call localVarCall = this.setAutoRepayCall(status, _callback);
        return localVarCall;
    }

    public AutoRepaySetting setAutoRepay(String status) throws ApiException {
        ApiResponse<AutoRepaySetting> localVarResp = this.setAutoRepayWithHttpInfo(status);
        return localVarResp.getData();
    }

    public ApiResponse<AutoRepaySetting> setAutoRepayWithHttpInfo(String status) throws ApiException {
        Call localVarCall = this.setAutoRepayValidateBeforeCall(status, null);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setAutoRepayAsync(String status, ApiCallback<AutoRepaySetting> _callback) throws ApiException {
        Call localVarCall = this.setAutoRepayValidateBeforeCall(status, _callback);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getMarginTransferableCall(String currency, String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/transferable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarginTransferableValidateBeforeCall(String currency, String currencyPair, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getMarginTransferable(Async)");
        }
        Call localVarCall = this.getMarginTransferableCall(currency, currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<MarginTransferable> getMarginTransferableWithHttpInfo(String currency, String currencyPair) throws ApiException {
        Call localVarCall = this.getMarginTransferableValidateBeforeCall(currency, currencyPair, null);
        Type localVarReturnType = new TypeToken<MarginTransferable>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMarginTransferableAsync(String currency, String currencyPair, ApiCallback<MarginTransferable> _callback) throws ApiException {
        Call localVarCall = this.getMarginTransferableValidateBeforeCall(currency, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MarginTransferable>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMarginTransferableRequest getMarginTransferable(String currency) {
        return new APIgetMarginTransferableRequest(currency);
    }

    public Call listMarginCurrencyPairsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/currency_pairs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMarginCurrencyPairsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMarginCurrencyPairsCall(_callback);
        return localVarCall;
    }

    public List<MarginCurrencyPair> listMarginCurrencyPairs() throws ApiException {
        ApiResponse<List<MarginCurrencyPair>> localVarResp = this.listMarginCurrencyPairsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<MarginCurrencyPair>> listMarginCurrencyPairsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listMarginCurrencyPairsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<MarginCurrencyPair>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listMarginCurrencyPairsAsync(ApiCallback<List<MarginCurrencyPair>> _callback) throws ApiException {
        Call localVarCall = this.listMarginCurrencyPairsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<MarginCurrencyPair>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarginCurrencyPairCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/currency_pairs/{currency_pair}".replaceAll("\\{currency_pair\\}", this.localVarApiClient.escapeString(currencyPair));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarginCurrencyPairValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getMarginCurrencyPair(Async)");
        }
        Call localVarCall = this.getMarginCurrencyPairCall(currencyPair, _callback);
        return localVarCall;
    }

    public MarginCurrencyPair getMarginCurrencyPair(String currencyPair) throws ApiException {
        ApiResponse<MarginCurrencyPair> localVarResp = this.getMarginCurrencyPairWithHttpInfo(currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<MarginCurrencyPair> getMarginCurrencyPairWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getMarginCurrencyPairValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<MarginCurrencyPair>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarginCurrencyPairAsync(String currencyPair, ApiCallback<MarginCurrencyPair> _callback) throws ApiException {
        Call localVarCall = this.getMarginCurrencyPairValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MarginCurrencyPair>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFundingBookCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/funding_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFundingBookValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling listFundingBook(Async)");
        }
        Call localVarCall = this.listFundingBookCall(currency, _callback);
        return localVarCall;
    }

    public List<FundingBookItem> listFundingBook(String currency) throws ApiException {
        ApiResponse<List<FundingBookItem>> localVarResp = this.listFundingBookWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<List<FundingBookItem>> listFundingBookWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listFundingBookValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<FundingBookItem>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFundingBookAsync(String currency, ApiCallback<List<FundingBookItem>> _callback) throws ApiException {
        Call localVarCall = this.listFundingBookValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<FundingBookItem>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listLoansCall(String status, String side, String currency, String currencyPair, String sortBy, Boolean reverseSort, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_by", sortBy));
        }
        if (reverseSort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reverse_sort", reverseSort));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listLoansValidateBeforeCall(String status, String side, String currency, String currencyPair, String sortBy, Boolean reverseSort, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listLoans(Async)");
        }
        if (side == null) {
            throw new ApiException("Missing the required parameter 'side' when calling listLoans(Async)");
        }
        Call localVarCall = this.listLoansCall(status, side, currency, currencyPair, sortBy, reverseSort, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Loan>> listLoansWithHttpInfo(String status, String side, String currency, String currencyPair, String sortBy, Boolean reverseSort, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listLoansValidateBeforeCall(status, side, currency, currencyPair, sortBy, reverseSort, page, limit, null);
        Type localVarReturnType = new TypeToken<List<Loan>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listLoansAsync(String status, String side, String currency, String currencyPair, String sortBy, Boolean reverseSort, Integer page, Integer limit, ApiCallback<List<Loan>> _callback) throws ApiException {
        Call localVarCall = this.listLoansValidateBeforeCall(status, side, currency, currencyPair, sortBy, reverseSort, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<Loan>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistLoansRequest listLoans(String status, String side) {
        return new APIlistLoansRequest(status, side);
    }

    public Call createLoanCall(Loan loan, ApiCallback _callback) throws ApiException {
        Loan localVarPostBody = loan;
        String localVarPath = "/margin/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createLoanValidateBeforeCall(Loan loan, ApiCallback _callback) throws ApiException {
        if (loan == null) {
            throw new ApiException("Missing the required parameter 'loan' when calling createLoan(Async)");
        }
        Call localVarCall = this.createLoanCall(loan, _callback);
        return localVarCall;
    }

    public Loan createLoan(Loan loan) throws ApiException {
        ApiResponse<Loan> localVarResp = this.createLoanWithHttpInfo(loan);
        return localVarResp.getData();
    }

    public ApiResponse<Loan> createLoanWithHttpInfo(Loan loan) throws ApiException {
        Call localVarCall = this.createLoanValidateBeforeCall(loan, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createLoanAsync(Loan loan, ApiCallback<Loan> _callback) throws ApiException {
        Call localVarCall = this.createLoanValidateBeforeCall(loan, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call mergeLoansCall(String currency, String ids, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/merged_loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (ids != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ids", ids));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call mergeLoansValidateBeforeCall(String currency, String ids, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling mergeLoans(Async)");
        }
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling mergeLoans(Async)");
        }
        Call localVarCall = this.mergeLoansCall(currency, ids, _callback);
        return localVarCall;
    }

    public Loan mergeLoans(String currency, String ids) throws ApiException {
        ApiResponse<Loan> localVarResp = this.mergeLoansWithHttpInfo(currency, ids);
        return localVarResp.getData();
    }

    public ApiResponse<Loan> mergeLoansWithHttpInfo(String currency, String ids) throws ApiException {
        Call localVarCall = this.mergeLoansValidateBeforeCall(currency, ids, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call mergeLoansAsync(String currency, String ids, ApiCallback<Loan> _callback) throws ApiException {
        Call localVarCall = this.mergeLoansValidateBeforeCall(currency, ids, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLoanCall(String loanId, String side, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/loans/{loan_id}".replaceAll("\\{loan_id\\}", this.localVarApiClient.escapeString(loanId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLoanValidateBeforeCall(String loanId, String side, ApiCallback _callback) throws ApiException {
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling getLoan(Async)");
        }
        if (side == null) {
            throw new ApiException("Missing the required parameter 'side' when calling getLoan(Async)");
        }
        Call localVarCall = this.getLoanCall(loanId, side, _callback);
        return localVarCall;
    }

    public Loan getLoan(String loanId, String side) throws ApiException {
        ApiResponse<Loan> localVarResp = this.getLoanWithHttpInfo(loanId, side);
        return localVarResp.getData();
    }

    public ApiResponse<Loan> getLoanWithHttpInfo(String loanId, String side) throws ApiException {
        Call localVarCall = this.getLoanValidateBeforeCall(loanId, side, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLoanAsync(String loanId, String side, ApiCallback<Loan> _callback) throws ApiException {
        Call localVarCall = this.getLoanValidateBeforeCall(loanId, side, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelLoanCall(String loanId, String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/loans/{loan_id}".replaceAll("\\{loan_id\\}", this.localVarApiClient.escapeString(loanId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelLoanValidateBeforeCall(String loanId, String currency, ApiCallback _callback) throws ApiException {
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling cancelLoan(Async)");
        }
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling cancelLoan(Async)");
        }
        Call localVarCall = this.cancelLoanCall(loanId, currency, _callback);
        return localVarCall;
    }

    public Loan cancelLoan(String loanId, String currency) throws ApiException {
        ApiResponse<Loan> localVarResp = this.cancelLoanWithHttpInfo(loanId, currency);
        return localVarResp.getData();
    }

    public ApiResponse<Loan> cancelLoanWithHttpInfo(String loanId, String currency) throws ApiException {
        Call localVarCall = this.cancelLoanValidateBeforeCall(loanId, currency, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelLoanAsync(String loanId, String currency, ApiCallback<Loan> _callback) throws ApiException {
        Call localVarCall = this.cancelLoanValidateBeforeCall(loanId, currency, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateLoanCall(String loanId, LoanPatch loanPatch, ApiCallback _callback) throws ApiException {
        LoanPatch localVarPostBody = loanPatch;
        String localVarPath = "/margin/loans/{loan_id}".replaceAll("\\{loan_id\\}", this.localVarApiClient.escapeString(loanId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateLoanValidateBeforeCall(String loanId, LoanPatch loanPatch, ApiCallback _callback) throws ApiException {
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling updateLoan(Async)");
        }
        if (loanPatch == null) {
            throw new ApiException("Missing the required parameter 'loanPatch' when calling updateLoan(Async)");
        }
        Call localVarCall = this.updateLoanCall(loanId, loanPatch, _callback);
        return localVarCall;
    }

    public Loan updateLoan(String loanId, LoanPatch loanPatch) throws ApiException {
        ApiResponse<Loan> localVarResp = this.updateLoanWithHttpInfo(loanId, loanPatch);
        return localVarResp.getData();
    }

    public ApiResponse<Loan> updateLoanWithHttpInfo(String loanId, LoanPatch loanPatch) throws ApiException {
        Call localVarCall = this.updateLoanValidateBeforeCall(loanId, loanPatch, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateLoanAsync(String loanId, LoanPatch loanPatch, ApiCallback<Loan> _callback) throws ApiException {
        Call localVarCall = this.updateLoanValidateBeforeCall(loanId, loanPatch, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listLoanRepaymentsCall(String loanId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/loans/{loan_id}/repayment".replaceAll("\\{loan_id\\}", this.localVarApiClient.escapeString(loanId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listLoanRepaymentsValidateBeforeCall(String loanId, ApiCallback _callback) throws ApiException {
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling listLoanRepayments(Async)");
        }
        Call localVarCall = this.listLoanRepaymentsCall(loanId, _callback);
        return localVarCall;
    }

    public List<Repayment> listLoanRepayments(String loanId) throws ApiException {
        ApiResponse<List<Repayment>> localVarResp = this.listLoanRepaymentsWithHttpInfo(loanId);
        return localVarResp.getData();
    }

    public ApiResponse<List<Repayment>> listLoanRepaymentsWithHttpInfo(String loanId) throws ApiException {
        Call localVarCall = this.listLoanRepaymentsValidateBeforeCall(loanId, null);
        Type localVarReturnType = new TypeToken<List<Repayment>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listLoanRepaymentsAsync(String loanId, ApiCallback<List<Repayment>> _callback) throws ApiException {
        Call localVarCall = this.listLoanRepaymentsValidateBeforeCall(loanId, _callback);
        Type localVarReturnType = new TypeToken<List<Repayment>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call repayLoanCall(String loanId, RepayRequest repayRequest, ApiCallback _callback) throws ApiException {
        RepayRequest localVarPostBody = repayRequest;
        String localVarPath = "/margin/loans/{loan_id}/repayment".replaceAll("\\{loan_id\\}", this.localVarApiClient.escapeString(loanId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call repayLoanValidateBeforeCall(String loanId, RepayRequest repayRequest, ApiCallback _callback) throws ApiException {
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling repayLoan(Async)");
        }
        if (repayRequest == null) {
            throw new ApiException("Missing the required parameter 'repayRequest' when calling repayLoan(Async)");
        }
        Call localVarCall = this.repayLoanCall(loanId, repayRequest, _callback);
        return localVarCall;
    }

    public Loan repayLoan(String loanId, RepayRequest repayRequest) throws ApiException {
        ApiResponse<Loan> localVarResp = this.repayLoanWithHttpInfo(loanId, repayRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Loan> repayLoanWithHttpInfo(String loanId, RepayRequest repayRequest) throws ApiException {
        Call localVarCall = this.repayLoanValidateBeforeCall(loanId, repayRequest, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call repayLoanAsync(String loanId, RepayRequest repayRequest, ApiCallback<Loan> _callback) throws ApiException {
        Call localVarCall = this.repayLoanValidateBeforeCall(loanId, repayRequest, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listLoanRecordsCall(String loanId, String status, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/loan_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (loanId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("loan_id", loanId));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listLoanRecordsValidateBeforeCall(String loanId, String status, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling listLoanRecords(Async)");
        }
        Call localVarCall = this.listLoanRecordsCall(loanId, status, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<LoanRecord>> listLoanRecordsWithHttpInfo(String loanId, String status, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listLoanRecordsValidateBeforeCall(loanId, status, page, limit, null);
        Type localVarReturnType = new TypeToken<List<LoanRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listLoanRecordsAsync(String loanId, String status, Integer page, Integer limit, ApiCallback<List<LoanRecord>> _callback) throws ApiException {
        Call localVarCall = this.listLoanRecordsValidateBeforeCall(loanId, status, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<LoanRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistLoanRecordsRequest listLoanRecords(String loanId) {
        return new APIlistLoanRecordsRequest(loanId);
    }

    public Call getLoanRecordCall(String loanRecordId, String loanId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/loan_records/{loan_record_id}".replaceAll("\\{loan_record_id\\}", this.localVarApiClient.escapeString(loanRecordId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (loanId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("loan_id", loanId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLoanRecordValidateBeforeCall(String loanRecordId, String loanId, ApiCallback _callback) throws ApiException {
        if (loanRecordId == null) {
            throw new ApiException("Missing the required parameter 'loanRecordId' when calling getLoanRecord(Async)");
        }
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling getLoanRecord(Async)");
        }
        Call localVarCall = this.getLoanRecordCall(loanRecordId, loanId, _callback);
        return localVarCall;
    }

    public LoanRecord getLoanRecord(String loanRecordId, String loanId) throws ApiException {
        ApiResponse<LoanRecord> localVarResp = this.getLoanRecordWithHttpInfo(loanRecordId, loanId);
        return localVarResp.getData();
    }

    public ApiResponse<LoanRecord> getLoanRecordWithHttpInfo(String loanRecordId, String loanId) throws ApiException {
        Call localVarCall = this.getLoanRecordValidateBeforeCall(loanRecordId, loanId, null);
        Type localVarReturnType = new TypeToken<LoanRecord>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLoanRecordAsync(String loanRecordId, String loanId, ApiCallback<LoanRecord> _callback) throws ApiException {
        Call localVarCall = this.getLoanRecordValidateBeforeCall(loanRecordId, loanId, _callback);
        Type localVarReturnType = new TypeToken<LoanRecord>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateLoanRecordCall(String loanRecordId, LoanPatch loanPatch, ApiCallback _callback) throws ApiException {
        LoanPatch localVarPostBody = loanPatch;
        String localVarPath = "/margin/loan_records/{loan_record_id}".replaceAll("\\{loan_record_id\\}", this.localVarApiClient.escapeString(loanRecordId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateLoanRecordValidateBeforeCall(String loanRecordId, LoanPatch loanPatch, ApiCallback _callback) throws ApiException {
        if (loanRecordId == null) {
            throw new ApiException("Missing the required parameter 'loanRecordId' when calling updateLoanRecord(Async)");
        }
        if (loanPatch == null) {
            throw new ApiException("Missing the required parameter 'loanPatch' when calling updateLoanRecord(Async)");
        }
        Call localVarCall = this.updateLoanRecordCall(loanRecordId, loanPatch, _callback);
        return localVarCall;
    }

    public LoanRecord updateLoanRecord(String loanRecordId, LoanPatch loanPatch) throws ApiException {
        ApiResponse<LoanRecord> localVarResp = this.updateLoanRecordWithHttpInfo(loanRecordId, loanPatch);
        return localVarResp.getData();
    }

    public ApiResponse<LoanRecord> updateLoanRecordWithHttpInfo(String loanRecordId, LoanPatch loanPatch) throws ApiException {
        Call localVarCall = this.updateLoanRecordValidateBeforeCall(loanRecordId, loanPatch, null);
        Type localVarReturnType = new TypeToken<LoanRecord>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateLoanRecordAsync(String loanRecordId, LoanPatch loanPatch, ApiCallback<LoanRecord> _callback) throws ApiException {
        Call localVarCall = this.updateLoanRecordValidateBeforeCall(loanRecordId, loanPatch, _callback);
        Type localVarReturnType = new TypeToken<LoanRecord>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getMarginBorrowableCall(String currency, String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/borrowable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarginBorrowableValidateBeforeCall(String currency, String currencyPair, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getMarginBorrowable(Async)");
        }
        Call localVarCall = this.getMarginBorrowableCall(currency, currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<MarginBorrowable> getMarginBorrowableWithHttpInfo(String currency, String currencyPair) throws ApiException {
        Call localVarCall = this.getMarginBorrowableValidateBeforeCall(currency, currencyPair, null);
        Type localVarReturnType = new TypeToken<MarginBorrowable>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMarginBorrowableAsync(String currency, String currencyPair, ApiCallback<MarginBorrowable> _callback) throws ApiException {
        Call localVarCall = this.getMarginBorrowableValidateBeforeCall(currency, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MarginBorrowable>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMarginBorrowableRequest getMarginBorrowable(String currency) {
        return new APIgetMarginBorrowableRequest(currency);
    }

    public Call listCrossMarginCurrenciesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCrossMarginCurrenciesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginCurrenciesCall(_callback);
        return localVarCall;
    }

    public List<CrossMarginCurrency> listCrossMarginCurrencies() throws ApiException {
        ApiResponse<List<CrossMarginCurrency>> localVarResp = this.listCrossMarginCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<CrossMarginCurrency>> listCrossMarginCurrenciesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCrossMarginCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<CrossMarginCurrency>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCrossMarginCurrenciesAsync(ApiCallback<List<CrossMarginCurrency>> _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginCurrency>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCrossMarginCurrencyCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/currencies/{currency}".replaceAll("\\{currency\\}", this.localVarApiClient.escapeString(currency));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCrossMarginCurrencyValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCrossMarginCurrency(Async)");
        }
        Call localVarCall = this.getCrossMarginCurrencyCall(currency, _callback);
        return localVarCall;
    }

    public CrossMarginCurrency getCrossMarginCurrency(String currency) throws ApiException {
        ApiResponse<CrossMarginCurrency> localVarResp = this.getCrossMarginCurrencyWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<CrossMarginCurrency> getCrossMarginCurrencyWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getCrossMarginCurrencyValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<CrossMarginCurrency>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCrossMarginCurrencyAsync(String currency, ApiCallback<CrossMarginCurrency> _callback) throws ApiException {
        Call localVarCall = this.getCrossMarginCurrencyValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginCurrency>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCrossMarginAccountCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCrossMarginAccountValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getCrossMarginAccountCall(_callback);
        return localVarCall;
    }

    public CrossMarginAccount getCrossMarginAccount() throws ApiException {
        ApiResponse<CrossMarginAccount> localVarResp = this.getCrossMarginAccountWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<CrossMarginAccount> getCrossMarginAccountWithHttpInfo() throws ApiException {
        Call localVarCall = this.getCrossMarginAccountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CrossMarginAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCrossMarginAccountAsync(ApiCallback<CrossMarginAccount> _callback) throws ApiException {
        Call localVarCall = this.getCrossMarginAccountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CrossMarginAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listCrossMarginAccountBookCall(String currency, Long from, Long to, Integer page, Integer limit, String type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/account_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCrossMarginAccountBookValidateBeforeCall(String currency, Long from, Long to, Integer page, Integer limit, String type, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginAccountBookCall(currency, from, to, page, limit, type, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CrossMarginAccountBook>> listCrossMarginAccountBookWithHttpInfo(String currency, Long from, Long to, Integer page, Integer limit, String type) throws ApiException {
        Call localVarCall = this.listCrossMarginAccountBookValidateBeforeCall(currency, from, to, page, limit, type, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginAccountBook>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCrossMarginAccountBookAsync(String currency, Long from, Long to, Integer page, Integer limit, String type, ApiCallback<List<CrossMarginAccountBook>> _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginAccountBookValidateBeforeCall(currency, from, to, page, limit, type, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginAccountBook>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCrossMarginAccountBookRequest listCrossMarginAccountBook() {
        return new APIlistCrossMarginAccountBookRequest();
    }

    private Call listCrossMarginLoansCall(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (reverse != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reverse", reverse));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCrossMarginLoansValidateBeforeCall(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listCrossMarginLoans(Async)");
        }
        Call localVarCall = this.listCrossMarginLoansCall(status, currency, limit, offset, reverse, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CrossMarginLoan>> listCrossMarginLoansWithHttpInfo(Integer status, String currency, Integer limit, Integer offset, Boolean reverse) throws ApiException {
        Call localVarCall = this.listCrossMarginLoansValidateBeforeCall(status, currency, limit, offset, reverse, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCrossMarginLoansAsync(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, ApiCallback<List<CrossMarginLoan>> _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginLoansValidateBeforeCall(status, currency, limit, offset, reverse, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCrossMarginLoansRequest listCrossMarginLoans(Integer status) {
        return new APIlistCrossMarginLoansRequest(status);
    }

    public Call createCrossMarginLoanCall(CrossMarginLoan crossMarginLoan, ApiCallback _callback) throws ApiException {
        CrossMarginLoan localVarPostBody = crossMarginLoan;
        String localVarPath = "/margin/cross/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCrossMarginLoanValidateBeforeCall(CrossMarginLoan crossMarginLoan, ApiCallback _callback) throws ApiException {
        if (crossMarginLoan == null) {
            throw new ApiException("Missing the required parameter 'crossMarginLoan' when calling createCrossMarginLoan(Async)");
        }
        Call localVarCall = this.createCrossMarginLoanCall(crossMarginLoan, _callback);
        return localVarCall;
    }

    public CrossMarginLoan createCrossMarginLoan(CrossMarginLoan crossMarginLoan) throws ApiException {
        ApiResponse<CrossMarginLoan> localVarResp = this.createCrossMarginLoanWithHttpInfo(crossMarginLoan);
        return localVarResp.getData();
    }

    public ApiResponse<CrossMarginLoan> createCrossMarginLoanWithHttpInfo(CrossMarginLoan crossMarginLoan) throws ApiException {
        Call localVarCall = this.createCrossMarginLoanValidateBeforeCall(crossMarginLoan, null);
        Type localVarReturnType = new TypeToken<CrossMarginLoan>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCrossMarginLoanAsync(CrossMarginLoan crossMarginLoan, ApiCallback<CrossMarginLoan> _callback) throws ApiException {
        Call localVarCall = this.createCrossMarginLoanValidateBeforeCall(crossMarginLoan, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginLoan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCrossMarginLoanCall(String loanId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/loans/{loan_id}".replaceAll("\\{loan_id\\}", this.localVarApiClient.escapeString(loanId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCrossMarginLoanValidateBeforeCall(String loanId, ApiCallback _callback) throws ApiException {
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling getCrossMarginLoan(Async)");
        }
        Call localVarCall = this.getCrossMarginLoanCall(loanId, _callback);
        return localVarCall;
    }

    public CrossMarginLoan getCrossMarginLoan(String loanId) throws ApiException {
        ApiResponse<CrossMarginLoan> localVarResp = this.getCrossMarginLoanWithHttpInfo(loanId);
        return localVarResp.getData();
    }

    public ApiResponse<CrossMarginLoan> getCrossMarginLoanWithHttpInfo(String loanId) throws ApiException {
        Call localVarCall = this.getCrossMarginLoanValidateBeforeCall(loanId, null);
        Type localVarReturnType = new TypeToken<CrossMarginLoan>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCrossMarginLoanAsync(String loanId, ApiCallback<CrossMarginLoan> _callback) throws ApiException {
        Call localVarCall = this.getCrossMarginLoanValidateBeforeCall(loanId, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginLoan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listCrossMarginRepaymentsCall(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/repayments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (loanId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("loan_id", loanId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (reverse != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reverse", reverse));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCrossMarginRepaymentsValidateBeforeCall(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginRepaymentsCall(currency, loanId, limit, offset, reverse, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CrossMarginRepayment>> listCrossMarginRepaymentsWithHttpInfo(String currency, String loanId, Integer limit, Integer offset, Boolean reverse) throws ApiException {
        Call localVarCall = this.listCrossMarginRepaymentsValidateBeforeCall(currency, loanId, limit, offset, reverse, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginRepayment>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCrossMarginRepaymentsAsync(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, ApiCallback<List<CrossMarginRepayment>> _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginRepaymentsValidateBeforeCall(currency, loanId, limit, offset, reverse, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginRepayment>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCrossMarginRepaymentsRequest listCrossMarginRepayments() {
        return new APIlistCrossMarginRepaymentsRequest();
    }

    public Call repayCrossMarginLoanCall(CrossMarginRepayRequest crossMarginRepayRequest, ApiCallback _callback) throws ApiException {
        CrossMarginRepayRequest localVarPostBody = crossMarginRepayRequest;
        String localVarPath = "/margin/cross/repayments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call repayCrossMarginLoanValidateBeforeCall(CrossMarginRepayRequest crossMarginRepayRequest, ApiCallback _callback) throws ApiException {
        if (crossMarginRepayRequest == null) {
            throw new ApiException("Missing the required parameter 'crossMarginRepayRequest' when calling repayCrossMarginLoan(Async)");
        }
        Call localVarCall = this.repayCrossMarginLoanCall(crossMarginRepayRequest, _callback);
        return localVarCall;
    }

    public List<CrossMarginLoan> repayCrossMarginLoan(CrossMarginRepayRequest crossMarginRepayRequest) throws ApiException {
        ApiResponse<List<CrossMarginLoan>> localVarResp = this.repayCrossMarginLoanWithHttpInfo(crossMarginRepayRequest);
        return localVarResp.getData();
    }

    public ApiResponse<List<CrossMarginLoan>> repayCrossMarginLoanWithHttpInfo(CrossMarginRepayRequest crossMarginRepayRequest) throws ApiException {
        Call localVarCall = this.repayCrossMarginLoanValidateBeforeCall(crossMarginRepayRequest, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call repayCrossMarginLoanAsync(CrossMarginRepayRequest crossMarginRepayRequest, ApiCallback<List<CrossMarginLoan>> _callback) throws ApiException {
        Call localVarCall = this.repayCrossMarginLoanValidateBeforeCall(crossMarginRepayRequest, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getCrossMarginInterestRecordsCall(String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/interest_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCrossMarginInterestRecordsValidateBeforeCall(String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getCrossMarginInterestRecordsCall(currency, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniLoanInterestRecord>> getCrossMarginInterestRecordsWithHttpInfo(String currency, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.getCrossMarginInterestRecordsValidateBeforeCall(currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCrossMarginInterestRecordsAsync(String currency, Integer page, Integer limit, ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
        Call localVarCall = this.getCrossMarginInterestRecordsValidateBeforeCall(currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetCrossMarginInterestRecordsRequest getCrossMarginInterestRecords() {
        return new APIgetCrossMarginInterestRecordsRequest();
    }

    public Call getCrossMarginTransferableCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/transferable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCrossMarginTransferableValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCrossMarginTransferable(Async)");
        }
        Call localVarCall = this.getCrossMarginTransferableCall(currency, _callback);
        return localVarCall;
    }

    public CrossMarginTransferable getCrossMarginTransferable(String currency) throws ApiException {
        ApiResponse<CrossMarginTransferable> localVarResp = this.getCrossMarginTransferableWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<CrossMarginTransferable> getCrossMarginTransferableWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getCrossMarginTransferableValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<CrossMarginTransferable>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCrossMarginTransferableAsync(String currency, ApiCallback<CrossMarginTransferable> _callback) throws ApiException {
        Call localVarCall = this.getCrossMarginTransferableValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginTransferable>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCrossMarginBorrowableCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/borrowable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCrossMarginBorrowableValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCrossMarginBorrowable(Async)");
        }
        Call localVarCall = this.getCrossMarginBorrowableCall(currency, _callback);
        return localVarCall;
    }

    public CrossMarginBorrowable getCrossMarginBorrowable(String currency) throws ApiException {
        ApiResponse<CrossMarginBorrowable> localVarResp = this.getCrossMarginBorrowableWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<CrossMarginBorrowable> getCrossMarginBorrowableWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getCrossMarginBorrowableValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<CrossMarginBorrowable>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCrossMarginBorrowableAsync(String currency, ApiCallback<CrossMarginBorrowable> _callback) throws ApiException {
        Call localVarCall = this.getCrossMarginBorrowableValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginBorrowable>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetCrossMarginInterestRecordsRequest {
        private String currency;
        private Integer page;
        private Integer limit;

        private APIgetCrossMarginInterestRecordsRequest() {
        }

        public APIgetCrossMarginInterestRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIgetCrossMarginInterestRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIgetCrossMarginInterestRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.getCrossMarginInterestRecordsCall(this.currency, this.page, this.limit, _callback);
        }

        public List<UniLoanInterestRecord> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.getCrossMarginInterestRecordsWithHttpInfo(this.currency, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniLoanInterestRecord>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.getCrossMarginInterestRecordsWithHttpInfo(this.currency, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
            return MarginApi.this.getCrossMarginInterestRecordsAsync(this.currency, this.page, this.limit, _callback);
        }
    }

    public class APIlistCrossMarginRepaymentsRequest {
        private String currency;
        private String loanId;
        private Integer limit;
        private Integer offset;
        private Boolean reverse;

        private APIlistCrossMarginRepaymentsRequest() {
        }

        public APIlistCrossMarginRepaymentsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistCrossMarginRepaymentsRequest loanId(String loanId) {
            this.loanId = loanId;
            return this;
        }

        public APIlistCrossMarginRepaymentsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCrossMarginRepaymentsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistCrossMarginRepaymentsRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listCrossMarginRepaymentsCall(this.currency, this.loanId, this.limit, this.offset, this.reverse, _callback);
        }

        public List<CrossMarginRepayment> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listCrossMarginRepaymentsWithHttpInfo(this.currency, this.loanId, this.limit, this.offset, this.reverse);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<CrossMarginRepayment>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listCrossMarginRepaymentsWithHttpInfo(this.currency, this.loanId, this.limit, this.offset, this.reverse);
        }

        public Call executeAsync(ApiCallback<List<CrossMarginRepayment>> _callback) throws ApiException {
            return MarginApi.this.listCrossMarginRepaymentsAsync(this.currency, this.loanId, this.limit, this.offset, this.reverse, _callback);
        }
    }

    public class APIlistCrossMarginLoansRequest {
        private final Integer status;
        private String currency;
        private Integer limit;
        private Integer offset;
        private Boolean reverse;

        private APIlistCrossMarginLoansRequest(Integer status) {
            this.status = status;
        }

        public APIlistCrossMarginLoansRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistCrossMarginLoansRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCrossMarginLoansRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistCrossMarginLoansRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listCrossMarginLoansCall(this.status, this.currency, this.limit, this.offset, this.reverse, _callback);
        }

        public List<CrossMarginLoan> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listCrossMarginLoansWithHttpInfo(this.status, this.currency, this.limit, this.offset, this.reverse);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<CrossMarginLoan>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listCrossMarginLoansWithHttpInfo(this.status, this.currency, this.limit, this.offset, this.reverse);
        }

        public Call executeAsync(ApiCallback<List<CrossMarginLoan>> _callback) throws ApiException {
            return MarginApi.this.listCrossMarginLoansAsync(this.status, this.currency, this.limit, this.offset, this.reverse, _callback);
        }
    }

    public class APIlistCrossMarginAccountBookRequest {
        private String currency;
        private Long from;
        private Long to;
        private Integer page;
        private Integer limit;
        private String type;

        private APIlistCrossMarginAccountBookRequest() {
        }

        public APIlistCrossMarginAccountBookRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistCrossMarginAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistCrossMarginAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistCrossMarginAccountBookRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistCrossMarginAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCrossMarginAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listCrossMarginAccountBookCall(this.currency, this.from, this.to, this.page, this.limit, this.type, _callback);
        }

        public List<CrossMarginAccountBook> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listCrossMarginAccountBookWithHttpInfo(this.currency, this.from, this.to, this.page, this.limit, this.type);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<CrossMarginAccountBook>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listCrossMarginAccountBookWithHttpInfo(this.currency, this.from, this.to, this.page, this.limit, this.type);
        }

        public Call executeAsync(ApiCallback<List<CrossMarginAccountBook>> _callback) throws ApiException {
            return MarginApi.this.listCrossMarginAccountBookAsync(this.currency, this.from, this.to, this.page, this.limit, this.type, _callback);
        }
    }

    public class APIgetMarginBorrowableRequest {
        private final String currency;
        private String currencyPair;

        private APIgetMarginBorrowableRequest(String currency) {
            this.currency = currency;
        }

        public APIgetMarginBorrowableRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.getMarginBorrowableCall(this.currency, this.currencyPair, _callback);
        }

        public MarginBorrowable execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.getMarginBorrowableWithHttpInfo(this.currency, this.currencyPair);
            return (MarginBorrowable)localVarResp.getData();
        }

        public ApiResponse<MarginBorrowable> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.getMarginBorrowableWithHttpInfo(this.currency, this.currencyPair);
        }

        public Call executeAsync(ApiCallback<MarginBorrowable> _callback) throws ApiException {
            return MarginApi.this.getMarginBorrowableAsync(this.currency, this.currencyPair, _callback);
        }
    }

    public class APIlistLoanRecordsRequest {
        private final String loanId;
        private String status;
        private Integer page;
        private Integer limit;

        private APIlistLoanRecordsRequest(String loanId) {
            this.loanId = loanId;
        }

        public APIlistLoanRecordsRequest status(String status) {
            this.status = status;
            return this;
        }

        public APIlistLoanRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistLoanRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listLoanRecordsCall(this.loanId, this.status, this.page, this.limit, _callback);
        }

        public List<LoanRecord> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listLoanRecordsWithHttpInfo(this.loanId, this.status, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<LoanRecord>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listLoanRecordsWithHttpInfo(this.loanId, this.status, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<LoanRecord>> _callback) throws ApiException {
            return MarginApi.this.listLoanRecordsAsync(this.loanId, this.status, this.page, this.limit, _callback);
        }
    }

    public class APIlistLoansRequest {
        private final String status;
        private final String side;
        private String currency;
        private String currencyPair;
        private String sortBy;
        private Boolean reverseSort;
        private Integer page;
        private Integer limit;

        private APIlistLoansRequest(String status, String side) {
            this.status = status;
            this.side = side;
        }

        public APIlistLoansRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistLoansRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIlistLoansRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistLoansRequest reverseSort(Boolean reverseSort) {
            this.reverseSort = reverseSort;
            return this;
        }

        public APIlistLoansRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistLoansRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listLoansCall(this.status, this.side, this.currency, this.currencyPair, this.sortBy, this.reverseSort, this.page, this.limit, _callback);
        }

        public List<Loan> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listLoansWithHttpInfo(this.status, this.side, this.currency, this.currencyPair, this.sortBy, this.reverseSort, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Loan>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listLoansWithHttpInfo(this.status, this.side, this.currency, this.currencyPair, this.sortBy, this.reverseSort, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<Loan>> _callback) throws ApiException {
            return MarginApi.this.listLoansAsync(this.status, this.side, this.currency, this.currencyPair, this.sortBy, this.reverseSort, this.page, this.limit, _callback);
        }
    }

    public class APIgetMarginTransferableRequest {
        private final String currency;
        private String currencyPair;

        private APIgetMarginTransferableRequest(String currency) {
            this.currency = currency;
        }

        public APIgetMarginTransferableRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.getMarginTransferableCall(this.currency, this.currencyPair, _callback);
        }

        public MarginTransferable execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.getMarginTransferableWithHttpInfo(this.currency, this.currencyPair);
            return (MarginTransferable)localVarResp.getData();
        }

        public ApiResponse<MarginTransferable> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.getMarginTransferableWithHttpInfo(this.currency, this.currencyPair);
        }

        public Call executeAsync(ApiCallback<MarginTransferable> _callback) throws ApiException {
            return MarginApi.this.getMarginTransferableAsync(this.currency, this.currencyPair, _callback);
        }
    }

    public class APIlistFundingAccountsRequest {
        private String currency;

        private APIlistFundingAccountsRequest() {
        }

        public APIlistFundingAccountsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listFundingAccountsCall(this.currency, _callback);
        }

        public List<FundingAccount> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listFundingAccountsWithHttpInfo(this.currency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FundingAccount>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listFundingAccountsWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<List<FundingAccount>> _callback) throws ApiException {
            return MarginApi.this.listFundingAccountsAsync(this.currency, _callback);
        }
    }

    public class APIlistMarginAccountBookRequest {
        private String currency;
        private String currencyPair;
        private Long from;
        private Long to;
        private Integer page;
        private Integer limit;

        private APIlistMarginAccountBookRequest() {
        }

        public APIlistMarginAccountBookRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistMarginAccountBookRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIlistMarginAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistMarginAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistMarginAccountBookRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistMarginAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listMarginAccountBookCall(this.currency, this.currencyPair, this.from, this.to, this.page, this.limit, _callback);
        }

        public List<MarginAccountBook> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listMarginAccountBookWithHttpInfo(this.currency, this.currencyPair, this.from, this.to, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MarginAccountBook>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listMarginAccountBookWithHttpInfo(this.currency, this.currencyPair, this.from, this.to, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<MarginAccountBook>> _callback) throws ApiException {
            return MarginApi.this.listMarginAccountBookAsync(this.currency, this.currencyPair, this.from, this.to, this.page, this.limit, _callback);
        }
    }

    public class APIlistMarginAccountsRequest {
        private String currencyPair;

        private APIlistMarginAccountsRequest() {
        }

        public APIlistMarginAccountsRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listMarginAccountsCall(this.currencyPair, _callback);
        }

        public List<MarginAccount> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listMarginAccountsWithHttpInfo(this.currencyPair);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MarginAccount>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listMarginAccountsWithHttpInfo(this.currencyPair);
        }

        public Call executeAsync(ApiCallback<List<MarginAccount>> _callback) throws ApiException {
            return MarginApi.this.listMarginAccountsAsync(this.currencyPair, _callback);
        }
    }
}

