/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.FlashSwapCurrency;
import io.gate.gateapi.models.FlashSwapOrder;
import io.gate.gateapi.models.FlashSwapOrderPreview;
import io.gate.gateapi.models.FlashSwapOrderRequest;
import io.gate.gateapi.models.FlashSwapPreviewRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class FlashSwapApi {
    private ApiClient localVarApiClient;

    public FlashSwapApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FlashSwapApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listFlashSwapCurrenciesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flash_swap/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlashSwapCurrenciesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listFlashSwapCurrenciesCall(_callback);
        return localVarCall;
    }

    public List<FlashSwapCurrency> listFlashSwapCurrencies() throws ApiException {
        ApiResponse<List<FlashSwapCurrency>> localVarResp = this.listFlashSwapCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<FlashSwapCurrency>> listFlashSwapCurrenciesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listFlashSwapCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<FlashSwapCurrency>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlashSwapCurrenciesAsync(ApiCallback<List<FlashSwapCurrency>> _callback) throws ApiException {
        Call localVarCall = this.listFlashSwapCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<FlashSwapCurrency>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listFlashSwapOrdersCall(Integer status, String sellCurrency, String buyCurrency, Boolean reverse, Integer limit, Integer page, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flash_swap/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (sellCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sell_currency", sellCurrency));
        }
        if (buyCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buy_currency", buyCurrency));
        }
        if (reverse != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reverse", reverse));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlashSwapOrdersValidateBeforeCall(Integer status, String sellCurrency, String buyCurrency, Boolean reverse, Integer limit, Integer page, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listFlashSwapOrdersCall(status, sellCurrency, buyCurrency, reverse, limit, page, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FlashSwapOrder>> listFlashSwapOrdersWithHttpInfo(Integer status, String sellCurrency, String buyCurrency, Boolean reverse, Integer limit, Integer page) throws ApiException {
        Call localVarCall = this.listFlashSwapOrdersValidateBeforeCall(status, sellCurrency, buyCurrency, reverse, limit, page, null);
        Type localVarReturnType = new TypeToken<List<FlashSwapOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFlashSwapOrdersAsync(Integer status, String sellCurrency, String buyCurrency, Boolean reverse, Integer limit, Integer page, ApiCallback<List<FlashSwapOrder>> _callback) throws ApiException {
        Call localVarCall = this.listFlashSwapOrdersValidateBeforeCall(status, sellCurrency, buyCurrency, reverse, limit, page, _callback);
        Type localVarReturnType = new TypeToken<List<FlashSwapOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFlashSwapOrdersRequest listFlashSwapOrders() {
        return new APIlistFlashSwapOrdersRequest();
    }

    public Call createFlashSwapOrderCall(FlashSwapOrderRequest flashSwapOrderRequest, ApiCallback _callback) throws ApiException {
        FlashSwapOrderRequest localVarPostBody = flashSwapOrderRequest;
        String localVarPath = "/flash_swap/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFlashSwapOrderValidateBeforeCall(FlashSwapOrderRequest flashSwapOrderRequest, ApiCallback _callback) throws ApiException {
        if (flashSwapOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'flashSwapOrderRequest' when calling createFlashSwapOrder(Async)");
        }
        Call localVarCall = this.createFlashSwapOrderCall(flashSwapOrderRequest, _callback);
        return localVarCall;
    }

    public FlashSwapOrder createFlashSwapOrder(FlashSwapOrderRequest flashSwapOrderRequest) throws ApiException {
        ApiResponse<FlashSwapOrder> localVarResp = this.createFlashSwapOrderWithHttpInfo(flashSwapOrderRequest);
        return localVarResp.getData();
    }

    public ApiResponse<FlashSwapOrder> createFlashSwapOrderWithHttpInfo(FlashSwapOrderRequest flashSwapOrderRequest) throws ApiException {
        Call localVarCall = this.createFlashSwapOrderValidateBeforeCall(flashSwapOrderRequest, null);
        Type localVarReturnType = new TypeToken<FlashSwapOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createFlashSwapOrderAsync(FlashSwapOrderRequest flashSwapOrderRequest, ApiCallback<FlashSwapOrder> _callback) throws ApiException {
        Call localVarCall = this.createFlashSwapOrderValidateBeforeCall(flashSwapOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<FlashSwapOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFlashSwapOrderCall(Integer orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flash_swap/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFlashSwapOrderValidateBeforeCall(Integer orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getFlashSwapOrder(Async)");
        }
        Call localVarCall = this.getFlashSwapOrderCall(orderId, _callback);
        return localVarCall;
    }

    public FlashSwapOrder getFlashSwapOrder(Integer orderId) throws ApiException {
        ApiResponse<FlashSwapOrder> localVarResp = this.getFlashSwapOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FlashSwapOrder> getFlashSwapOrderWithHttpInfo(Integer orderId) throws ApiException {
        Call localVarCall = this.getFlashSwapOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<FlashSwapOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFlashSwapOrderAsync(Integer orderId, ApiCallback<FlashSwapOrder> _callback) throws ApiException {
        Call localVarCall = this.getFlashSwapOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<FlashSwapOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call previewFlashSwapOrderCall(FlashSwapPreviewRequest flashSwapPreviewRequest, ApiCallback _callback) throws ApiException {
        FlashSwapPreviewRequest localVarPostBody = flashSwapPreviewRequest;
        String localVarPath = "/flash_swap/orders/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call previewFlashSwapOrderValidateBeforeCall(FlashSwapPreviewRequest flashSwapPreviewRequest, ApiCallback _callback) throws ApiException {
        if (flashSwapPreviewRequest == null) {
            throw new ApiException("Missing the required parameter 'flashSwapPreviewRequest' when calling previewFlashSwapOrder(Async)");
        }
        Call localVarCall = this.previewFlashSwapOrderCall(flashSwapPreviewRequest, _callback);
        return localVarCall;
    }

    public FlashSwapOrderPreview previewFlashSwapOrder(FlashSwapPreviewRequest flashSwapPreviewRequest) throws ApiException {
        ApiResponse<FlashSwapOrderPreview> localVarResp = this.previewFlashSwapOrderWithHttpInfo(flashSwapPreviewRequest);
        return localVarResp.getData();
    }

    public ApiResponse<FlashSwapOrderPreview> previewFlashSwapOrderWithHttpInfo(FlashSwapPreviewRequest flashSwapPreviewRequest) throws ApiException {
        Call localVarCall = this.previewFlashSwapOrderValidateBeforeCall(flashSwapPreviewRequest, null);
        Type localVarReturnType = new TypeToken<FlashSwapOrderPreview>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call previewFlashSwapOrderAsync(FlashSwapPreviewRequest flashSwapPreviewRequest, ApiCallback<FlashSwapOrderPreview> _callback) throws ApiException {
        Call localVarCall = this.previewFlashSwapOrderValidateBeforeCall(flashSwapPreviewRequest, _callback);
        Type localVarReturnType = new TypeToken<FlashSwapOrderPreview>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFlashSwapOrdersRequest {
        private Integer status;
        private String sellCurrency;
        private String buyCurrency;
        private Boolean reverse;
        private Integer limit;
        private Integer page;

        private APIlistFlashSwapOrdersRequest() {
        }

        public APIlistFlashSwapOrdersRequest status(Integer status) {
            this.status = status;
            return this;
        }

        public APIlistFlashSwapOrdersRequest sellCurrency(String sellCurrency) {
            this.sellCurrency = sellCurrency;
            return this;
        }

        public APIlistFlashSwapOrdersRequest buyCurrency(String buyCurrency) {
            this.buyCurrency = buyCurrency;
            return this;
        }

        public APIlistFlashSwapOrdersRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public APIlistFlashSwapOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistFlashSwapOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FlashSwapApi.this.listFlashSwapOrdersCall(this.status, this.sellCurrency, this.buyCurrency, this.reverse, this.limit, this.page, _callback);
        }

        public List<FlashSwapOrder> execute() throws ApiException {
            ApiResponse localVarResp = FlashSwapApi.this.listFlashSwapOrdersWithHttpInfo(this.status, this.sellCurrency, this.buyCurrency, this.reverse, this.limit, this.page);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FlashSwapOrder>> executeWithHttpInfo() throws ApiException {
            return FlashSwapApi.this.listFlashSwapOrdersWithHttpInfo(this.status, this.sellCurrency, this.buyCurrency, this.reverse, this.limit, this.page);
        }

        public Call executeAsync(ApiCallback<List<FlashSwapOrder>> _callback) throws ApiException {
            return FlashSwapApi.this.listFlashSwapOrdersAsync(this.status, this.sellCurrency, this.buyCurrency, this.reverse, this.limit, this.page, _callback);
        }
    }
}

