/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.CreateUniLend;
import io.gate.gateapi.models.PatchUniLend;
import io.gate.gateapi.models.UniCurrency;
import io.gate.gateapi.models.UniInterestRecord;
import io.gate.gateapi.models.UniLend;
import io.gate.gateapi.models.UniLendInterest;
import io.gate.gateapi.models.UniLendRecord;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class EarnUniApi {
    private ApiClient localVarApiClient;

    public EarnUniApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EarnUniApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listUniCurrenciesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/uni/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUniCurrenciesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUniCurrenciesCall(_callback);
        return localVarCall;
    }

    public List<UniCurrency> listUniCurrencies() throws ApiException {
        ApiResponse<List<UniCurrency>> localVarResp = this.listUniCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<UniCurrency>> listUniCurrenciesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listUniCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<UniCurrency>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUniCurrenciesAsync(ApiCallback<List<UniCurrency>> _callback) throws ApiException {
        Call localVarCall = this.listUniCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<UniCurrency>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniCurrencyCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/uni/currencies/{currency}".replaceAll("\\{currency\\}", this.localVarApiClient.escapeString(currency));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniCurrencyValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUniCurrency(Async)");
        }
        Call localVarCall = this.getUniCurrencyCall(currency, _callback);
        return localVarCall;
    }

    public UniCurrency getUniCurrency(String currency) throws ApiException {
        ApiResponse<UniCurrency> localVarResp = this.getUniCurrencyWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<UniCurrency> getUniCurrencyWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getUniCurrencyValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<UniCurrency>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniCurrencyAsync(String currency, ApiCallback<UniCurrency> _callback) throws ApiException {
        Call localVarCall = this.getUniCurrencyValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<UniCurrency>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listUserUniLendsCall(String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/uni/lends";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserUniLendsValidateBeforeCall(String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUserUniLendsCall(currency, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniLend>> listUserUniLendsWithHttpInfo(String currency, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listUserUniLendsValidateBeforeCall(currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLend>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUserUniLendsAsync(String currency, Integer page, Integer limit, ApiCallback<List<UniLend>> _callback) throws ApiException {
        Call localVarCall = this.listUserUniLendsValidateBeforeCall(currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLend>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserUniLendsRequest listUserUniLends() {
        return new APIlistUserUniLendsRequest();
    }

    public Call createUniLendCall(CreateUniLend createUniLend, ApiCallback _callback) throws ApiException {
        CreateUniLend localVarPostBody = createUniLend;
        String localVarPath = "/earn/uni/lends";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUniLendValidateBeforeCall(CreateUniLend createUniLend, ApiCallback _callback) throws ApiException {
        if (createUniLend == null) {
            throw new ApiException("Missing the required parameter 'createUniLend' when calling createUniLend(Async)");
        }
        Call localVarCall = this.createUniLendCall(createUniLend, _callback);
        return localVarCall;
    }

    public void createUniLend(CreateUniLend createUniLend) throws ApiException {
        this.createUniLendWithHttpInfo(createUniLend);
    }

    public ApiResponse<Void> createUniLendWithHttpInfo(CreateUniLend createUniLend) throws ApiException {
        Call localVarCall = this.createUniLendValidateBeforeCall(createUniLend, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createUniLendAsync(CreateUniLend createUniLend, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUniLendValidateBeforeCall(createUniLend, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call changeUniLendCall(PatchUniLend patchUniLend, ApiCallback _callback) throws ApiException {
        PatchUniLend localVarPostBody = patchUniLend;
        String localVarPath = "/earn/uni/lends";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call changeUniLendValidateBeforeCall(PatchUniLend patchUniLend, ApiCallback _callback) throws ApiException {
        if (patchUniLend == null) {
            throw new ApiException("Missing the required parameter 'patchUniLend' when calling changeUniLend(Async)");
        }
        Call localVarCall = this.changeUniLendCall(patchUniLend, _callback);
        return localVarCall;
    }

    public void changeUniLend(PatchUniLend patchUniLend) throws ApiException {
        this.changeUniLendWithHttpInfo(patchUniLend);
    }

    public ApiResponse<Void> changeUniLendWithHttpInfo(PatchUniLend patchUniLend) throws ApiException {
        Call localVarCall = this.changeUniLendValidateBeforeCall(patchUniLend, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call changeUniLendAsync(PatchUniLend patchUniLend, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.changeUniLendValidateBeforeCall(patchUniLend, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listUniLendRecordsCall(String currency, Integer page, Integer limit, String type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/uni/lend_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUniLendRecordsValidateBeforeCall(String currency, Integer page, Integer limit, String type, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUniLendRecordsCall(currency, page, limit, type, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniLendRecord>> listUniLendRecordsWithHttpInfo(String currency, Integer page, Integer limit, String type) throws ApiException {
        Call localVarCall = this.listUniLendRecordsValidateBeforeCall(currency, page, limit, type, null);
        Type localVarReturnType = new TypeToken<List<UniLendRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUniLendRecordsAsync(String currency, Integer page, Integer limit, String type, ApiCallback<List<UniLendRecord>> _callback) throws ApiException {
        Call localVarCall = this.listUniLendRecordsValidateBeforeCall(currency, page, limit, type, _callback);
        Type localVarReturnType = new TypeToken<List<UniLendRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUniLendRecordsRequest listUniLendRecords() {
        return new APIlistUniLendRecordsRequest();
    }

    public Call getUniInterestCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/uni/interests/{currency}".replaceAll("\\{currency\\}", this.localVarApiClient.escapeString(currency));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniInterestValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUniInterest(Async)");
        }
        Call localVarCall = this.getUniInterestCall(currency, _callback);
        return localVarCall;
    }

    public UniLendInterest getUniInterest(String currency) throws ApiException {
        ApiResponse<UniLendInterest> localVarResp = this.getUniInterestWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<UniLendInterest> getUniInterestWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getUniInterestValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<UniLendInterest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniInterestAsync(String currency, ApiCallback<UniLendInterest> _callback) throws ApiException {
        Call localVarCall = this.getUniInterestValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<UniLendInterest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listUniInterestRecordsCall(String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/uni/interest_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUniInterestRecordsValidateBeforeCall(String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUniInterestRecordsCall(currency, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniInterestRecord>> listUniInterestRecordsWithHttpInfo(String currency, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listUniInterestRecordsValidateBeforeCall(currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniInterestRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUniInterestRecordsAsync(String currency, Integer page, Integer limit, ApiCallback<List<UniInterestRecord>> _callback) throws ApiException {
        Call localVarCall = this.listUniInterestRecordsValidateBeforeCall(currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniInterestRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUniInterestRecordsRequest listUniInterestRecords() {
        return new APIlistUniInterestRecordsRequest();
    }

    public class APIlistUniInterestRecordsRequest {
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistUniInterestRecordsRequest() {
        }

        public APIlistUniInterestRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUniInterestRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUniInterestRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return EarnUniApi.this.listUniInterestRecordsCall(this.currency, this.page, this.limit, _callback);
        }

        public List<UniInterestRecord> execute() throws ApiException {
            ApiResponse localVarResp = EarnUniApi.this.listUniInterestRecordsWithHttpInfo(this.currency, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniInterestRecord>> executeWithHttpInfo() throws ApiException {
            return EarnUniApi.this.listUniInterestRecordsWithHttpInfo(this.currency, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<UniInterestRecord>> _callback) throws ApiException {
            return EarnUniApi.this.listUniInterestRecordsAsync(this.currency, this.page, this.limit, _callback);
        }
    }

    public class APIlistUniLendRecordsRequest {
        private String currency;
        private Integer page;
        private Integer limit;
        private String type;

        private APIlistUniLendRecordsRequest() {
        }

        public APIlistUniLendRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUniLendRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUniLendRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistUniLendRecordsRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return EarnUniApi.this.listUniLendRecordsCall(this.currency, this.page, this.limit, this.type, _callback);
        }

        public List<UniLendRecord> execute() throws ApiException {
            ApiResponse localVarResp = EarnUniApi.this.listUniLendRecordsWithHttpInfo(this.currency, this.page, this.limit, this.type);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniLendRecord>> executeWithHttpInfo() throws ApiException {
            return EarnUniApi.this.listUniLendRecordsWithHttpInfo(this.currency, this.page, this.limit, this.type);
        }

        public Call executeAsync(ApiCallback<List<UniLendRecord>> _callback) throws ApiException {
            return EarnUniApi.this.listUniLendRecordsAsync(this.currency, this.page, this.limit, this.type, _callback);
        }
    }

    public class APIlistUserUniLendsRequest {
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistUserUniLendsRequest() {
        }

        public APIlistUserUniLendsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUserUniLendsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUserUniLendsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return EarnUniApi.this.listUserUniLendsCall(this.currency, this.page, this.limit, _callback);
        }

        public List<UniLend> execute() throws ApiException {
            ApiResponse localVarResp = EarnUniApi.this.listUserUniLendsWithHttpInfo(this.currency, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniLend>> executeWithHttpInfo() throws ApiException {
            return EarnUniApi.this.listUserUniLendsWithHttpInfo(this.currency, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<UniLend>> _callback) throws ApiException {
            return EarnUniApi.this.listUserUniLendsAsync(this.currency, this.page, this.limit, _callback);
        }
    }
}

