/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * Interest Record
 */
public class UniLendRecord {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(SERIALIZED_NAME_CURRENCY)
    private String currency;

    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(SERIALIZED_NAME_AMOUNT)
    private String amount;

    public static final String SERIALIZED_NAME_LAST_WALLET_AMOUNT = "last_wallet_amount";
    @SerializedName(SERIALIZED_NAME_LAST_WALLET_AMOUNT)
    private String lastWalletAmount;

    public static final String SERIALIZED_NAME_LAST_LENT_AMOUNT = "last_lent_amount";
    @SerializedName(SERIALIZED_NAME_LAST_LENT_AMOUNT)
    private String lastLentAmount;

    public static final String SERIALIZED_NAME_LAST_FROZEN_AMOUNT = "last_frozen_amount";
    @SerializedName(SERIALIZED_NAME_LAST_FROZEN_AMOUNT)
    private String lastFrozenAmount;

    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(SERIALIZED_NAME_TYPE)
    private String type;

    public static final String SERIALIZED_NAME_CREATE_TIME = "create_time";
    @SerializedName(SERIALIZED_NAME_CREATE_TIME)
    private Long createTime;


     /**
     * Currency name
     * @return currency
    **/
    @javax.annotation.Nullable
    public String getCurrency() {
        return currency;
    }


     /**
     * current amount
     * @return amount
    **/
    @javax.annotation.Nullable
    public String getAmount() {
        return amount;
    }


     /**
     * Last wallet amount
     * @return lastWalletAmount
    **/
    @javax.annotation.Nullable
    public String getLastWalletAmount() {
        return lastWalletAmount;
    }


     /**
     * Last lent amount
     * @return lastLentAmount
    **/
    @javax.annotation.Nullable
    public String getLastLentAmount() {
        return lastLentAmount;
    }


     /**
     * Last frozen amount
     * @return lastFrozenAmount
    **/
    @javax.annotation.Nullable
    public String getLastFrozenAmount() {
        return lastFrozenAmount;
    }


     /**
     * Record type: lend - lend, redeem - redeem
     * @return type
    **/
    @javax.annotation.Nullable
    public String getType() {
        return type;
    }


     /**
     * Created time
     * @return createTime
    **/
    @javax.annotation.Nullable
    public Long getCreateTime() {
        return createTime;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UniLendRecord uniLendRecord = (UniLendRecord) o;
        return Objects.equals(this.currency, uniLendRecord.currency) &&
                Objects.equals(this.amount, uniLendRecord.amount) &&
                Objects.equals(this.lastWalletAmount, uniLendRecord.lastWalletAmount) &&
                Objects.equals(this.lastLentAmount, uniLendRecord.lastLentAmount) &&
                Objects.equals(this.lastFrozenAmount, uniLendRecord.lastFrozenAmount) &&
                Objects.equals(this.type, uniLendRecord.type) &&
                Objects.equals(this.createTime, uniLendRecord.createTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, amount, lastWalletAmount, lastLentAmount, lastFrozenAmount, type, createTime);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UniLendRecord {\n");
        sb.append("      currency: ").append(toIndentedString(currency)).append("\n");
        sb.append("      amount: ").append(toIndentedString(amount)).append("\n");
        sb.append("      lastWalletAmount: ").append(toIndentedString(lastWalletAmount)).append("\n");
        sb.append("      lastLentAmount: ").append(toIndentedString(lastLentAmount)).append("\n");
        sb.append("      lastFrozenAmount: ").append(toIndentedString(lastFrozenAmount)).append("\n");
        sb.append("      type: ").append(toIndentedString(type)).append("\n");
        sb.append("      createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

