/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * Loan record
 */
public class UniLend {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(SERIALIZED_NAME_CURRENCY)
    private String currency;

    public static final String SERIALIZED_NAME_CURRENT_AMOUNT = "current_amount";
    @SerializedName(SERIALIZED_NAME_CURRENT_AMOUNT)
    private String currentAmount;

    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(SERIALIZED_NAME_AMOUNT)
    private String amount;

    public static final String SERIALIZED_NAME_LENT_AMOUNT = "lent_amount";
    @SerializedName(SERIALIZED_NAME_LENT_AMOUNT)
    private String lentAmount;

    public static final String SERIALIZED_NAME_FROZEN_AMOUNT = "frozen_amount";
    @SerializedName(SERIALIZED_NAME_FROZEN_AMOUNT)
    private String frozenAmount;

    public static final String SERIALIZED_NAME_MIN_RATE = "min_rate";
    @SerializedName(SERIALIZED_NAME_MIN_RATE)
    private String minRate;

    public static final String SERIALIZED_NAME_CREATE_TIME = "create_time";
    @SerializedName(SERIALIZED_NAME_CREATE_TIME)
    private Long createTime;

    public static final String SERIALIZED_NAME_UPDATE_TIME = "update_time";
    @SerializedName(SERIALIZED_NAME_UPDATE_TIME)
    private Long updateTime;


     /**
     * Currency
     * @return currency
    **/
    @javax.annotation.Nullable
    public String getCurrency() {
        return currency;
    }


     /**
     * Current amount
     * @return currentAmount
    **/
    @javax.annotation.Nullable
    public String getCurrentAmount() {
        return currentAmount;
    }


     /**
     * Total amount
     * @return amount
    **/
    @javax.annotation.Nullable
    public String getAmount() {
        return amount;
    }


     /**
     * Lent amount
     * @return lentAmount
    **/
    @javax.annotation.Nullable
    public String getLentAmount() {
        return lentAmount;
    }


     /**
     * Frozen amount
     * @return frozenAmount
    **/
    @javax.annotation.Nullable
    public String getFrozenAmount() {
        return frozenAmount;
    }


     /**
     * Minimum interest rate
     * @return minRate
    **/
    @javax.annotation.Nullable
    public String getMinRate() {
        return minRate;
    }


     /**
     * Created time of the lending order
     * @return createTime
    **/
    @javax.annotation.Nullable
    public Long getCreateTime() {
        return createTime;
    }


     /**
     * Upated time of the lending order
     * @return updateTime
    **/
    @javax.annotation.Nullable
    public Long getUpdateTime() {
        return updateTime;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UniLend uniLend = (UniLend) o;
        return Objects.equals(this.currency, uniLend.currency) &&
                Objects.equals(this.currentAmount, uniLend.currentAmount) &&
                Objects.equals(this.amount, uniLend.amount) &&
                Objects.equals(this.lentAmount, uniLend.lentAmount) &&
                Objects.equals(this.frozenAmount, uniLend.frozenAmount) &&
                Objects.equals(this.minRate, uniLend.minRate) &&
                Objects.equals(this.createTime, uniLend.createTime) &&
                Objects.equals(this.updateTime, uniLend.updateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, currentAmount, amount, lentAmount, frozenAmount, minRate, createTime, updateTime);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UniLend {\n");
        sb.append("      currency: ").append(toIndentedString(currency)).append("\n");
        sb.append("      currentAmount: ").append(toIndentedString(currentAmount)).append("\n");
        sb.append("      amount: ").append(toIndentedString(amount)).append("\n");
        sb.append("      lentAmount: ").append(toIndentedString(lentAmount)).append("\n");
        sb.append("      frozenAmount: ").append(toIndentedString(frozenAmount)).append("\n");
        sb.append("      minRate: ").append(toIndentedString(minRate)).append("\n");
        sb.append("      createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("      updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

