/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * SubAccountTransfer
 */
public class SubAccountTransfer {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(SERIALIZED_NAME_CURRENCY)
    private String currency;

    public static final String SERIALIZED_NAME_SUB_ACCOUNT = "sub_account";
    @SerializedName(SERIALIZED_NAME_SUB_ACCOUNT)
    private String subAccount;

    /**
     * Transfer direction. to - transfer into sub account; from - transfer out from sub account
     */
    @JsonAdapter(DirectionEnum.Adapter.class)
    public enum DirectionEnum {
        TO("to"),
        
        FROM("from");

        private String value;

        DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter extends TypeAdapter<DirectionEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public DirectionEnum read(final JsonReader jsonReader) throws IOException {
                String value =  jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(SERIALIZED_NAME_DIRECTION)
    private DirectionEnum direction;

    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(SERIALIZED_NAME_AMOUNT)
    private String amount;

    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(SERIALIZED_NAME_UID)
    private String uid;

    public static final String SERIALIZED_NAME_TIMEST = "timest";
    @SerializedName(SERIALIZED_NAME_TIMEST)
    private String timest;

    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(SERIALIZED_NAME_SOURCE)
    private String source;

    /**
     * Target sub user&#39;s account. &#x60;spot&#x60; - spot account, &#x60;futures&#x60; - perpetual contract account, &#x60;cross_margin&#x60; - cross margin account, &#x60;delivery&#x60; - delivery account
     */
    @JsonAdapter(SubAccountTypeEnum.Adapter.class)
    public enum SubAccountTypeEnum {
        SPOT("spot"),
        
        FUTURES("futures"),
        
        CROSS_MARGIN("cross_margin"),
        
        DELIVERY("delivery");

        private String value;

        SubAccountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static SubAccountTypeEnum fromValue(String value) {
            for (SubAccountTypeEnum b : SubAccountTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter extends TypeAdapter<SubAccountTypeEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final SubAccountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public SubAccountTypeEnum read(final JsonReader jsonReader) throws IOException {
                String value =  jsonReader.nextString();
                return SubAccountTypeEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_SUB_ACCOUNT_TYPE = "sub_account_type";
    @SerializedName(SERIALIZED_NAME_SUB_ACCOUNT_TYPE)
    private SubAccountTypeEnum subAccountType = SubAccountTypeEnum.SPOT;


    public SubAccountTransfer currency(String currency) {
        
        this.currency = currency;
        return this;
    }

     /**
     * Transfer currency name
     * @return currency
    **/
    public String getCurrency() {
        return currency;
    }


    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SubAccountTransfer subAccount(String subAccount) {
        
        this.subAccount = subAccount;
        return this;
    }

     /**
     * Sub account user ID
     * @return subAccount
    **/
    public String getSubAccount() {
        return subAccount;
    }


    public void setSubAccount(String subAccount) {
        this.subAccount = subAccount;
    }

    public SubAccountTransfer direction(DirectionEnum direction) {
        
        this.direction = direction;
        return this;
    }

     /**
     * Transfer direction. to - transfer into sub account; from - transfer out from sub account
     * @return direction
    **/
    public DirectionEnum getDirection() {
        return direction;
    }


    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public SubAccountTransfer amount(String amount) {
        
        this.amount = amount;
        return this;
    }

     /**
     * Transfer amount
     * @return amount
    **/
    public String getAmount() {
        return amount;
    }


    public void setAmount(String amount) {
        this.amount = amount;
    }

     /**
     * Main account user ID
     * @return uid
    **/
    @javax.annotation.Nullable
    public String getUid() {
        return uid;
    }


     /**
     * Transfer timestamp
     * @return timest
    **/
    @javax.annotation.Nullable
    public String getTimest() {
        return timest;
    }


     /**
     * Where the operation is initiated from
     * @return source
    **/
    @javax.annotation.Nullable
    public String getSource() {
        return source;
    }


    public SubAccountTransfer subAccountType(SubAccountTypeEnum subAccountType) {
        
        this.subAccountType = subAccountType;
        return this;
    }

     /**
     * Target sub user&#39;s account. &#x60;spot&#x60; - spot account, &#x60;futures&#x60; - perpetual contract account, &#x60;cross_margin&#x60; - cross margin account, &#x60;delivery&#x60; - delivery account
     * @return subAccountType
    **/
    @javax.annotation.Nullable
    public SubAccountTypeEnum getSubAccountType() {
        return subAccountType;
    }


    public void setSubAccountType(SubAccountTypeEnum subAccountType) {
        this.subAccountType = subAccountType;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SubAccountTransfer subAccountTransfer = (SubAccountTransfer) o;
        return Objects.equals(this.currency, subAccountTransfer.currency) &&
                Objects.equals(this.subAccount, subAccountTransfer.subAccount) &&
                Objects.equals(this.direction, subAccountTransfer.direction) &&
                Objects.equals(this.amount, subAccountTransfer.amount) &&
                Objects.equals(this.uid, subAccountTransfer.uid) &&
                Objects.equals(this.timest, subAccountTransfer.timest) &&
                Objects.equals(this.source, subAccountTransfer.source) &&
                Objects.equals(this.subAccountType, subAccountTransfer.subAccountType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, subAccount, direction, amount, uid, timest, source, subAccountType);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubAccountTransfer {\n");
        sb.append("      currency: ").append(toIndentedString(currency)).append("\n");
        sb.append("      subAccount: ").append(toIndentedString(subAccount)).append("\n");
        sb.append("      direction: ").append(toIndentedString(direction)).append("\n");
        sb.append("      amount: ").append(toIndentedString(amount)).append("\n");
        sb.append("      uid: ").append(toIndentedString(uid)).append("\n");
        sb.append("      timest: ").append(toIndentedString(timest)).append("\n");
        sb.append("      source: ").append(toIndentedString(source)).append("\n");
        sb.append("      subAccountType: ").append(toIndentedString(subAccountType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

