/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * SubAccount
 */
public class SubAccount {
    public static final String SERIALIZED_NAME_REMARK = "remark";
    @SerializedName(SERIALIZED_NAME_REMARK)
    private String remark;

    public static final String SERIALIZED_NAME_LOGIN_NAME = "login_name";
    @SerializedName(SERIALIZED_NAME_LOGIN_NAME)
    private String loginName;

    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(SERIALIZED_NAME_PASSWORD)
    private String password;

    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(SERIALIZED_NAME_EMAIL)
    private String email;

    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(SERIALIZED_NAME_STATE)
    private Integer state;

    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(SERIALIZED_NAME_TYPE)
    private Integer type;

    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(SERIALIZED_NAME_USER_ID)
    private Long userId;

    public static final String SERIALIZED_NAME_CREATE_TIME = "create_time";
    @SerializedName(SERIALIZED_NAME_CREATE_TIME)
    private Long createTime;


    public SubAccount remark(String remark) {
        
        this.remark = remark;
        return this;
    }

     /**
     * custom text
     * @return remark
    **/
    @javax.annotation.Nullable
    public String getRemark() {
        return remark;
    }


    public void setRemark(String remark) {
        this.remark = remark;
    }

    public SubAccount loginName(String loginName) {
        
        this.loginName = loginName;
        return this;
    }

     /**
     * Sub-account login name: Only letters, numbers and underscores are supported, and cannot contain other illegal characters
     * @return loginName
    **/
    public String getLoginName() {
        return loginName;
    }


    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public SubAccount password(String password) {
        
        this.password = password;
        return this;
    }

     /**
     * The sub-account&#39;s password. (Default: the same as main account&#39;s password)
     * @return password
    **/
    @javax.annotation.Nullable
    public String getPassword() {
        return password;
    }


    public void setPassword(String password) {
        this.password = password;
    }

    public SubAccount email(String email) {
        
        this.email = email;
        return this;
    }

     /**
     * The sub-account&#39;s email address. (Default: the same as main account&#39;s email address)
     * @return email
    **/
    @javax.annotation.Nullable
    public String getEmail() {
        return email;
    }


    public void setEmail(String email) {
        this.email = email;
    }

     /**
     * State: 1-normal, 2-locked\&quot;
     * @return state
    **/
    @javax.annotation.Nullable
    public Integer getState() {
        return state;
    }


    public SubAccount type(Integer type) {
        
        this.type = type;
        return this;
    }

     /**
     * \&quot;Sub-account type: 1 - sub-account, 3 - cross margin account
     * @return type
    **/
    @javax.annotation.Nullable
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

     /**
     * The user id of the sub-account
     * @return userId
    **/
    @javax.annotation.Nullable
    public Long getUserId() {
        return userId;
    }


     /**
     * Created time
     * @return createTime
    **/
    @javax.annotation.Nullable
    public Long getCreateTime() {
        return createTime;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SubAccount subAccount = (SubAccount) o;
        return Objects.equals(this.remark, subAccount.remark) &&
                Objects.equals(this.loginName, subAccount.loginName) &&
                Objects.equals(this.password, subAccount.password) &&
                Objects.equals(this.email, subAccount.email) &&
                Objects.equals(this.state, subAccount.state) &&
                Objects.equals(this.type, subAccount.type) &&
                Objects.equals(this.userId, subAccount.userId) &&
                Objects.equals(this.createTime, subAccount.createTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(remark, loginName, password, email, state, type, userId, createTime);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubAccount {\n");
        sb.append("      remark: ").append(toIndentedString(remark)).append("\n");
        sb.append("      loginName: ").append(toIndentedString(loginName)).append("\n");
        sb.append("      password: ").append(toIndentedString(password)).append("\n");
        sb.append("      email: ").append(toIndentedString(email)).append("\n");
        sb.append("      state: ").append(toIndentedString(state)).append("\n");
        sb.append("      type: ").append(toIndentedString(type)).append("\n");
        sb.append("      userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("      createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

