/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * Options contract detail
 */
public class OptionsTicker {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(SERIALIZED_NAME_NAME)
    private String name;

    public static final String SERIALIZED_NAME_LAST_PRICE = "last_price";
    @SerializedName(SERIALIZED_NAME_LAST_PRICE)
    private String lastPrice;

    public static final String SERIALIZED_NAME_MARK_PRICE = "mark_price";
    @SerializedName(SERIALIZED_NAME_MARK_PRICE)
    private String markPrice;

    public static final String SERIALIZED_NAME_INDEX_PRICE = "index_price";
    @SerializedName(SERIALIZED_NAME_INDEX_PRICE)
    private String indexPrice;

    public static final String SERIALIZED_NAME_ASK1_SIZE = "ask1_size";
    @SerializedName(SERIALIZED_NAME_ASK1_SIZE)
    private Long ask1Size;

    public static final String SERIALIZED_NAME_ASK1_PRICE = "ask1_price";
    @SerializedName(SERIALIZED_NAME_ASK1_PRICE)
    private String ask1Price;

    public static final String SERIALIZED_NAME_BID1_SIZE = "bid1_size";
    @SerializedName(SERIALIZED_NAME_BID1_SIZE)
    private Long bid1Size;

    public static final String SERIALIZED_NAME_BID1_PRICE = "bid1_price";
    @SerializedName(SERIALIZED_NAME_BID1_PRICE)
    private String bid1Price;

    public static final String SERIALIZED_NAME_POSITION_SIZE = "position_size";
    @SerializedName(SERIALIZED_NAME_POSITION_SIZE)
    private Long positionSize;

    public static final String SERIALIZED_NAME_MARK_IV = "mark_iv";
    @SerializedName(SERIALIZED_NAME_MARK_IV)
    private String markIv;

    public static final String SERIALIZED_NAME_BID_IV = "bid_iv";
    @SerializedName(SERIALIZED_NAME_BID_IV)
    private String bidIv;

    public static final String SERIALIZED_NAME_ASK_IV = "ask_iv";
    @SerializedName(SERIALIZED_NAME_ASK_IV)
    private String askIv;

    public static final String SERIALIZED_NAME_LEVERAGE = "leverage";
    @SerializedName(SERIALIZED_NAME_LEVERAGE)
    private String leverage;

    public static final String SERIALIZED_NAME_DELTA = "delta";
    @SerializedName(SERIALIZED_NAME_DELTA)
    private String delta;

    public static final String SERIALIZED_NAME_GAMMA = "gamma";
    @SerializedName(SERIALIZED_NAME_GAMMA)
    private String gamma;

    public static final String SERIALIZED_NAME_VEGA = "vega";
    @SerializedName(SERIALIZED_NAME_VEGA)
    private String vega;

    public static final String SERIALIZED_NAME_THETA = "theta";
    @SerializedName(SERIALIZED_NAME_THETA)
    private String theta;

    public static final String SERIALIZED_NAME_RHO = "rho";
    @SerializedName(SERIALIZED_NAME_RHO)
    private String rho;


    public OptionsTicker name(String name) {
        
        this.name = name;
        return this;
    }

     /**
     * Options contract name
     * @return name
    **/
    @javax.annotation.Nullable
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    public OptionsTicker lastPrice(String lastPrice) {
        
        this.lastPrice = lastPrice;
        return this;
    }

     /**
     * Last trading price (quote currency)
     * @return lastPrice
    **/
    @javax.annotation.Nullable
    public String getLastPrice() {
        return lastPrice;
    }


    public void setLastPrice(String lastPrice) {
        this.lastPrice = lastPrice;
    }

    public OptionsTicker markPrice(String markPrice) {
        
        this.markPrice = markPrice;
        return this;
    }

     /**
     * Current mark price (quote currency)
     * @return markPrice
    **/
    @javax.annotation.Nullable
    public String getMarkPrice() {
        return markPrice;
    }


    public void setMarkPrice(String markPrice) {
        this.markPrice = markPrice;
    }

    public OptionsTicker indexPrice(String indexPrice) {
        
        this.indexPrice = indexPrice;
        return this;
    }

     /**
     * Current index price (quote currency)
     * @return indexPrice
    **/
    @javax.annotation.Nullable
    public String getIndexPrice() {
        return indexPrice;
    }


    public void setIndexPrice(String indexPrice) {
        this.indexPrice = indexPrice;
    }

    public OptionsTicker ask1Size(Long ask1Size) {
        
        this.ask1Size = ask1Size;
        return this;
    }

     /**
     * Best ask size
     * @return ask1Size
    **/
    @javax.annotation.Nullable
    public Long getAsk1Size() {
        return ask1Size;
    }


    public void setAsk1Size(Long ask1Size) {
        this.ask1Size = ask1Size;
    }

    public OptionsTicker ask1Price(String ask1Price) {
        
        this.ask1Price = ask1Price;
        return this;
    }

     /**
     * Best ask price
     * @return ask1Price
    **/
    @javax.annotation.Nullable
    public String getAsk1Price() {
        return ask1Price;
    }


    public void setAsk1Price(String ask1Price) {
        this.ask1Price = ask1Price;
    }

    public OptionsTicker bid1Size(Long bid1Size) {
        
        this.bid1Size = bid1Size;
        return this;
    }

     /**
     * Best bid size
     * @return bid1Size
    **/
    @javax.annotation.Nullable
    public Long getBid1Size() {
        return bid1Size;
    }


    public void setBid1Size(Long bid1Size) {
        this.bid1Size = bid1Size;
    }

    public OptionsTicker bid1Price(String bid1Price) {
        
        this.bid1Price = bid1Price;
        return this;
    }

     /**
     * Best bid price
     * @return bid1Price
    **/
    @javax.annotation.Nullable
    public String getBid1Price() {
        return bid1Price;
    }


    public void setBid1Price(String bid1Price) {
        this.bid1Price = bid1Price;
    }

    public OptionsTicker positionSize(Long positionSize) {
        
        this.positionSize = positionSize;
        return this;
    }

     /**
     * Current total long position size
     * @return positionSize
    **/
    @javax.annotation.Nullable
    public Long getPositionSize() {
        return positionSize;
    }


    public void setPositionSize(Long positionSize) {
        this.positionSize = positionSize;
    }

    public OptionsTicker markIv(String markIv) {
        
        this.markIv = markIv;
        return this;
    }

     /**
     * Implied volatility
     * @return markIv
    **/
    @javax.annotation.Nullable
    public String getMarkIv() {
        return markIv;
    }


    public void setMarkIv(String markIv) {
        this.markIv = markIv;
    }

    public OptionsTicker bidIv(String bidIv) {
        
        this.bidIv = bidIv;
        return this;
    }

     /**
     * Bid side implied volatility
     * @return bidIv
    **/
    @javax.annotation.Nullable
    public String getBidIv() {
        return bidIv;
    }


    public void setBidIv(String bidIv) {
        this.bidIv = bidIv;
    }

    public OptionsTicker askIv(String askIv) {
        
        this.askIv = askIv;
        return this;
    }

     /**
     * Ask side implied volatility
     * @return askIv
    **/
    @javax.annotation.Nullable
    public String getAskIv() {
        return askIv;
    }


    public void setAskIv(String askIv) {
        this.askIv = askIv;
    }

    public OptionsTicker leverage(String leverage) {
        
        this.leverage = leverage;
        return this;
    }

     /**
     * Current leverage. Formula: underlying_price / mark_price * delta
     * @return leverage
    **/
    @javax.annotation.Nullable
    public String getLeverage() {
        return leverage;
    }


    public void setLeverage(String leverage) {
        this.leverage = leverage;
    }

    public OptionsTicker delta(String delta) {
        
        this.delta = delta;
        return this;
    }

     /**
     * Delta
     * @return delta
    **/
    @javax.annotation.Nullable
    public String getDelta() {
        return delta;
    }


    public void setDelta(String delta) {
        this.delta = delta;
    }

    public OptionsTicker gamma(String gamma) {
        
        this.gamma = gamma;
        return this;
    }

     /**
     * Gamma
     * @return gamma
    **/
    @javax.annotation.Nullable
    public String getGamma() {
        return gamma;
    }


    public void setGamma(String gamma) {
        this.gamma = gamma;
    }

    public OptionsTicker vega(String vega) {
        
        this.vega = vega;
        return this;
    }

     /**
     * Vega
     * @return vega
    **/
    @javax.annotation.Nullable
    public String getVega() {
        return vega;
    }


    public void setVega(String vega) {
        this.vega = vega;
    }

    public OptionsTicker theta(String theta) {
        
        this.theta = theta;
        return this;
    }

     /**
     * Theta
     * @return theta
    **/
    @javax.annotation.Nullable
    public String getTheta() {
        return theta;
    }


    public void setTheta(String theta) {
        this.theta = theta;
    }

    public OptionsTicker rho(String rho) {
        
        this.rho = rho;
        return this;
    }

     /**
     * Rho
     * @return rho
    **/
    @javax.annotation.Nullable
    public String getRho() {
        return rho;
    }


    public void setRho(String rho) {
        this.rho = rho;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OptionsTicker optionsTicker = (OptionsTicker) o;
        return Objects.equals(this.name, optionsTicker.name) &&
                Objects.equals(this.lastPrice, optionsTicker.lastPrice) &&
                Objects.equals(this.markPrice, optionsTicker.markPrice) &&
                Objects.equals(this.indexPrice, optionsTicker.indexPrice) &&
                Objects.equals(this.ask1Size, optionsTicker.ask1Size) &&
                Objects.equals(this.ask1Price, optionsTicker.ask1Price) &&
                Objects.equals(this.bid1Size, optionsTicker.bid1Size) &&
                Objects.equals(this.bid1Price, optionsTicker.bid1Price) &&
                Objects.equals(this.positionSize, optionsTicker.positionSize) &&
                Objects.equals(this.markIv, optionsTicker.markIv) &&
                Objects.equals(this.bidIv, optionsTicker.bidIv) &&
                Objects.equals(this.askIv, optionsTicker.askIv) &&
                Objects.equals(this.leverage, optionsTicker.leverage) &&
                Objects.equals(this.delta, optionsTicker.delta) &&
                Objects.equals(this.gamma, optionsTicker.gamma) &&
                Objects.equals(this.vega, optionsTicker.vega) &&
                Objects.equals(this.theta, optionsTicker.theta) &&
                Objects.equals(this.rho, optionsTicker.rho);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, lastPrice, markPrice, indexPrice, ask1Size, ask1Price, bid1Size, bid1Price, positionSize, markIv, bidIv, askIv, leverage, delta, gamma, vega, theta, rho);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptionsTicker {\n");
        sb.append("      name: ").append(toIndentedString(name)).append("\n");
        sb.append("      lastPrice: ").append(toIndentedString(lastPrice)).append("\n");
        sb.append("      markPrice: ").append(toIndentedString(markPrice)).append("\n");
        sb.append("      indexPrice: ").append(toIndentedString(indexPrice)).append("\n");
        sb.append("      ask1Size: ").append(toIndentedString(ask1Size)).append("\n");
        sb.append("      ask1Price: ").append(toIndentedString(ask1Price)).append("\n");
        sb.append("      bid1Size: ").append(toIndentedString(bid1Size)).append("\n");
        sb.append("      bid1Price: ").append(toIndentedString(bid1Price)).append("\n");
        sb.append("      positionSize: ").append(toIndentedString(positionSize)).append("\n");
        sb.append("      markIv: ").append(toIndentedString(markIv)).append("\n");
        sb.append("      bidIv: ").append(toIndentedString(bidIv)).append("\n");
        sb.append("      askIv: ").append(toIndentedString(askIv)).append("\n");
        sb.append("      leverage: ").append(toIndentedString(leverage)).append("\n");
        sb.append("      delta: ").append(toIndentedString(delta)).append("\n");
        sb.append("      gamma: ").append(toIndentedString(gamma)).append("\n");
        sb.append("      vega: ").append(toIndentedString(vega)).append("\n");
        sb.append("      theta: ").append(toIndentedString(theta)).append("\n");
        sb.append("      rho: ").append(toIndentedString(rho)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

