/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * OptionsMyTrade
 */
public class OptionsMyTrade {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(SERIALIZED_NAME_ID)
    private Long id;

    public static final String SERIALIZED_NAME_CREATE_TIME = "create_time";
    @SerializedName(SERIALIZED_NAME_CREATE_TIME)
    private Double createTime;

    public static final String SERIALIZED_NAME_CONTRACT = "contract";
    @SerializedName(SERIALIZED_NAME_CONTRACT)
    private String contract;

    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(SERIALIZED_NAME_ORDER_ID)
    private Integer orderId;

    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(SERIALIZED_NAME_SIZE)
    private Long size;

    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(SERIALIZED_NAME_PRICE)
    private String price;

    public static final String SERIALIZED_NAME_UNDERLYING_PRICE = "underlying_price";
    @SerializedName(SERIALIZED_NAME_UNDERLYING_PRICE)
    private String underlyingPrice;

    /**
     * Trade role. Available values are &#x60;taker&#x60; and &#x60;maker&#x60;
     */
    @JsonAdapter(RoleEnum.Adapter.class)
    public enum RoleEnum {
        TAKER("taker"),
        
        MAKER("maker");

        private String value;

        RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter extends TypeAdapter<RoleEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public RoleEnum read(final JsonReader jsonReader) throws IOException {
                String value =  jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(SERIALIZED_NAME_ROLE)
    private RoleEnum role;


    public OptionsMyTrade id(Long id) {
        
        this.id = id;
        return this;
    }

     /**
     * Trade ID
     * @return id
    **/
    @javax.annotation.Nullable
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    public OptionsMyTrade createTime(Double createTime) {
        
        this.createTime = createTime;
        return this;
    }

     /**
     * Trading time
     * @return createTime
    **/
    @javax.annotation.Nullable
    public Double getCreateTime() {
        return createTime;
    }


    public void setCreateTime(Double createTime) {
        this.createTime = createTime;
    }

    public OptionsMyTrade contract(String contract) {
        
        this.contract = contract;
        return this;
    }

     /**
     * Options contract name
     * @return contract
    **/
    @javax.annotation.Nullable
    public String getContract() {
        return contract;
    }


    public void setContract(String contract) {
        this.contract = contract;
    }

    public OptionsMyTrade orderId(Integer orderId) {
        
        this.orderId = orderId;
        return this;
    }

     /**
     * Order ID related
     * @return orderId
    **/
    @javax.annotation.Nullable
    public Integer getOrderId() {
        return orderId;
    }


    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public OptionsMyTrade size(Long size) {
        
        this.size = size;
        return this;
    }

     /**
     * Trading size
     * @return size
    **/
    @javax.annotation.Nullable
    public Long getSize() {
        return size;
    }


    public void setSize(Long size) {
        this.size = size;
    }

    public OptionsMyTrade price(String price) {
        
        this.price = price;
        return this;
    }

     /**
     * Trading price (quote currency)
     * @return price
    **/
    @javax.annotation.Nullable
    public String getPrice() {
        return price;
    }


    public void setPrice(String price) {
        this.price = price;
    }

    public OptionsMyTrade underlyingPrice(String underlyingPrice) {
        
        this.underlyingPrice = underlyingPrice;
        return this;
    }

     /**
     * Underlying price (quote currency)
     * @return underlyingPrice
    **/
    @javax.annotation.Nullable
    public String getUnderlyingPrice() {
        return underlyingPrice;
    }


    public void setUnderlyingPrice(String underlyingPrice) {
        this.underlyingPrice = underlyingPrice;
    }

    public OptionsMyTrade role(RoleEnum role) {
        
        this.role = role;
        return this;
    }

     /**
     * Trade role. Available values are &#x60;taker&#x60; and &#x60;maker&#x60;
     * @return role
    **/
    @javax.annotation.Nullable
    public RoleEnum getRole() {
        return role;
    }


    public void setRole(RoleEnum role) {
        this.role = role;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OptionsMyTrade optionsMyTrade = (OptionsMyTrade) o;
        return Objects.equals(this.id, optionsMyTrade.id) &&
                Objects.equals(this.createTime, optionsMyTrade.createTime) &&
                Objects.equals(this.contract, optionsMyTrade.contract) &&
                Objects.equals(this.orderId, optionsMyTrade.orderId) &&
                Objects.equals(this.size, optionsMyTrade.size) &&
                Objects.equals(this.price, optionsMyTrade.price) &&
                Objects.equals(this.underlyingPrice, optionsMyTrade.underlyingPrice) &&
                Objects.equals(this.role, optionsMyTrade.role);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, createTime, contract, orderId, size, price, underlyingPrice, role);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptionsMyTrade {\n");
        sb.append("      id: ").append(toIndentedString(id)).append("\n");
        sb.append("      createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("      contract: ").append(toIndentedString(contract)).append("\n");
        sb.append("      orderId: ").append(toIndentedString(orderId)).append("\n");
        sb.append("      size: ").append(toIndentedString(size)).append("\n");
        sb.append("      price: ").append(toIndentedString(price)).append("\n");
        sb.append("      underlyingPrice: ").append(toIndentedString(underlyingPrice)).append("\n");
        sb.append("      role: ").append(toIndentedString(role)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

