/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * Options contract detail
 */
public class OptionsContract {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(SERIALIZED_NAME_NAME)
    private String name;

    public static final String SERIALIZED_NAME_TAG = "tag";
    @SerializedName(SERIALIZED_NAME_TAG)
    private String tag;

    public static final String SERIALIZED_NAME_CREATE_TIME = "create_time";
    @SerializedName(SERIALIZED_NAME_CREATE_TIME)
    private Double createTime;

    public static final String SERIALIZED_NAME_EXPIRATION_TIME = "expiration_time";
    @SerializedName(SERIALIZED_NAME_EXPIRATION_TIME)
    private Double expirationTime;

    public static final String SERIALIZED_NAME_IS_CALL = "is_call";
    @SerializedName(SERIALIZED_NAME_IS_CALL)
    private Boolean isCall;

    public static final String SERIALIZED_NAME_MULTIPLIER = "multiplier";
    @SerializedName(SERIALIZED_NAME_MULTIPLIER)
    private String multiplier;

    public static final String SERIALIZED_NAME_UNDERLYING = "underlying";
    @SerializedName(SERIALIZED_NAME_UNDERLYING)
    private String underlying;

    public static final String SERIALIZED_NAME_UNDERLYING_PRICE = "underlying_price";
    @SerializedName(SERIALIZED_NAME_UNDERLYING_PRICE)
    private String underlyingPrice;

    public static final String SERIALIZED_NAME_LAST_PRICE = "last_price";
    @SerializedName(SERIALIZED_NAME_LAST_PRICE)
    private String lastPrice;

    public static final String SERIALIZED_NAME_MARK_PRICE = "mark_price";
    @SerializedName(SERIALIZED_NAME_MARK_PRICE)
    private String markPrice;

    public static final String SERIALIZED_NAME_INDEX_PRICE = "index_price";
    @SerializedName(SERIALIZED_NAME_INDEX_PRICE)
    private String indexPrice;

    public static final String SERIALIZED_NAME_MAKER_FEE_RATE = "maker_fee_rate";
    @SerializedName(SERIALIZED_NAME_MAKER_FEE_RATE)
    private String makerFeeRate;

    public static final String SERIALIZED_NAME_TAKER_FEE_RATE = "taker_fee_rate";
    @SerializedName(SERIALIZED_NAME_TAKER_FEE_RATE)
    private String takerFeeRate;

    public static final String SERIALIZED_NAME_ORDER_PRICE_ROUND = "order_price_round";
    @SerializedName(SERIALIZED_NAME_ORDER_PRICE_ROUND)
    private String orderPriceRound;

    public static final String SERIALIZED_NAME_MARK_PRICE_ROUND = "mark_price_round";
    @SerializedName(SERIALIZED_NAME_MARK_PRICE_ROUND)
    private String markPriceRound;

    public static final String SERIALIZED_NAME_ORDER_SIZE_MIN = "order_size_min";
    @SerializedName(SERIALIZED_NAME_ORDER_SIZE_MIN)
    private Long orderSizeMin;

    public static final String SERIALIZED_NAME_ORDER_SIZE_MAX = "order_size_max";
    @SerializedName(SERIALIZED_NAME_ORDER_SIZE_MAX)
    private Long orderSizeMax;

    public static final String SERIALIZED_NAME_ORDER_PRICE_DEVIATE = "order_price_deviate";
    @SerializedName(SERIALIZED_NAME_ORDER_PRICE_DEVIATE)
    private String orderPriceDeviate;

    public static final String SERIALIZED_NAME_REF_DISCOUNT_RATE = "ref_discount_rate";
    @SerializedName(SERIALIZED_NAME_REF_DISCOUNT_RATE)
    private String refDiscountRate;

    public static final String SERIALIZED_NAME_REF_REBATE_RATE = "ref_rebate_rate";
    @SerializedName(SERIALIZED_NAME_REF_REBATE_RATE)
    private String refRebateRate;

    public static final String SERIALIZED_NAME_ORDERBOOK_ID = "orderbook_id";
    @SerializedName(SERIALIZED_NAME_ORDERBOOK_ID)
    private Long orderbookId;

    public static final String SERIALIZED_NAME_TRADE_ID = "trade_id";
    @SerializedName(SERIALIZED_NAME_TRADE_ID)
    private Long tradeId;

    public static final String SERIALIZED_NAME_TRADE_SIZE = "trade_size";
    @SerializedName(SERIALIZED_NAME_TRADE_SIZE)
    private Long tradeSize;

    public static final String SERIALIZED_NAME_POSITION_SIZE = "position_size";
    @SerializedName(SERIALIZED_NAME_POSITION_SIZE)
    private Long positionSize;

    public static final String SERIALIZED_NAME_ORDERS_LIMIT = "orders_limit";
    @SerializedName(SERIALIZED_NAME_ORDERS_LIMIT)
    private Integer ordersLimit;


    public OptionsContract name(String name) {
        
        this.name = name;
        return this;
    }

     /**
     * Options contract name
     * @return name
    **/
    @javax.annotation.Nullable
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    public OptionsContract tag(String tag) {
        
        this.tag = tag;
        return this;
    }

     /**
     * tag
     * @return tag
    **/
    @javax.annotation.Nullable
    public String getTag() {
        return tag;
    }


    public void setTag(String tag) {
        this.tag = tag;
    }

    public OptionsContract createTime(Double createTime) {
        
        this.createTime = createTime;
        return this;
    }

     /**
     * Creation time
     * @return createTime
    **/
    @javax.annotation.Nullable
    public Double getCreateTime() {
        return createTime;
    }


    public void setCreateTime(Double createTime) {
        this.createTime = createTime;
    }

    public OptionsContract expirationTime(Double expirationTime) {
        
        this.expirationTime = expirationTime;
        return this;
    }

     /**
     * Expiration time
     * @return expirationTime
    **/
    @javax.annotation.Nullable
    public Double getExpirationTime() {
        return expirationTime;
    }


    public void setExpirationTime(Double expirationTime) {
        this.expirationTime = expirationTime;
    }

    public OptionsContract isCall(Boolean isCall) {
        
        this.isCall = isCall;
        return this;
    }

     /**
     * &#x60;true&#x60; means call options, while &#x60;false&#x60; is put options
     * @return isCall
    **/
    @javax.annotation.Nullable
    public Boolean getIsCall() {
        return isCall;
    }


    public void setIsCall(Boolean isCall) {
        this.isCall = isCall;
    }

    public OptionsContract multiplier(String multiplier) {
        
        this.multiplier = multiplier;
        return this;
    }

     /**
     * Multiplier used in converting from invoicing to settlement currency
     * @return multiplier
    **/
    @javax.annotation.Nullable
    public String getMultiplier() {
        return multiplier;
    }


    public void setMultiplier(String multiplier) {
        this.multiplier = multiplier;
    }

    public OptionsContract underlying(String underlying) {
        
        this.underlying = underlying;
        return this;
    }

     /**
     * Underlying
     * @return underlying
    **/
    @javax.annotation.Nullable
    public String getUnderlying() {
        return underlying;
    }


    public void setUnderlying(String underlying) {
        this.underlying = underlying;
    }

    public OptionsContract underlyingPrice(String underlyingPrice) {
        
        this.underlyingPrice = underlyingPrice;
        return this;
    }

     /**
     * Underlying price (quote currency)
     * @return underlyingPrice
    **/
    @javax.annotation.Nullable
    public String getUnderlyingPrice() {
        return underlyingPrice;
    }


    public void setUnderlyingPrice(String underlyingPrice) {
        this.underlyingPrice = underlyingPrice;
    }

    public OptionsContract lastPrice(String lastPrice) {
        
        this.lastPrice = lastPrice;
        return this;
    }

     /**
     * Last trading price
     * @return lastPrice
    **/
    @javax.annotation.Nullable
    public String getLastPrice() {
        return lastPrice;
    }


    public void setLastPrice(String lastPrice) {
        this.lastPrice = lastPrice;
    }

    public OptionsContract markPrice(String markPrice) {
        
        this.markPrice = markPrice;
        return this;
    }

     /**
     * Current mark price (quote currency)
     * @return markPrice
    **/
    @javax.annotation.Nullable
    public String getMarkPrice() {
        return markPrice;
    }


    public void setMarkPrice(String markPrice) {
        this.markPrice = markPrice;
    }

    public OptionsContract indexPrice(String indexPrice) {
        
        this.indexPrice = indexPrice;
        return this;
    }

     /**
     * Current index price (quote currency)
     * @return indexPrice
    **/
    @javax.annotation.Nullable
    public String getIndexPrice() {
        return indexPrice;
    }


    public void setIndexPrice(String indexPrice) {
        this.indexPrice = indexPrice;
    }

    public OptionsContract makerFeeRate(String makerFeeRate) {
        
        this.makerFeeRate = makerFeeRate;
        return this;
    }

     /**
     * Maker fee rate, where negative means rebate
     * @return makerFeeRate
    **/
    @javax.annotation.Nullable
    public String getMakerFeeRate() {
        return makerFeeRate;
    }


    public void setMakerFeeRate(String makerFeeRate) {
        this.makerFeeRate = makerFeeRate;
    }

    public OptionsContract takerFeeRate(String takerFeeRate) {
        
        this.takerFeeRate = takerFeeRate;
        return this;
    }

     /**
     * Taker fee rate
     * @return takerFeeRate
    **/
    @javax.annotation.Nullable
    public String getTakerFeeRate() {
        return takerFeeRate;
    }


    public void setTakerFeeRate(String takerFeeRate) {
        this.takerFeeRate = takerFeeRate;
    }

    public OptionsContract orderPriceRound(String orderPriceRound) {
        
        this.orderPriceRound = orderPriceRound;
        return this;
    }

     /**
     * Minimum order price increment
     * @return orderPriceRound
    **/
    @javax.annotation.Nullable
    public String getOrderPriceRound() {
        return orderPriceRound;
    }


    public void setOrderPriceRound(String orderPriceRound) {
        this.orderPriceRound = orderPriceRound;
    }

    public OptionsContract markPriceRound(String markPriceRound) {
        
        this.markPriceRound = markPriceRound;
        return this;
    }

     /**
     * Minimum mark price increment
     * @return markPriceRound
    **/
    @javax.annotation.Nullable
    public String getMarkPriceRound() {
        return markPriceRound;
    }


    public void setMarkPriceRound(String markPriceRound) {
        this.markPriceRound = markPriceRound;
    }

    public OptionsContract orderSizeMin(Long orderSizeMin) {
        
        this.orderSizeMin = orderSizeMin;
        return this;
    }

     /**
     * Minimum order size the contract allowed
     * @return orderSizeMin
    **/
    @javax.annotation.Nullable
    public Long getOrderSizeMin() {
        return orderSizeMin;
    }


    public void setOrderSizeMin(Long orderSizeMin) {
        this.orderSizeMin = orderSizeMin;
    }

    public OptionsContract orderSizeMax(Long orderSizeMax) {
        
        this.orderSizeMax = orderSizeMax;
        return this;
    }

     /**
     * Maximum order size the contract allowed
     * @return orderSizeMax
    **/
    @javax.annotation.Nullable
    public Long getOrderSizeMax() {
        return orderSizeMax;
    }


    public void setOrderSizeMax(Long orderSizeMax) {
        this.orderSizeMax = orderSizeMax;
    }

    public OptionsContract orderPriceDeviate(String orderPriceDeviate) {
        
        this.orderPriceDeviate = orderPriceDeviate;
        return this;
    }

     /**
     * deviation between order price and current index price. If price of an order is denoted as order_price, it must meet the following condition:      abs(order_price - mark_price) &lt;&#x3D; mark_price * order_price_deviate
     * @return orderPriceDeviate
    **/
    @javax.annotation.Nullable
    public String getOrderPriceDeviate() {
        return orderPriceDeviate;
    }


    public void setOrderPriceDeviate(String orderPriceDeviate) {
        this.orderPriceDeviate = orderPriceDeviate;
    }

    public OptionsContract refDiscountRate(String refDiscountRate) {
        
        this.refDiscountRate = refDiscountRate;
        return this;
    }

     /**
     * Referral fee rate discount
     * @return refDiscountRate
    **/
    @javax.annotation.Nullable
    public String getRefDiscountRate() {
        return refDiscountRate;
    }


    public void setRefDiscountRate(String refDiscountRate) {
        this.refDiscountRate = refDiscountRate;
    }

    public OptionsContract refRebateRate(String refRebateRate) {
        
        this.refRebateRate = refRebateRate;
        return this;
    }

     /**
     * Referrer commission rate
     * @return refRebateRate
    **/
    @javax.annotation.Nullable
    public String getRefRebateRate() {
        return refRebateRate;
    }


    public void setRefRebateRate(String refRebateRate) {
        this.refRebateRate = refRebateRate;
    }

    public OptionsContract orderbookId(Long orderbookId) {
        
        this.orderbookId = orderbookId;
        return this;
    }

     /**
     * Current orderbook ID
     * @return orderbookId
    **/
    @javax.annotation.Nullable
    public Long getOrderbookId() {
        return orderbookId;
    }


    public void setOrderbookId(Long orderbookId) {
        this.orderbookId = orderbookId;
    }

    public OptionsContract tradeId(Long tradeId) {
        
        this.tradeId = tradeId;
        return this;
    }

     /**
     * Current trade ID
     * @return tradeId
    **/
    @javax.annotation.Nullable
    public Long getTradeId() {
        return tradeId;
    }


    public void setTradeId(Long tradeId) {
        this.tradeId = tradeId;
    }

    public OptionsContract tradeSize(Long tradeSize) {
        
        this.tradeSize = tradeSize;
        return this;
    }

     /**
     * Historical accumulated trade size
     * @return tradeSize
    **/
    @javax.annotation.Nullable
    public Long getTradeSize() {
        return tradeSize;
    }


    public void setTradeSize(Long tradeSize) {
        this.tradeSize = tradeSize;
    }

    public OptionsContract positionSize(Long positionSize) {
        
        this.positionSize = positionSize;
        return this;
    }

     /**
     * Current total long position size
     * @return positionSize
    **/
    @javax.annotation.Nullable
    public Long getPositionSize() {
        return positionSize;
    }


    public void setPositionSize(Long positionSize) {
        this.positionSize = positionSize;
    }

    public OptionsContract ordersLimit(Integer ordersLimit) {
        
        this.ordersLimit = ordersLimit;
        return this;
    }

     /**
     * Maximum number of open orders
     * @return ordersLimit
    **/
    @javax.annotation.Nullable
    public Integer getOrdersLimit() {
        return ordersLimit;
    }


    public void setOrdersLimit(Integer ordersLimit) {
        this.ordersLimit = ordersLimit;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OptionsContract optionsContract = (OptionsContract) o;
        return Objects.equals(this.name, optionsContract.name) &&
                Objects.equals(this.tag, optionsContract.tag) &&
                Objects.equals(this.createTime, optionsContract.createTime) &&
                Objects.equals(this.expirationTime, optionsContract.expirationTime) &&
                Objects.equals(this.isCall, optionsContract.isCall) &&
                Objects.equals(this.multiplier, optionsContract.multiplier) &&
                Objects.equals(this.underlying, optionsContract.underlying) &&
                Objects.equals(this.underlyingPrice, optionsContract.underlyingPrice) &&
                Objects.equals(this.lastPrice, optionsContract.lastPrice) &&
                Objects.equals(this.markPrice, optionsContract.markPrice) &&
                Objects.equals(this.indexPrice, optionsContract.indexPrice) &&
                Objects.equals(this.makerFeeRate, optionsContract.makerFeeRate) &&
                Objects.equals(this.takerFeeRate, optionsContract.takerFeeRate) &&
                Objects.equals(this.orderPriceRound, optionsContract.orderPriceRound) &&
                Objects.equals(this.markPriceRound, optionsContract.markPriceRound) &&
                Objects.equals(this.orderSizeMin, optionsContract.orderSizeMin) &&
                Objects.equals(this.orderSizeMax, optionsContract.orderSizeMax) &&
                Objects.equals(this.orderPriceDeviate, optionsContract.orderPriceDeviate) &&
                Objects.equals(this.refDiscountRate, optionsContract.refDiscountRate) &&
                Objects.equals(this.refRebateRate, optionsContract.refRebateRate) &&
                Objects.equals(this.orderbookId, optionsContract.orderbookId) &&
                Objects.equals(this.tradeId, optionsContract.tradeId) &&
                Objects.equals(this.tradeSize, optionsContract.tradeSize) &&
                Objects.equals(this.positionSize, optionsContract.positionSize) &&
                Objects.equals(this.ordersLimit, optionsContract.ordersLimit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, tag, createTime, expirationTime, isCall, multiplier, underlying, underlyingPrice, lastPrice, markPrice, indexPrice, makerFeeRate, takerFeeRate, orderPriceRound, markPriceRound, orderSizeMin, orderSizeMax, orderPriceDeviate, refDiscountRate, refRebateRate, orderbookId, tradeId, tradeSize, positionSize, ordersLimit);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptionsContract {\n");
        sb.append("      name: ").append(toIndentedString(name)).append("\n");
        sb.append("      tag: ").append(toIndentedString(tag)).append("\n");
        sb.append("      createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("      expirationTime: ").append(toIndentedString(expirationTime)).append("\n");
        sb.append("      isCall: ").append(toIndentedString(isCall)).append("\n");
        sb.append("      multiplier: ").append(toIndentedString(multiplier)).append("\n");
        sb.append("      underlying: ").append(toIndentedString(underlying)).append("\n");
        sb.append("      underlyingPrice: ").append(toIndentedString(underlyingPrice)).append("\n");
        sb.append("      lastPrice: ").append(toIndentedString(lastPrice)).append("\n");
        sb.append("      markPrice: ").append(toIndentedString(markPrice)).append("\n");
        sb.append("      indexPrice: ").append(toIndentedString(indexPrice)).append("\n");
        sb.append("      makerFeeRate: ").append(toIndentedString(makerFeeRate)).append("\n");
        sb.append("      takerFeeRate: ").append(toIndentedString(takerFeeRate)).append("\n");
        sb.append("      orderPriceRound: ").append(toIndentedString(orderPriceRound)).append("\n");
        sb.append("      markPriceRound: ").append(toIndentedString(markPriceRound)).append("\n");
        sb.append("      orderSizeMin: ").append(toIndentedString(orderSizeMin)).append("\n");
        sb.append("      orderSizeMax: ").append(toIndentedString(orderSizeMax)).append("\n");
        sb.append("      orderPriceDeviate: ").append(toIndentedString(orderPriceDeviate)).append("\n");
        sb.append("      refDiscountRate: ").append(toIndentedString(refDiscountRate)).append("\n");
        sb.append("      refRebateRate: ").append(toIndentedString(refRebateRate)).append("\n");
        sb.append("      orderbookId: ").append(toIndentedString(orderbookId)).append("\n");
        sb.append("      tradeId: ").append(toIndentedString(tradeId)).append("\n");
        sb.append("      tradeSize: ").append(toIndentedString(tradeSize)).append("\n");
        sb.append("      positionSize: ").append(toIndentedString(positionSize)).append("\n");
        sb.append("      ordersLimit: ").append(toIndentedString(ordersLimit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

