/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * OptionsAccount
 */
public class OptionsAccount {
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(SERIALIZED_NAME_USER)
    private Integer user;

    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(SERIALIZED_NAME_TOTAL)
    private String total;

    public static final String SERIALIZED_NAME_SHORT_ENABLED = "short_enabled";
    @SerializedName(SERIALIZED_NAME_SHORT_ENABLED)
    private Boolean shortEnabled;

    public static final String SERIALIZED_NAME_UNREALISED_PNL = "unrealised_pnl";
    @SerializedName(SERIALIZED_NAME_UNREALISED_PNL)
    private String unrealisedPnl;

    public static final String SERIALIZED_NAME_INIT_MARGIN = "init_margin";
    @SerializedName(SERIALIZED_NAME_INIT_MARGIN)
    private String initMargin;

    public static final String SERIALIZED_NAME_MAINT_MARGIN = "maint_margin";
    @SerializedName(SERIALIZED_NAME_MAINT_MARGIN)
    private String maintMargin;

    public static final String SERIALIZED_NAME_ORDER_MARGIN = "order_margin";
    @SerializedName(SERIALIZED_NAME_ORDER_MARGIN)
    private String orderMargin;

    public static final String SERIALIZED_NAME_AVAILABLE = "available";
    @SerializedName(SERIALIZED_NAME_AVAILABLE)
    private String available;

    public static final String SERIALIZED_NAME_POINT = "point";
    @SerializedName(SERIALIZED_NAME_POINT)
    private String point;

    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(SERIALIZED_NAME_CURRENCY)
    private String currency;


    public OptionsAccount user(Integer user) {
        
        this.user = user;
        return this;
    }

     /**
     * User ID
     * @return user
    **/
    @javax.annotation.Nullable
    public Integer getUser() {
        return user;
    }


    public void setUser(Integer user) {
        this.user = user;
    }

    public OptionsAccount total(String total) {
        
        this.total = total;
        return this;
    }

     /**
     * Total account balance
     * @return total
    **/
    @javax.annotation.Nullable
    public String getTotal() {
        return total;
    }


    public void setTotal(String total) {
        this.total = total;
    }

    public OptionsAccount shortEnabled(Boolean shortEnabled) {
        
        this.shortEnabled = shortEnabled;
        return this;
    }

     /**
     * If the account is allowed to short
     * @return shortEnabled
    **/
    @javax.annotation.Nullable
    public Boolean getShortEnabled() {
        return shortEnabled;
    }


    public void setShortEnabled(Boolean shortEnabled) {
        this.shortEnabled = shortEnabled;
    }

    public OptionsAccount unrealisedPnl(String unrealisedPnl) {
        
        this.unrealisedPnl = unrealisedPnl;
        return this;
    }

     /**
     * Unrealized PNL
     * @return unrealisedPnl
    **/
    @javax.annotation.Nullable
    public String getUnrealisedPnl() {
        return unrealisedPnl;
    }


    public void setUnrealisedPnl(String unrealisedPnl) {
        this.unrealisedPnl = unrealisedPnl;
    }

    public OptionsAccount initMargin(String initMargin) {
        
        this.initMargin = initMargin;
        return this;
    }

     /**
     * Initial position margin
     * @return initMargin
    **/
    @javax.annotation.Nullable
    public String getInitMargin() {
        return initMargin;
    }


    public void setInitMargin(String initMargin) {
        this.initMargin = initMargin;
    }

    public OptionsAccount maintMargin(String maintMargin) {
        
        this.maintMargin = maintMargin;
        return this;
    }

     /**
     * Position maintenance margin
     * @return maintMargin
    **/
    @javax.annotation.Nullable
    public String getMaintMargin() {
        return maintMargin;
    }


    public void setMaintMargin(String maintMargin) {
        this.maintMargin = maintMargin;
    }

    public OptionsAccount orderMargin(String orderMargin) {
        
        this.orderMargin = orderMargin;
        return this;
    }

     /**
     * Order margin of unfinished orders
     * @return orderMargin
    **/
    @javax.annotation.Nullable
    public String getOrderMargin() {
        return orderMargin;
    }


    public void setOrderMargin(String orderMargin) {
        this.orderMargin = orderMargin;
    }

    public OptionsAccount available(String available) {
        
        this.available = available;
        return this;
    }

     /**
     * Available balance to transfer out or trade
     * @return available
    **/
    @javax.annotation.Nullable
    public String getAvailable() {
        return available;
    }


    public void setAvailable(String available) {
        this.available = available;
    }

    public OptionsAccount point(String point) {
        
        this.point = point;
        return this;
    }

     /**
     * POINT amount
     * @return point
    **/
    @javax.annotation.Nullable
    public String getPoint() {
        return point;
    }


    public void setPoint(String point) {
        this.point = point;
    }

    public OptionsAccount currency(String currency) {
        
        this.currency = currency;
        return this;
    }

     /**
     * Settle currency
     * @return currency
    **/
    @javax.annotation.Nullable
    public String getCurrency() {
        return currency;
    }


    public void setCurrency(String currency) {
        this.currency = currency;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OptionsAccount optionsAccount = (OptionsAccount) o;
        return Objects.equals(this.user, optionsAccount.user) &&
                Objects.equals(this.total, optionsAccount.total) &&
                Objects.equals(this.shortEnabled, optionsAccount.shortEnabled) &&
                Objects.equals(this.unrealisedPnl, optionsAccount.unrealisedPnl) &&
                Objects.equals(this.initMargin, optionsAccount.initMargin) &&
                Objects.equals(this.maintMargin, optionsAccount.maintMargin) &&
                Objects.equals(this.orderMargin, optionsAccount.orderMargin) &&
                Objects.equals(this.available, optionsAccount.available) &&
                Objects.equals(this.point, optionsAccount.point) &&
                Objects.equals(this.currency, optionsAccount.currency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(user, total, shortEnabled, unrealisedPnl, initMargin, maintMargin, orderMargin, available, point, currency);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptionsAccount {\n");
        sb.append("      user: ").append(toIndentedString(user)).append("\n");
        sb.append("      total: ").append(toIndentedString(total)).append("\n");
        sb.append("      shortEnabled: ").append(toIndentedString(shortEnabled)).append("\n");
        sb.append("      unrealisedPnl: ").append(toIndentedString(unrealisedPnl)).append("\n");
        sb.append("      initMargin: ").append(toIndentedString(initMargin)).append("\n");
        sb.append("      maintMargin: ").append(toIndentedString(maintMargin)).append("\n");
        sb.append("      orderMargin: ").append(toIndentedString(orderMargin)).append("\n");
        sb.append("      available: ").append(toIndentedString(available)).append("\n");
        sb.append("      point: ").append(toIndentedString(point)).append("\n");
        sb.append("      currency: ").append(toIndentedString(currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

