/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * FuturesAutoDeleverage
 */
public class FuturesAutoDeleverage {
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(SERIALIZED_NAME_TIME)
    private Long time;

    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(SERIALIZED_NAME_USER)
    private Long user;

    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(SERIALIZED_NAME_ORDER_ID)
    private Long orderId;

    public static final String SERIALIZED_NAME_CONTRACT = "contract";
    @SerializedName(SERIALIZED_NAME_CONTRACT)
    private String contract;

    public static final String SERIALIZED_NAME_LEVERAGE = "leverage";
    @SerializedName(SERIALIZED_NAME_LEVERAGE)
    private String leverage;

    public static final String SERIALIZED_NAME_CROSS_LEVERAGE_LIMIT = "cross_leverage_limit";
    @SerializedName(SERIALIZED_NAME_CROSS_LEVERAGE_LIMIT)
    private String crossLeverageLimit;

    public static final String SERIALIZED_NAME_ENTRY_PRICE = "entry_price";
    @SerializedName(SERIALIZED_NAME_ENTRY_PRICE)
    private String entryPrice;

    public static final String SERIALIZED_NAME_FILL_PRICE = "fill_price";
    @SerializedName(SERIALIZED_NAME_FILL_PRICE)
    private String fillPrice;

    public static final String SERIALIZED_NAME_TRADE_SIZE = "trade_size";
    @SerializedName(SERIALIZED_NAME_TRADE_SIZE)
    private Long tradeSize;

    public static final String SERIALIZED_NAME_POSITION_SIZE = "position_size";
    @SerializedName(SERIALIZED_NAME_POSITION_SIZE)
    private Long positionSize;


     /**
     * Automatic deleveraging time
     * @return time
    **/
    @javax.annotation.Nullable
    public Long getTime() {
        return time;
    }


     /**
     * User ID
     * @return user
    **/
    @javax.annotation.Nullable
    public Long getUser() {
        return user;
    }


     /**
     * Order ID. Order IDs before 2023-02-20 are null
     * @return orderId
    **/
    @javax.annotation.Nullable
    public Long getOrderId() {
        return orderId;
    }


     /**
     * Futures contract
     * @return contract
    **/
    @javax.annotation.Nullable
    public String getContract() {
        return contract;
    }


     /**
     * Position leverage
     * @return leverage
    **/
    @javax.annotation.Nullable
    public String getLeverage() {
        return leverage;
    }


     /**
     * Cross margin leverage(valid only when &#x60;leverage&#x60; is 0)
     * @return crossLeverageLimit
    **/
    @javax.annotation.Nullable
    public String getCrossLeverageLimit() {
        return crossLeverageLimit;
    }


     /**
     * Average entry price
     * @return entryPrice
    **/
    @javax.annotation.Nullable
    public String getEntryPrice() {
        return entryPrice;
    }


     /**
     * Average fill price
     * @return fillPrice
    **/
    @javax.annotation.Nullable
    public String getFillPrice() {
        return fillPrice;
    }


     /**
     * Trading size
     * @return tradeSize
    **/
    @javax.annotation.Nullable
    public Long getTradeSize() {
        return tradeSize;
    }


     /**
     * Positions after auto-deleveraging
     * @return positionSize
    **/
    @javax.annotation.Nullable
    public Long getPositionSize() {
        return positionSize;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FuturesAutoDeleverage futuresAutoDeleverage = (FuturesAutoDeleverage) o;
        return Objects.equals(this.time, futuresAutoDeleverage.time) &&
                Objects.equals(this.user, futuresAutoDeleverage.user) &&
                Objects.equals(this.orderId, futuresAutoDeleverage.orderId) &&
                Objects.equals(this.contract, futuresAutoDeleverage.contract) &&
                Objects.equals(this.leverage, futuresAutoDeleverage.leverage) &&
                Objects.equals(this.crossLeverageLimit, futuresAutoDeleverage.crossLeverageLimit) &&
                Objects.equals(this.entryPrice, futuresAutoDeleverage.entryPrice) &&
                Objects.equals(this.fillPrice, futuresAutoDeleverage.fillPrice) &&
                Objects.equals(this.tradeSize, futuresAutoDeleverage.tradeSize) &&
                Objects.equals(this.positionSize, futuresAutoDeleverage.positionSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(time, user, orderId, contract, leverage, crossLeverageLimit, entryPrice, fillPrice, tradeSize, positionSize);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FuturesAutoDeleverage {\n");
        sb.append("      time: ").append(toIndentedString(time)).append("\n");
        sb.append("      user: ").append(toIndentedString(user)).append("\n");
        sb.append("      orderId: ").append(toIndentedString(orderId)).append("\n");
        sb.append("      contract: ").append(toIndentedString(contract)).append("\n");
        sb.append("      leverage: ").append(toIndentedString(leverage)).append("\n");
        sb.append("      crossLeverageLimit: ").append(toIndentedString(crossLeverageLimit)).append("\n");
        sb.append("      entryPrice: ").append(toIndentedString(entryPrice)).append("\n");
        sb.append("      fillPrice: ").append(toIndentedString(fillPrice)).append("\n");
        sb.append("      tradeSize: ").append(toIndentedString(tradeSize)).append("\n");
        sb.append("      positionSize: ").append(toIndentedString(positionSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

