/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * Parameters of flash swap order creation
 */
public class FlashSwapPreviewRequest {
    public static final String SERIALIZED_NAME_SELL_CURRENCY = "sell_currency";
    @SerializedName(SERIALIZED_NAME_SELL_CURRENCY)
    private String sellCurrency;

    public static final String SERIALIZED_NAME_SELL_AMOUNT = "sell_amount";
    @SerializedName(SERIALIZED_NAME_SELL_AMOUNT)
    private String sellAmount;

    public static final String SERIALIZED_NAME_BUY_CURRENCY = "buy_currency";
    @SerializedName(SERIALIZED_NAME_BUY_CURRENCY)
    private String buyCurrency;

    public static final String SERIALIZED_NAME_BUY_AMOUNT = "buy_amount";
    @SerializedName(SERIALIZED_NAME_BUY_AMOUNT)
    private String buyAmount;


    public FlashSwapPreviewRequest sellCurrency(String sellCurrency) {
        
        this.sellCurrency = sellCurrency;
        return this;
    }

     /**
     * Currency to sell which can be retrieved from supported currency list API &#x60;GET /flash_swap/currencies&#x60;
     * @return sellCurrency
    **/
    public String getSellCurrency() {
        return sellCurrency;
    }


    public void setSellCurrency(String sellCurrency) {
        this.sellCurrency = sellCurrency;
    }

    public FlashSwapPreviewRequest sellAmount(String sellAmount) {
        
        this.sellAmount = sellAmount;
        return this;
    }

     /**
     * Amount to sell. It is required to choose one parameter between &#x60;sell_amount&#x60; and &#x60;buy_amount&#x60;
     * @return sellAmount
    **/
    @javax.annotation.Nullable
    public String getSellAmount() {
        return sellAmount;
    }


    public void setSellAmount(String sellAmount) {
        this.sellAmount = sellAmount;
    }

    public FlashSwapPreviewRequest buyCurrency(String buyCurrency) {
        
        this.buyCurrency = buyCurrency;
        return this;
    }

     /**
     * Currency to buy which can be retrieved from supported currency list API &#x60;GET /flash_swap/currencies&#x60;
     * @return buyCurrency
    **/
    public String getBuyCurrency() {
        return buyCurrency;
    }


    public void setBuyCurrency(String buyCurrency) {
        this.buyCurrency = buyCurrency;
    }

    public FlashSwapPreviewRequest buyAmount(String buyAmount) {
        
        this.buyAmount = buyAmount;
        return this;
    }

     /**
     * Amount to buy. It is required to choose one parameter between &#x60;sell_amount&#x60; and &#x60;buy_amount&#x60;
     * @return buyAmount
    **/
    @javax.annotation.Nullable
    public String getBuyAmount() {
        return buyAmount;
    }


    public void setBuyAmount(String buyAmount) {
        this.buyAmount = buyAmount;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FlashSwapPreviewRequest flashSwapPreviewRequest = (FlashSwapPreviewRequest) o;
        return Objects.equals(this.sellCurrency, flashSwapPreviewRequest.sellCurrency) &&
                Objects.equals(this.sellAmount, flashSwapPreviewRequest.sellAmount) &&
                Objects.equals(this.buyCurrency, flashSwapPreviewRequest.buyCurrency) &&
                Objects.equals(this.buyAmount, flashSwapPreviewRequest.buyAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sellCurrency, sellAmount, buyCurrency, buyAmount);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlashSwapPreviewRequest {\n");
        sb.append("      sellCurrency: ").append(toIndentedString(sellCurrency)).append("\n");
        sb.append("      sellAmount: ").append(toIndentedString(sellAmount)).append("\n");
        sb.append("      buyCurrency: ").append(toIndentedString(buyCurrency)).append("\n");
        sb.append("      buyAmount: ").append(toIndentedString(buyAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

