/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * Initiate a flash swap order preview
 */
public class FlashSwapOrderPreview {
    public static final String SERIALIZED_NAME_PREVIEW_ID = "preview_id";
    @SerializedName(SERIALIZED_NAME_PREVIEW_ID)
    private String previewId;

    public static final String SERIALIZED_NAME_SELL_CURRENCY = "sell_currency";
    @SerializedName(SERIALIZED_NAME_SELL_CURRENCY)
    private String sellCurrency;

    public static final String SERIALIZED_NAME_SELL_AMOUNT = "sell_amount";
    @SerializedName(SERIALIZED_NAME_SELL_AMOUNT)
    private String sellAmount;

    public static final String SERIALIZED_NAME_BUY_CURRENCY = "buy_currency";
    @SerializedName(SERIALIZED_NAME_BUY_CURRENCY)
    private String buyCurrency;

    public static final String SERIALIZED_NAME_BUY_AMOUNT = "buy_amount";
    @SerializedName(SERIALIZED_NAME_BUY_AMOUNT)
    private String buyAmount;

    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(SERIALIZED_NAME_PRICE)
    private String price;


    public FlashSwapOrderPreview previewId(String previewId) {
        
        this.previewId = previewId;
        return this;
    }

     /**
     * Preview result ID
     * @return previewId
    **/
    @javax.annotation.Nullable
    public String getPreviewId() {
        return previewId;
    }


    public void setPreviewId(String previewId) {
        this.previewId = previewId;
    }

    public FlashSwapOrderPreview sellCurrency(String sellCurrency) {
        
        this.sellCurrency = sellCurrency;
        return this;
    }

     /**
     * Currency to sell which can be retrieved from supported currency list API &#x60;GET /flash_swap/currencies&#x60;
     * @return sellCurrency
    **/
    @javax.annotation.Nullable
    public String getSellCurrency() {
        return sellCurrency;
    }


    public void setSellCurrency(String sellCurrency) {
        this.sellCurrency = sellCurrency;
    }

    public FlashSwapOrderPreview sellAmount(String sellAmount) {
        
        this.sellAmount = sellAmount;
        return this;
    }

     /**
     * Amount to sell
     * @return sellAmount
    **/
    @javax.annotation.Nullable
    public String getSellAmount() {
        return sellAmount;
    }


    public void setSellAmount(String sellAmount) {
        this.sellAmount = sellAmount;
    }

    public FlashSwapOrderPreview buyCurrency(String buyCurrency) {
        
        this.buyCurrency = buyCurrency;
        return this;
    }

     /**
     * Currency to buy which can be retrieved from supported currency list API &#x60;GET /flash_swap/currencies&#x60;
     * @return buyCurrency
    **/
    @javax.annotation.Nullable
    public String getBuyCurrency() {
        return buyCurrency;
    }


    public void setBuyCurrency(String buyCurrency) {
        this.buyCurrency = buyCurrency;
    }

    public FlashSwapOrderPreview buyAmount(String buyAmount) {
        
        this.buyAmount = buyAmount;
        return this;
    }

     /**
     * Amount to buy
     * @return buyAmount
    **/
    @javax.annotation.Nullable
    public String getBuyAmount() {
        return buyAmount;
    }


    public void setBuyAmount(String buyAmount) {
        this.buyAmount = buyAmount;
    }

    public FlashSwapOrderPreview price(String price) {
        
        this.price = price;
        return this;
    }

     /**
     * Price
     * @return price
    **/
    @javax.annotation.Nullable
    public String getPrice() {
        return price;
    }


    public void setPrice(String price) {
        this.price = price;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FlashSwapOrderPreview flashSwapOrderPreview = (FlashSwapOrderPreview) o;
        return Objects.equals(this.previewId, flashSwapOrderPreview.previewId) &&
                Objects.equals(this.sellCurrency, flashSwapOrderPreview.sellCurrency) &&
                Objects.equals(this.sellAmount, flashSwapOrderPreview.sellAmount) &&
                Objects.equals(this.buyCurrency, flashSwapOrderPreview.buyCurrency) &&
                Objects.equals(this.buyAmount, flashSwapOrderPreview.buyAmount) &&
                Objects.equals(this.price, flashSwapOrderPreview.price);
    }

    @Override
    public int hashCode() {
        return Objects.hash(previewId, sellCurrency, sellAmount, buyCurrency, buyAmount, price);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlashSwapOrderPreview {\n");
        sb.append("      previewId: ").append(toIndentedString(previewId)).append("\n");
        sb.append("      sellCurrency: ").append(toIndentedString(sellCurrency)).append("\n");
        sb.append("      sellAmount: ").append(toIndentedString(sellAmount)).append("\n");
        sb.append("      buyCurrency: ").append(toIndentedString(buyCurrency)).append("\n");
        sb.append("      buyAmount: ").append(toIndentedString(buyAmount)).append("\n");
        sb.append("      price: ").append(toIndentedString(price)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

