/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gate.gateapi.models.CrossMarginBalance;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CrossMarginAccount
 */
public class CrossMarginAccount {
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(SERIALIZED_NAME_USER_ID)
    private Long userId;

    public static final String SERIALIZED_NAME_REFRESH_TIME = "refresh_time";
    @SerializedName(SERIALIZED_NAME_REFRESH_TIME)
    private Long refreshTime;

    public static final String SERIALIZED_NAME_LOCKED = "locked";
    @SerializedName(SERIALIZED_NAME_LOCKED)
    private Boolean locked;

    public static final String SERIALIZED_NAME_BALANCES = "balances";
    @SerializedName(SERIALIZED_NAME_BALANCES)
    private Map<String, CrossMarginBalance> balances = null;

    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(SERIALIZED_NAME_TOTAL)
    private String total;

    public static final String SERIALIZED_NAME_BORROWED = "borrowed";
    @SerializedName(SERIALIZED_NAME_BORROWED)
    private String borrowed;

    public static final String SERIALIZED_NAME_INTEREST = "interest";
    @SerializedName(SERIALIZED_NAME_INTEREST)
    private String interest;

    public static final String SERIALIZED_NAME_RISK = "risk";
    @SerializedName(SERIALIZED_NAME_RISK)
    private String risk;

    public static final String SERIALIZED_NAME_TOTAL_INITIAL_MARGIN = "total_initial_margin";
    @SerializedName(SERIALIZED_NAME_TOTAL_INITIAL_MARGIN)
    private String totalInitialMargin;

    public static final String SERIALIZED_NAME_TOTAL_MARGIN_BALANCE = "total_margin_balance";
    @SerializedName(SERIALIZED_NAME_TOTAL_MARGIN_BALANCE)
    private String totalMarginBalance;

    public static final String SERIALIZED_NAME_TOTAL_MAINTENANCE_MARGIN = "total_maintenance_margin";
    @SerializedName(SERIALIZED_NAME_TOTAL_MAINTENANCE_MARGIN)
    private String totalMaintenanceMargin;

    public static final String SERIALIZED_NAME_TOTAL_INITIAL_MARGIN_RATE = "total_initial_margin_rate";
    @SerializedName(SERIALIZED_NAME_TOTAL_INITIAL_MARGIN_RATE)
    private String totalInitialMarginRate;

    public static final String SERIALIZED_NAME_TOTAL_MAINTENANCE_MARGIN_RATE = "total_maintenance_margin_rate";
    @SerializedName(SERIALIZED_NAME_TOTAL_MAINTENANCE_MARGIN_RATE)
    private String totalMaintenanceMarginRate;

    public static final String SERIALIZED_NAME_TOTAL_AVAILABLE_MARGIN = "total_available_margin";
    @SerializedName(SERIALIZED_NAME_TOTAL_AVAILABLE_MARGIN)
    private String totalAvailableMargin;

    public static final String SERIALIZED_NAME_PORTFOLIO_MARGIN_TOTAL = "portfolio_margin_total";
    @SerializedName(SERIALIZED_NAME_PORTFOLIO_MARGIN_TOTAL)
    private String portfolioMarginTotal;

    public static final String SERIALIZED_NAME_PORTFOLIO_MARGIN_TOTAL_LIAB = "portfolio_margin_total_liab";
    @SerializedName(SERIALIZED_NAME_PORTFOLIO_MARGIN_TOTAL_LIAB)
    private String portfolioMarginTotalLiab;

    public static final String SERIALIZED_NAME_PORTFOLIO_MARGIN_TOTAL_EQUITY = "portfolio_margin_total_equity";
    @SerializedName(SERIALIZED_NAME_PORTFOLIO_MARGIN_TOTAL_EQUITY)
    private String portfolioMarginTotalEquity;


    public CrossMarginAccount userId(Long userId) {
        
        this.userId = userId;
        return this;
    }

     /**
     * User ID
     * @return userId
    **/
    @javax.annotation.Nullable
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public CrossMarginAccount refreshTime(Long refreshTime) {
        
        this.refreshTime = refreshTime;
        return this;
    }

     /**
     * Time of the most recent refresh
     * @return refreshTime
    **/
    @javax.annotation.Nullable
    public Long getRefreshTime() {
        return refreshTime;
    }


    public void setRefreshTime(Long refreshTime) {
        this.refreshTime = refreshTime;
    }

    public CrossMarginAccount locked(Boolean locked) {
        
        this.locked = locked;
        return this;
    }

     /**
     * Whether account is locked
     * @return locked
    **/
    @javax.annotation.Nullable
    public Boolean getLocked() {
        return locked;
    }


    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public CrossMarginAccount balances(Map<String, CrossMarginBalance> balances) {
        
        this.balances = balances;
        return this;
    }

    public CrossMarginAccount putBalancesItem(String key, CrossMarginBalance balancesItem) {
        if (this.balances == null) {
            this.balances = new HashMap<>();
        }
        this.balances.put(key, balancesItem);
        return this;
    }

     /**
     * Get balances
     * @return balances
    **/
    @javax.annotation.Nullable
    public Map<String, CrossMarginBalance> getBalances() {
        return balances;
    }


    public void setBalances(Map<String, CrossMarginBalance> balances) {
        this.balances = balances;
    }

    public CrossMarginAccount total(String total) {
        
        this.total = total;
        return this;
    }

     /**
     * Total account value in USDT, i.e., the sum of all currencies&#39; &#x60;(available+freeze)*price*discount&#x60;
     * @return total
    **/
    @javax.annotation.Nullable
    public String getTotal() {
        return total;
    }


    public void setTotal(String total) {
        this.total = total;
    }

    public CrossMarginAccount borrowed(String borrowed) {
        
        this.borrowed = borrowed;
        return this;
    }

     /**
     * Total borrowed value in USDT, i.e., the sum of all currencies&#39; &#x60;borrowed*price*discount&#x60;
     * @return borrowed
    **/
    @javax.annotation.Nullable
    public String getBorrowed() {
        return borrowed;
    }


    public void setBorrowed(String borrowed) {
        this.borrowed = borrowed;
    }

    public CrossMarginAccount interest(String interest) {
        
        this.interest = interest;
        return this;
    }

     /**
     * Total unpaid interests in USDT, i.e., the sum of all currencies&#39; &#x60;interest*price*discount&#x60;
     * @return interest
    **/
    @javax.annotation.Nullable
    public String getInterest() {
        return interest;
    }


    public void setInterest(String interest) {
        this.interest = interest;
    }

    public CrossMarginAccount risk(String risk) {
        
        this.risk = risk;
        return this;
    }

     /**
     * Risk rate. When it belows 110%, liquidation will be triggered. Calculation formula: &#x60;total / (borrowed+interest)&#x60;
     * @return risk
    **/
    @javax.annotation.Nullable
    public String getRisk() {
        return risk;
    }


    public void setRisk(String risk) {
        this.risk = risk;
    }

    public CrossMarginAccount totalInitialMargin(String totalInitialMargin) {
        
        this.totalInitialMargin = totalInitialMargin;
        return this;
    }

     /**
     * Total initial margin
     * @return totalInitialMargin
    **/
    @javax.annotation.Nullable
    public String getTotalInitialMargin() {
        return totalInitialMargin;
    }


    public void setTotalInitialMargin(String totalInitialMargin) {
        this.totalInitialMargin = totalInitialMargin;
    }

    public CrossMarginAccount totalMarginBalance(String totalMarginBalance) {
        
        this.totalMarginBalance = totalMarginBalance;
        return this;
    }

     /**
     * Total Margin Balance (∑(positive equity ＊ index price * discount) + ∑(negative equity * index price))
     * @return totalMarginBalance
    **/
    @javax.annotation.Nullable
    public String getTotalMarginBalance() {
        return totalMarginBalance;
    }


    public void setTotalMarginBalance(String totalMarginBalance) {
        this.totalMarginBalance = totalMarginBalance;
    }

    public CrossMarginAccount totalMaintenanceMargin(String totalMaintenanceMargin) {
        
        this.totalMaintenanceMargin = totalMaintenanceMargin;
        return this;
    }

     /**
     * Total maintenance margin
     * @return totalMaintenanceMargin
    **/
    @javax.annotation.Nullable
    public String getTotalMaintenanceMargin() {
        return totalMaintenanceMargin;
    }


    public void setTotalMaintenanceMargin(String totalMaintenanceMargin) {
        this.totalMaintenanceMargin = totalMaintenanceMargin;
    }

    public CrossMarginAccount totalInitialMarginRate(String totalInitialMarginRate) {
        
        this.totalInitialMarginRate = totalInitialMarginRate;
        return this;
    }

     /**
     * Total initial margin rate
     * @return totalInitialMarginRate
    **/
    @javax.annotation.Nullable
    public String getTotalInitialMarginRate() {
        return totalInitialMarginRate;
    }


    public void setTotalInitialMarginRate(String totalInitialMarginRate) {
        this.totalInitialMarginRate = totalInitialMarginRate;
    }

    public CrossMarginAccount totalMaintenanceMarginRate(String totalMaintenanceMarginRate) {
        
        this.totalMaintenanceMarginRate = totalMaintenanceMarginRate;
        return this;
    }

     /**
     * Total maintenance margin rate
     * @return totalMaintenanceMarginRate
    **/
    @javax.annotation.Nullable
    public String getTotalMaintenanceMarginRate() {
        return totalMaintenanceMarginRate;
    }


    public void setTotalMaintenanceMarginRate(String totalMaintenanceMarginRate) {
        this.totalMaintenanceMarginRate = totalMaintenanceMarginRate;
    }

    public CrossMarginAccount totalAvailableMargin(String totalAvailableMargin) {
        
        this.totalAvailableMargin = totalAvailableMargin;
        return this;
    }

     /**
     * Total available margin
     * @return totalAvailableMargin
    **/
    @javax.annotation.Nullable
    public String getTotalAvailableMargin() {
        return totalAvailableMargin;
    }


    public void setTotalAvailableMargin(String totalAvailableMargin) {
        this.totalAvailableMargin = totalAvailableMargin;
    }

    public CrossMarginAccount portfolioMarginTotal(String portfolioMarginTotal) {
        
        this.portfolioMarginTotal = portfolioMarginTotal;
        return this;
    }

     /**
     * Total amount of the portfolio margin account
     * @return portfolioMarginTotal
    **/
    @javax.annotation.Nullable
    public String getPortfolioMarginTotal() {
        return portfolioMarginTotal;
    }


    public void setPortfolioMarginTotal(String portfolioMarginTotal) {
        this.portfolioMarginTotal = portfolioMarginTotal;
    }

    public CrossMarginAccount portfolioMarginTotalLiab(String portfolioMarginTotalLiab) {
        
        this.portfolioMarginTotalLiab = portfolioMarginTotalLiab;
        return this;
    }

     /**
     * Total liabilities of the portfolio margin account
     * @return portfolioMarginTotalLiab
    **/
    @javax.annotation.Nullable
    public String getPortfolioMarginTotalLiab() {
        return portfolioMarginTotalLiab;
    }


    public void setPortfolioMarginTotalLiab(String portfolioMarginTotalLiab) {
        this.portfolioMarginTotalLiab = portfolioMarginTotalLiab;
    }

    public CrossMarginAccount portfolioMarginTotalEquity(String portfolioMarginTotalEquity) {
        
        this.portfolioMarginTotalEquity = portfolioMarginTotalEquity;
        return this;
    }

     /**
     * Total equity of the portfolio margin account
     * @return portfolioMarginTotalEquity
    **/
    @javax.annotation.Nullable
    public String getPortfolioMarginTotalEquity() {
        return portfolioMarginTotalEquity;
    }


    public void setPortfolioMarginTotalEquity(String portfolioMarginTotalEquity) {
        this.portfolioMarginTotalEquity = portfolioMarginTotalEquity;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CrossMarginAccount crossMarginAccount = (CrossMarginAccount) o;
        return Objects.equals(this.userId, crossMarginAccount.userId) &&
                Objects.equals(this.refreshTime, crossMarginAccount.refreshTime) &&
                Objects.equals(this.locked, crossMarginAccount.locked) &&
                Objects.equals(this.balances, crossMarginAccount.balances) &&
                Objects.equals(this.total, crossMarginAccount.total) &&
                Objects.equals(this.borrowed, crossMarginAccount.borrowed) &&
                Objects.equals(this.interest, crossMarginAccount.interest) &&
                Objects.equals(this.risk, crossMarginAccount.risk) &&
                Objects.equals(this.totalInitialMargin, crossMarginAccount.totalInitialMargin) &&
                Objects.equals(this.totalMarginBalance, crossMarginAccount.totalMarginBalance) &&
                Objects.equals(this.totalMaintenanceMargin, crossMarginAccount.totalMaintenanceMargin) &&
                Objects.equals(this.totalInitialMarginRate, crossMarginAccount.totalInitialMarginRate) &&
                Objects.equals(this.totalMaintenanceMarginRate, crossMarginAccount.totalMaintenanceMarginRate) &&
                Objects.equals(this.totalAvailableMargin, crossMarginAccount.totalAvailableMargin) &&
                Objects.equals(this.portfolioMarginTotal, crossMarginAccount.portfolioMarginTotal) &&
                Objects.equals(this.portfolioMarginTotalLiab, crossMarginAccount.portfolioMarginTotalLiab) &&
                Objects.equals(this.portfolioMarginTotalEquity, crossMarginAccount.portfolioMarginTotalEquity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId, refreshTime, locked, balances, total, borrowed, interest, risk, totalInitialMargin, totalMarginBalance, totalMaintenanceMargin, totalInitialMarginRate, totalMaintenanceMarginRate, totalAvailableMargin, portfolioMarginTotal, portfolioMarginTotalLiab, portfolioMarginTotalEquity);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrossMarginAccount {\n");
        sb.append("      userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("      refreshTime: ").append(toIndentedString(refreshTime)).append("\n");
        sb.append("      locked: ").append(toIndentedString(locked)).append("\n");
        sb.append("      balances: ").append(toIndentedString(balances)).append("\n");
        sb.append("      total: ").append(toIndentedString(total)).append("\n");
        sb.append("      borrowed: ").append(toIndentedString(borrowed)).append("\n");
        sb.append("      interest: ").append(toIndentedString(interest)).append("\n");
        sb.append("      risk: ").append(toIndentedString(risk)).append("\n");
        sb.append("      totalInitialMargin: ").append(toIndentedString(totalInitialMargin)).append("\n");
        sb.append("      totalMarginBalance: ").append(toIndentedString(totalMarginBalance)).append("\n");
        sb.append("      totalMaintenanceMargin: ").append(toIndentedString(totalMaintenanceMargin)).append("\n");
        sb.append("      totalInitialMarginRate: ").append(toIndentedString(totalInitialMarginRate)).append("\n");
        sb.append("      totalMaintenanceMarginRate: ").append(toIndentedString(totalMaintenanceMarginRate)).append("\n");
        sb.append("      totalAvailableMargin: ").append(toIndentedString(totalAvailableMargin)).append("\n");
        sb.append("      portfolioMarginTotal: ").append(toIndentedString(portfolioMarginTotal)).append("\n");
        sb.append("      portfolioMarginTotalLiab: ").append(toIndentedString(portfolioMarginTotalLiab)).append("\n");
        sb.append("      portfolioMarginTotalEquity: ").append(toIndentedString(portfolioMarginTotalEquity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

