/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.SubAccount;
import io.gate.gateapi.models.SubAccountKey;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubAccountApi {
    private ApiClient localVarApiClient;

    public SubAccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubAccountApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private okhttp3.Call listSubAccountsCall(String type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sub_accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSubAccountsValidateBeforeCall(String type, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountsCall(type, _callback);
        return localVarCall;
    }


    private ApiResponse<List<SubAccount>> listSubAccountsWithHttpInfo(String type) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountsValidateBeforeCall(type, null);
        Type localVarReturnType = new TypeToken<List<SubAccount>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listSubAccountsAsync(String type, final ApiCallback<List<SubAccount>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountsValidateBeforeCall(type, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccount>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistSubAccountsRequest {
        private String type;

        private APIlistSubAccountsRequest() {
        }

        /**
         * Set type
         * @param type &#x60;0&#x60; to list all types of sub-accounts (currently supporting cross margin accounts and sub-accounts).  &#x60;1&#x60; to list sub-accounts only. If no parameter is passed, only sub-accounts will be listed by default. (optional)
         * @return APIlistSubAccountsRequest
         */
        public APIlistSubAccountsRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Build call for listSubAccounts
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listSubAccountsCall(type, _callback);
        }

        /**
         * Execute listSubAccounts request
         * @return List&lt;SubAccount&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<SubAccount> execute() throws ApiException {
            ApiResponse<List<SubAccount>> localVarResp = listSubAccountsWithHttpInfo(type);
            return localVarResp.getData();
        }

        /**
         * Execute listSubAccounts request with HTTP info returned
         * @return ApiResponse&lt;List&lt;SubAccount&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<SubAccount>> executeWithHttpInfo() throws ApiException {
            return listSubAccountsWithHttpInfo(type);
        }

        /**
         * Execute listSubAccounts request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<SubAccount>> _callback) throws ApiException {
            return listSubAccountsAsync(type, _callback);
        }
    }

    /**
     * List sub-accounts
     * 
     * @return APIlistSubAccountsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistSubAccountsRequest listSubAccounts() {
        return new APIlistSubAccountsRequest();
    }

    /**
     * Build call for createSubAccounts
     * @param subAccount  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created Successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSubAccountsCall(SubAccount subAccount, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = subAccount;

        // create path and map variables
        String localVarPath = "/sub_accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createSubAccountsValidateBeforeCall(SubAccount subAccount, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'subAccount' is set
        if (subAccount == null) {
            throw new ApiException("Missing the required parameter 'subAccount' when calling createSubAccounts(Async)");
        }

        okhttp3.Call localVarCall = createSubAccountsCall(subAccount, _callback);
        return localVarCall;
    }

    /**
     * Create a new sub-account
     * 
     * @param subAccount  (required)
     * @return SubAccount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created Successfully </td><td>  -  </td></tr>
     </table>
     */
    public SubAccount createSubAccounts(SubAccount subAccount) throws ApiException {
        ApiResponse<SubAccount> localVarResp = createSubAccountsWithHttpInfo(subAccount);
        return localVarResp.getData();
    }

    /**
     * Create a new sub-account
     * 
     * @param subAccount  (required)
     * @return ApiResponse&lt;SubAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created Successfully </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubAccount> createSubAccountsWithHttpInfo(SubAccount subAccount) throws ApiException {
        okhttp3.Call localVarCall = createSubAccountsValidateBeforeCall(subAccount, null);
        Type localVarReturnType = new TypeToken<SubAccount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a new sub-account (asynchronously)
     * 
     * @param subAccount  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created Successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSubAccountsAsync(SubAccount subAccount, final ApiCallback<SubAccount> _callback) throws ApiException {
        okhttp3.Call localVarCall = createSubAccountsValidateBeforeCall(subAccount, _callback);
        Type localVarReturnType = new TypeToken<SubAccount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getSubAccount
     * @param userId Sub-account user id (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSubAccountCall(Long userId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sub_accounts/{user_id}"
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSubAccountValidateBeforeCall(Long userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getSubAccount(Async)");
        }

        okhttp3.Call localVarCall = getSubAccountCall(userId, _callback);
        return localVarCall;
    }

    /**
     * Get the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @return SubAccount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public SubAccount getSubAccount(Long userId) throws ApiException {
        ApiResponse<SubAccount> localVarResp = getSubAccountWithHttpInfo(userId);
        return localVarResp.getData();
    }

    /**
     * Get the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @return ApiResponse&lt;SubAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubAccount> getSubAccountWithHttpInfo(Long userId) throws ApiException {
        okhttp3.Call localVarCall = getSubAccountValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<SubAccount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the sub-account (asynchronously)
     * 
     * @param userId Sub-account user id (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSubAccountAsync(Long userId, final ApiCallback<SubAccount> _callback) throws ApiException {
        okhttp3.Call localVarCall = getSubAccountValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<SubAccount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for listSubAccountKeys
     * @param userId Sub-account user id (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSubAccountKeysCall(Integer userId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sub_accounts/{user_id}/keys"
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSubAccountKeysValidateBeforeCall(Integer userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listSubAccountKeys(Async)");
        }

        okhttp3.Call localVarCall = listSubAccountKeysCall(userId, _callback);
        return localVarCall;
    }

    /**
     * List all API Key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @return List&lt;SubAccountKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<SubAccountKey> listSubAccountKeys(Integer userId) throws ApiException {
        ApiResponse<List<SubAccountKey>> localVarResp = listSubAccountKeysWithHttpInfo(userId);
        return localVarResp.getData();
    }

    /**
     * List all API Key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @return ApiResponse&lt;List&lt;SubAccountKey&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<SubAccountKey>> listSubAccountKeysWithHttpInfo(Integer userId) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountKeysValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<List<SubAccountKey>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all API Key of the sub-account (asynchronously)
     * 
     * @param userId Sub-account user id (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSubAccountKeysAsync(Integer userId, final ApiCallback<List<SubAccountKey>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountKeysValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountKey>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for createSubAccountKeys
     * @param userId Sub-account user id (required)
     * @param subAccountKey  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Created Successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSubAccountKeysCall(Long userId, SubAccountKey subAccountKey, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = subAccountKey;

        // create path and map variables
        String localVarPath = "/sub_accounts/{user_id}/keys"
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createSubAccountKeysValidateBeforeCall(Long userId, SubAccountKey subAccountKey, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createSubAccountKeys(Async)");
        }

        // verify the required parameter 'subAccountKey' is set
        if (subAccountKey == null) {
            throw new ApiException("Missing the required parameter 'subAccountKey' when calling createSubAccountKeys(Async)");
        }

        okhttp3.Call localVarCall = createSubAccountKeysCall(userId, subAccountKey, _callback);
        return localVarCall;
    }

    /**
     * Create API Key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @param subAccountKey  (required)
     * @return List&lt;SubAccountKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Created Successfully </td><td>  -  </td></tr>
     </table>
     */
    public List<SubAccountKey> createSubAccountKeys(Long userId, SubAccountKey subAccountKey) throws ApiException {
        ApiResponse<List<SubAccountKey>> localVarResp = createSubAccountKeysWithHttpInfo(userId, subAccountKey);
        return localVarResp.getData();
    }

    /**
     * Create API Key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @param subAccountKey  (required)
     * @return ApiResponse&lt;List&lt;SubAccountKey&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Created Successfully </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<SubAccountKey>> createSubAccountKeysWithHttpInfo(Long userId, SubAccountKey subAccountKey) throws ApiException {
        okhttp3.Call localVarCall = createSubAccountKeysValidateBeforeCall(userId, subAccountKey, null);
        Type localVarReturnType = new TypeToken<List<SubAccountKey>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create API Key of the sub-account (asynchronously)
     * 
     * @param userId Sub-account user id (required)
     * @param subAccountKey  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Created Successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSubAccountKeysAsync(Long userId, SubAccountKey subAccountKey, final ApiCallback<List<SubAccountKey>> _callback) throws ApiException {
        okhttp3.Call localVarCall = createSubAccountKeysValidateBeforeCall(userId, subAccountKey, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountKey>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getSubAccountKey
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSubAccountKeyCall(Integer userId, String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sub_accounts/{user_id}/keys/{key}"
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSubAccountKeyValidateBeforeCall(Integer userId, String key, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getSubAccountKey(Async)");
        }

        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getSubAccountKey(Async)");
        }

        okhttp3.Call localVarCall = getSubAccountKeyCall(userId, key, _callback);
        return localVarCall;
    }

    /**
     * Get the API Key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @return SubAccountKey
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public SubAccountKey getSubAccountKey(Integer userId, String key) throws ApiException {
        ApiResponse<SubAccountKey> localVarResp = getSubAccountKeyWithHttpInfo(userId, key);
        return localVarResp.getData();
    }

    /**
     * Get the API Key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @return ApiResponse&lt;SubAccountKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubAccountKey> getSubAccountKeyWithHttpInfo(Integer userId, String key) throws ApiException {
        okhttp3.Call localVarCall = getSubAccountKeyValidateBeforeCall(userId, key, null);
        Type localVarReturnType = new TypeToken<SubAccountKey>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the API Key of the sub-account (asynchronously)
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSubAccountKeyAsync(Integer userId, String key, final ApiCallback<SubAccountKey> _callback) throws ApiException {
        okhttp3.Call localVarCall = getSubAccountKeyValidateBeforeCall(userId, key, _callback);
        Type localVarReturnType = new TypeToken<SubAccountKey>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updateSubAccountKeys
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @param subAccountKey  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSubAccountKeysCall(Integer userId, String key, SubAccountKey subAccountKey, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = subAccountKey;

        // create path and map variables
        String localVarPath = "/sub_accounts/{user_id}/keys/{key}"
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSubAccountKeysValidateBeforeCall(Integer userId, String key, SubAccountKey subAccountKey, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling updateSubAccountKeys(Async)");
        }

        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateSubAccountKeys(Async)");
        }

        // verify the required parameter 'subAccountKey' is set
        if (subAccountKey == null) {
            throw new ApiException("Missing the required parameter 'subAccountKey' when calling updateSubAccountKeys(Async)");
        }

        okhttp3.Call localVarCall = updateSubAccountKeysCall(userId, key, subAccountKey, _callback);
        return localVarCall;
    }

    /**
     * Update API key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @param subAccountKey  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public void updateSubAccountKeys(Integer userId, String key, SubAccountKey subAccountKey) throws ApiException {
        updateSubAccountKeysWithHttpInfo(userId, key, subAccountKey);
    }

    /**
     * Update API key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @param subAccountKey  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateSubAccountKeysWithHttpInfo(Integer userId, String key, SubAccountKey subAccountKey) throws ApiException {
        okhttp3.Call localVarCall = updateSubAccountKeysValidateBeforeCall(userId, key, subAccountKey, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update API key of the sub-account (asynchronously)
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @param subAccountKey  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSubAccountKeysAsync(Integer userId, String key, SubAccountKey subAccountKey, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = updateSubAccountKeysValidateBeforeCall(userId, key, subAccountKey, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    /**
     * Build call for deleteSubAccountKeys
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Delete successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteSubAccountKeysCall(Integer userId, String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sub_accounts/{user_id}/keys/{key}"
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteSubAccountKeysValidateBeforeCall(Integer userId, String key, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteSubAccountKeys(Async)");
        }

        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling deleteSubAccountKeys(Async)");
        }

        okhttp3.Call localVarCall = deleteSubAccountKeysCall(userId, key, _callback);
        return localVarCall;
    }

    /**
     * Delete API key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Delete successfully </td><td>  -  </td></tr>
     </table>
     */
    public void deleteSubAccountKeys(Integer userId, String key) throws ApiException {
        deleteSubAccountKeysWithHttpInfo(userId, key);
    }

    /**
     * Delete API key of the sub-account
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Delete successfully </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteSubAccountKeysWithHttpInfo(Integer userId, String key) throws ApiException {
        okhttp3.Call localVarCall = deleteSubAccountKeysValidateBeforeCall(userId, key, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete API key of the sub-account (asynchronously)
     * 
     * @param userId Sub-account user id (required)
     * @param key The API Key of the sub-account (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Delete successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteSubAccountKeysAsync(Integer userId, String key, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = deleteSubAccountKeysValidateBeforeCall(userId, key, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    /**
     * Build call for lockSubAccount
     * @param userId The user id of the sub-account (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Lock successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call lockSubAccountCall(Long userId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sub_accounts/{user_id}/lock"
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call lockSubAccountValidateBeforeCall(Long userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling lockSubAccount(Async)");
        }

        okhttp3.Call localVarCall = lockSubAccountCall(userId, _callback);
        return localVarCall;
    }

    /**
     * Lock the sub-account
     * 
     * @param userId The user id of the sub-account (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Lock successfully </td><td>  -  </td></tr>
     </table>
     */
    public void lockSubAccount(Long userId) throws ApiException {
        lockSubAccountWithHttpInfo(userId);
    }

    /**
     * Lock the sub-account
     * 
     * @param userId The user id of the sub-account (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Lock successfully </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> lockSubAccountWithHttpInfo(Long userId) throws ApiException {
        okhttp3.Call localVarCall = lockSubAccountValidateBeforeCall(userId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Lock the sub-account (asynchronously)
     * 
     * @param userId The user id of the sub-account (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Lock successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call lockSubAccountAsync(Long userId, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = lockSubAccountValidateBeforeCall(userId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    /**
     * Build call for unlockSubAccount
     * @param userId The user id of the sub-account (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Unlock successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call unlockSubAccountCall(Long userId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sub_accounts/{user_id}/unlock"
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call unlockSubAccountValidateBeforeCall(Long userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling unlockSubAccount(Async)");
        }

        okhttp3.Call localVarCall = unlockSubAccountCall(userId, _callback);
        return localVarCall;
    }

    /**
     * Unlock the sub-account
     * 
     * @param userId The user id of the sub-account (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Unlock successfully </td><td>  -  </td></tr>
     </table>
     */
    public void unlockSubAccount(Long userId) throws ApiException {
        unlockSubAccountWithHttpInfo(userId);
    }

    /**
     * Unlock the sub-account
     * 
     * @param userId The user id of the sub-account (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Unlock successfully </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> unlockSubAccountWithHttpInfo(Long userId) throws ApiException {
        okhttp3.Call localVarCall = unlockSubAccountValidateBeforeCall(userId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Unlock the sub-account (asynchronously)
     * 
     * @param userId The user id of the sub-account (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Unlock successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call unlockSubAccountAsync(Long userId, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = unlockSubAccountValidateBeforeCall(userId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

}
