/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.AgencyCommissionHistory;
import io.gate.gateapi.models.AgencyTransactionHistory;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebateApi {
    private ApiClient localVarApiClient;

    public RebateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RebateApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private okhttp3.Call agencyTransactionHistoryCall(String currencyPair, String userId, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rebate/agency/transaction_history";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("user_id", userId));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call agencyTransactionHistoryValidateBeforeCall(String currencyPair, String userId, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = agencyTransactionHistoryCall(currencyPair, userId, from, to, limit, offset, _callback);
        return localVarCall;
    }


    private ApiResponse<List<AgencyTransactionHistory>> agencyTransactionHistoryWithHttpInfo(String currencyPair, String userId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        okhttp3.Call localVarCall = agencyTransactionHistoryValidateBeforeCall(currencyPair, userId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<AgencyTransactionHistory>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call agencyTransactionHistoryAsync(String currencyPair, String userId, Long from, Long to, Integer limit, Integer offset, final ApiCallback<List<AgencyTransactionHistory>> _callback) throws ApiException {
        okhttp3.Call localVarCall = agencyTransactionHistoryValidateBeforeCall(currencyPair, userId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<AgencyTransactionHistory>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIagencyTransactionHistoryRequest {
        private String currencyPair;
        private String userId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIagencyTransactionHistoryRequest() {
        }

        /**
         * Set currencyPair
         * @param currencyPair Specify the currency pair, if not specified, return all currency pairs (optional)
         * @return APIagencyTransactionHistoryRequest
         */
        public APIagencyTransactionHistoryRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Set userId
         * @param userId User ID. If not specified, all user records will be returned (optional)
         * @return APIagencyTransactionHistoryRequest
         */
        public APIagencyTransactionHistoryRequest userId(String userId) {
            this.userId = userId;
            return this;
        }

        /**
         * Set from
         * @param from Time range beginning, default to 7 days before current time (optional)
         * @return APIagencyTransactionHistoryRequest
         */
        public APIagencyTransactionHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to Time range ending, default to current time (optional)
         * @return APIagencyTransactionHistoryRequest
         */
        public APIagencyTransactionHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIagencyTransactionHistoryRequest
         */
        public APIagencyTransactionHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIagencyTransactionHistoryRequest
         */
        public APIagencyTransactionHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Build call for agencyTransactionHistory
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return agencyTransactionHistoryCall(currencyPair, userId, from, to, limit, offset, _callback);
        }

        /**
         * Execute agencyTransactionHistory request
         * @return List&lt;AgencyTransactionHistory&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<AgencyTransactionHistory> execute() throws ApiException {
            ApiResponse<List<AgencyTransactionHistory>> localVarResp = agencyTransactionHistoryWithHttpInfo(currencyPair, userId, from, to, limit, offset);
            return localVarResp.getData();
        }

        /**
         * Execute agencyTransactionHistory request with HTTP info returned
         * @return ApiResponse&lt;List&lt;AgencyTransactionHistory&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<AgencyTransactionHistory>> executeWithHttpInfo() throws ApiException {
            return agencyTransactionHistoryWithHttpInfo(currencyPair, userId, from, to, limit, offset);
        }

        /**
         * Execute agencyTransactionHistory request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<AgencyTransactionHistory>> _callback) throws ApiException {
            return agencyTransactionHistoryAsync(currencyPair, userId, from, to, limit, offset, _callback);
        }
    }

    /**
     * The broker obtains the transaction history of the recommended user
     * Record time range cannot exceed 30 days
     * @return APIagencyTransactionHistoryRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIagencyTransactionHistoryRequest agencyTransactionHistory() {
        return new APIagencyTransactionHistoryRequest();
    }

    private okhttp3.Call agencyCommissionsHistoryCall(String currency, String userId, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rebate/agency/commission_history";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("user_id", userId));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call agencyCommissionsHistoryValidateBeforeCall(String currency, String userId, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = agencyCommissionsHistoryCall(currency, userId, from, to, limit, offset, _callback);
        return localVarCall;
    }


    private ApiResponse<List<AgencyCommissionHistory>> agencyCommissionsHistoryWithHttpInfo(String currency, String userId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        okhttp3.Call localVarCall = agencyCommissionsHistoryValidateBeforeCall(currency, userId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<AgencyCommissionHistory>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call agencyCommissionsHistoryAsync(String currency, String userId, Long from, Long to, Integer limit, Integer offset, final ApiCallback<List<AgencyCommissionHistory>> _callback) throws ApiException {
        okhttp3.Call localVarCall = agencyCommissionsHistoryValidateBeforeCall(currency, userId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<AgencyCommissionHistory>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIagencyCommissionsHistoryRequest {
        private String currency;
        private String userId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIagencyCommissionsHistoryRequest() {
        }

        /**
         * Set currency
         * @param currency Filter by currency. Return all currency records if not specified (optional)
         * @return APIagencyCommissionsHistoryRequest
         */
        public APIagencyCommissionsHistoryRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set userId
         * @param userId User ID. If not specified, all user records will be returned (optional)
         * @return APIagencyCommissionsHistoryRequest
         */
        public APIagencyCommissionsHistoryRequest userId(String userId) {
            this.userId = userId;
            return this;
        }

        /**
         * Set from
         * @param from Time range beginning, default to 7 days before current time (optional)
         * @return APIagencyCommissionsHistoryRequest
         */
        public APIagencyCommissionsHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to Time range ending, default to current time (optional)
         * @return APIagencyCommissionsHistoryRequest
         */
        public APIagencyCommissionsHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIagencyCommissionsHistoryRequest
         */
        public APIagencyCommissionsHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIagencyCommissionsHistoryRequest
         */
        public APIagencyCommissionsHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Build call for agencyCommissionsHistory
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return agencyCommissionsHistoryCall(currency, userId, from, to, limit, offset, _callback);
        }

        /**
         * Execute agencyCommissionsHistory request
         * @return List&lt;AgencyCommissionHistory&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<AgencyCommissionHistory> execute() throws ApiException {
            ApiResponse<List<AgencyCommissionHistory>> localVarResp = agencyCommissionsHistoryWithHttpInfo(currency, userId, from, to, limit, offset);
            return localVarResp.getData();
        }

        /**
         * Execute agencyCommissionsHistory request with HTTP info returned
         * @return ApiResponse&lt;List&lt;AgencyCommissionHistory&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<AgencyCommissionHistory>> executeWithHttpInfo() throws ApiException {
            return agencyCommissionsHistoryWithHttpInfo(currency, userId, from, to, limit, offset);
        }

        /**
         * Execute agencyCommissionsHistory request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<AgencyCommissionHistory>> _callback) throws ApiException {
            return agencyCommissionsHistoryAsync(currency, userId, from, to, limit, offset, _callback);
        }
    }

    /**
     * The broker obtains the commission history of the recommended user
     * Record time range cannot exceed 30 days
     * @return APIagencyCommissionsHistoryRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIagencyCommissionsHistoryRequest agencyCommissionsHistory() {
        return new APIagencyCommissionsHistoryRequest();
    }

}
